/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.engine.warehouse;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.compiere.model.MLocator;
import org.compiere.model.MStorage;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.eevolution.engine.warehouse.WMRuleInterface;
import org.eevolution.model.MWMArea;
import org.eevolution.model.MWMSection;
import org.eevolution.model.MWMSectionDetail;

public class WMRuleFIFO
implements WMRuleInterface {
    @Override
    public Collection<MLocator> getLocator(Properties properties, int n, int n2, int n3, int n4, String string) {
        ArrayList<MLocator> arrayList = new ArrayList<MLocator>();
        Collection<MWMArea> collection = MWMArea.getMWMArea(properties, n, string);
        for (MWMArea mWMArea : collection) {
            Collection<MWMSection> collection2 = mWMArea.getWMSection(n4);
            for (MWMSection mWMSection : collection2) {
                arrayList.addAll(MWMSectionDetail.getMLocators(mWMSection));
            }
        }
        return arrayList;
    }

    @Override
    public Collection<MStorage> getStorage(Properties properties, int n, int n2, int n3, BigDecimal bigDecimal, int n4, int n5, String string) {
        ArrayList<MStorage> arrayList = new ArrayList<MStorage>();
        for (MWMArea mWMArea : MWMArea.getMWMArea(properties, n, string)) {
            for (MWMSection mWMSection : mWMArea.getWMSection(n5)) {
                for (MLocator mLocator : MWMSectionDetail.getMLocators(mWMSection)) {
                    arrayList.addAll(this.getWarehouse(properties, n, n2, n3, true, true, mLocator.getM_Locator_ID(), string));
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection<MStorage> getWarehouse(Properties properties, int n, int n2, int n3, boolean bl, boolean bl2, int n4, String string) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        ArrayList<MStorage> arrayList = new ArrayList<MStorage>();
        if (n == 0 && n4 == 0 || n2 == 0) {
            return arrayList;
        }
        boolean bl3 = false;
        if (n3 == 0) {
            bl3 = true;
        }
        String string2 = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.QtyReserved,s.QtyOrdered,s.DateLastInventory FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) ";
        string2 = n4 > 0 ? string2 + "WHERE l.M_Locator_ID = ?" : string2 + "WHERE l.M_Warehouse_ID=?";
        string2 = string2 + " AND s.M_Product_ID=? AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
        string2 = bl2 ? string2 + " AND s.QtyOnHand > 0 " : string2 + " AND s.QtyOnHand <> 0 ";
        string2 = string2 + "ORDER BY l.PriorityNo DESC, M_AttributeSetInstance_ID";
        if (!bl) {
            string2 = string2 + " DESC";
        }
        if (bl3) {
            string2 = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.QtyReserved,s.QtyOrdered,s.DateLastInventory FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) ";
            string2 = n4 > 0 ? string2 + "WHERE l.M_Locator_ID = ?" : string2 + "WHERE l.M_Warehouse_ID=?";
            string2 = string2 + " AND s.M_Product_ID=? ";
            string2 = bl2 ? string2 + " AND s.QtyOnHand > 0 " : string2 + " AND s.QtyOnHand <> 0 ";
            if (timestamp != null) {
                string2 = string2 + "AND (asi.GuaranteeDate IS NULL OR asi.GuaranteeDate>?) ";
                string2 = string2 + "ORDER BY l.PriorityNo DESC, asi.GuaranteeDate, M_AttributeSetInstance_ID";
                if (!bl) {
                    string2 = string2 + " DESC";
                }
                string2 = string2 + ", s.QtyOnHand DESC";
            } else {
                string2 = string2 + "ORDER BY l.PriorityNo DESC, l.M_Locator_ID, s.M_AttributeSetInstance_ID";
                if (!bl) {
                    string2 = string2 + " DESC";
                }
                string2 = string2 + ", s.QtyOnHand DESC";
            }
        }
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(string2, string);
            cPreparedStatement.setInt(1, n4 > 0 ? n4 : n);
            cPreparedStatement.setInt(2, n2);
            if (!bl3) {
                cPreparedStatement.setInt(3, n3);
            } else if (timestamp != null) {
                cPreparedStatement.setTimestamp(3, timestamp);
            }
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                if (resultSet.getBigDecimal(11).signum() == 0) continue;
                arrayList.add(new MStorage(properties, resultSet, string));
            }
        }
        catch (Exception exception) {
            DB.close(resultSet, cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        return arrayList;
    }
}

