/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.engine.forecast;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.MultipleLinearRegressionModel;
import org.eevolution.engine.forecast.DataElement;
import org.eevolution.engine.forecast.DataSet;
import org.eevolution.engine.forecast.ForecastRule;

public class MultipleLinearRegression
implements ForecastRule {
    private net.sourceforge.openforecast.DataSet forecastData = null;
    private DataSet forecastDataResult = null;
    private String key = null;
    private double factorAlpha = 0.0;
    private double factorGamma = 0.0;
    private double factorMultiplier = 0.0;
    private double factorScale = 0.0;
    private double factorBeta = 0.0;
    private double factorUser = 0.0;

    @Override
    public void setDataSet(DataSet series, double factorAlpha, double factorGamma, double factorBeta, double factorMultiplier, double factorScale, double factorUser) {
        this.factorAlpha = factorAlpha;
        this.factorGamma = factorGamma;
        this.factorBeta = factorBeta;
        this.factorMultiplier = factorMultiplier;
        this.factorScale = factorScale;
        this.factorUser = factorUser;
        net.sourceforge.openforecast.DataSet observedData = new net.sourceforge.openforecast.DataSet();
        Enumeration<DataElement> elements = series.getDataElements();
        while (elements.hasMoreElements()) {
            DataElement element = elements.nextElement();
            BigDecimal value = (BigDecimal)element.getValue();
            Observation dp = new Observation(value.doubleValue());
            dp.setIndependentValue(element.getKey().toString(), (double)element.getPeriodNo().intValue());
            observedData.add((DataPoint)dp);
        }
        String[] independentVariable = observedData.getIndependentVariables();
        MultipleLinearRegressionModel model = null;
        ArrayList<String> availableVariables = new ArrayList<String>(independentVariable.length);
        for (int i = 0; i < independentVariable.length; ++i) {
            availableVariables.add(independentVariable[i]);
        }
        ArrayList<String> bestVariables = new ArrayList<String>(independentVariable.length);
        while (availableVariables.size() > 0) {
            int count = bestVariables.size();
            String[] workingList = new String[count + 1];
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    workingList[i] = (String)bestVariables.get(i);
                }
            }
            String bestAvailVariable = null;
            Iterator it = availableVariables.iterator();
            while (it.hasNext()) {
                String currentVar;
                workingList[count] = currentVar = (String)it.next();
                model = new MultipleLinearRegressionModel(workingList);
                model.init(observedData);
                bestAvailVariable = currentVar;
                workingList[count] = null;
            }
            if (bestAvailVariable == null) break;
            int bestVarIndex = availableVariables.indexOf(bestAvailVariable);
            availableVariables.remove(bestVarIndex);
            bestVariables.add(count, bestAvailVariable);
            ++count;
        }
        this.forecastData = model.forecast(observedData);
    }

    @Override
    public DataSet getForecast() {
        this.forecastDataResult = new DataSet();
        for (DataPoint dp : this.forecastData) {
            int peridoNo = (int)dp.getIndependentValue(this.getKey());
            BigDecimal calculateQty = new BigDecimal(dp.getDependentValue());
            DataElement data = new DataElement(new Integer(this.getKey()), peridoNo, calculateQty, calculateQty.toString());
            this.forecastDataResult.addDataElement(data);
        }
        return this.forecastDataResult;
    }

    @Override
    public void setKey(String M_Product_ID) {
        this.key = M_Product_ID;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setFactorAlpha(double alphaTolerance) {
        this.factorAlpha = alphaTolerance;
    }

    @Override
    public double getFactorAlpha() {
        return this.factorAlpha;
    }

    @Override
    public void setFactorGamma(double gammaTolerance) {
        this.factorGamma = gammaTolerance;
    }

    @Override
    public double getFactorGamma() {
        return this.factorGamma;
    }

    @Override
    public void setFactorBeta(double factorBeta) {
        this.factorBeta = factorBeta;
    }

    @Override
    public double getFactorBeta() {
        return this.factorBeta;
    }

    @Override
    public void setFactorUser(double factorUser) {
        this.factorUser = factorUser;
    }

    @Override
    public double getFactorUser() {
        return this.factorUser;
    }

    @Override
    public void setFactorMultiplier(double factorMultiplier) {
        this.factorMultiplier = factorMultiplier;
    }

    @Override
    public double getFactorMultiplier() {
        return this.factorMultiplier;
    }

    @Override
    public void setFactorScale(double factorScale) {
        this.factorScale = factorScale;
    }

    @Override
    public double getFactorScale() {
        return this.factorScale;
    }
}

