/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetChange;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_A_Asset_Dep;
import org.compiere.model.X_A_Asset_Forecast;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModDPPReplenish
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModDPPReplenish.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("A_Asset_Dep", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        X_A_Asset_Dep assetDep;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 5 && po.get_Table_ID() == X_A_Asset_Dep.Table_ID && (assetDep = (X_A_Asset_Dep)po).getDocStatus().compareTo("CO") == 0) {
            String sql = "SELECT jo.A_Asset_ID, C.A_Asset_Acct_ID FROM A_Asset_Dep ad INNER JOIN GL_JournalBatch jb ON (ad.GL_JournalBatch_ID = jb.GL_JournalBatch_ID) INNER JOIN GL_Journal jo ON (jb.GL_JournalBatch_ID = jo.GL_JournalBatch_ID) INNER JOIN A_Asset_Acct C on (jo.A_Asset_ID=C.A_Asset_ID) WHERE A_Asset_Dep_ID = ?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, po.get_TrxName());
                pstmt.setInt(1, assetDep.get_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_A_Asset asset = new X_A_Asset(po.getCtx(), rs.getInt(1), po.get_TrxName());
                    MDepreciationWorkfile workfile = MAsset.getWorkFile(rs.getInt(1));
                    MAssetAcct acct = new MAssetAcct(po.getCtx(), rs.getInt(2), po.get_TrxName());
                    if (workfile == null || workfile.getA_Period_Posted() == acct.getA_Period_End()) continue;
                    this.replanningForecast(asset, workfile.getA_Asset_Cost().subtract(workfile.getA_Accumulated_Depr()), acct, workfile.getA_Period_Posted(), DB.getSQLValueTS(po.get_TrxName(), "select max(datedoc) from a_asset_forecast where corrected='Y' and A_Asset_ID=" + rs.getInt(1), new Object[0]), po.get_TrxName());
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    public static void createForecast(X_A_Asset asset, MAssetChange change, MAssetAcct acct, String trxName) {
        BigDecimal SalvageAmt = acct.getA_Salvage_Value();
        BigDecimal Currentamt = change.getAssetValueAmt();
        if (!acct.get_ValueAsBoolean("IsByYear")) {
            int i = 1;
            while (i < acct.getA_Period_End() + 1) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, trxName);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                cal.add(2, i);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i);
                BigDecimal amtAcct = Currentamt.divide(new BigDecimal(acct.getA_Period_End()), 2, 1);
                if (i == acct.getA_Period_End()) {
                    amtAcct = amtAcct.subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++i;
            }
        } else {
            int i = 0;
            while (i < asset.getUseLifeYears()) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, trxName);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                cal.set(2, 11);
                cal.set(5, 1);
                cal.add(1, i);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i + 1);
                acct.save();
                BigDecimal divisor = new BigDecimal("0.0");
                divisor = acct.get_ValueAsBoolean("IsByYear") ? new BigDecimal(asset.getUseLifeYears()) : new BigDecimal(acct.getA_Period_End());
                BigDecimal amtAcct = Currentamt.divide(divisor, 2, 1);
                if (i + 1 == acct.getA_Period_End()) {
                    amtAcct = amtAcct.subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++i;
            }
        }
    }

    public void replanningForecast(X_A_Asset asset, BigDecimal Amount, MAssetAcct acct, int Period, Timestamp lastdate, String trxName) {
        BigDecimal SalvageAmt = acct.getA_Salvage_Value();
        BigDecimal Currentamt = Amount;
        Currentamt = Currentamt.divide(new BigDecimal(acct.getA_Period_End() - Period), 2, 1);
        DB.executeUpdate("Update A_Asset_Forecast set amount=" + Currentamt + " Where Processed='N' AND A_Asset_ID=" + asset.getA_Asset_ID(), trxName);
        if (asset.isInPosession()) {
            DB.executeUpdate("Delete from A_Asset_Forecast where Processed='N' and Corrected='N' and A_Asset_ID=" + asset.getA_Asset_ID(), trxName);
            Period = DB.getSQLValue(trxName, "select max(PeriodNo) from a_asset_forecast where corrected='Y' and A_Asset_ID=" + asset.getA_Asset_ID());
        } else {
            DB.executeUpdate("Delete from A_Asset_Forecast where Processed='N' and A_Asset_ID=" + asset.getA_Asset_ID(), trxName);
        }
        int mes = 1;
        if (!acct.get_ValueAsBoolean("IsByYear")) {
            int i = Period + 1;
            while (i < acct.getA_Period_End() + 1) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, null);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                if (lastdate == null) {
                    cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                } else {
                    cal.setTimeInMillis(lastdate.getTime());
                }
                cal.add(2, mes);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i);
                BigDecimal amtAcct = Currentamt;
                if (i == acct.getA_Period_End()) {
                    amtAcct = amtAcct.subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++mes;
                ++i;
            }
        } else {
            int i = Period + 1;
            while (i < asset.getUseLifeYears() + 1) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, null);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                if (lastdate == null) {
                    cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                } else {
                    cal.setTimeInMillis(lastdate.getTime());
                }
                cal.add(1, mes);
                cal.set(2, 11);
                cal.set(5, 1);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i);
                BigDecimal amtAcct = Currentamt;
                if (i == acct.getA_Period_End()) {
                    amtAcct = amtAcct.subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++mes;
                ++i;
            }
        }
    }
}

