/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.utils;

public class SectorzonaSet {
    private String[] sectorzonas;

    public SectorzonaSet(String _Rangestr) throws Exception {
        this.setSectorzonas(this.toArray(_Rangestr));
    }

    private String[] toArray(String _Rangestr) throws Exception {
        String[] arr = _Rangestr.split(",");
        int i = 0;
        while (i < arr.length) {
            arr[i] = arr[i].trim();
            if (!this.validateSectorzonaRange(arr[i])) {
                throw new Exception("Formato inv\u00e1lido de sectorzona");
            }
            ++i;
        }
        return arr;
    }

    public boolean contains(String sectorzona) throws Exception {
        String[] arr = this.getSectorzonas();
        int i = 0;
        while (i < arr.length) {
            if (this.matchSectorzone(arr[i], sectorzona)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getSectorzonas() {
        return this.sectorzonas;
    }

    public void setSectorzonas(String[] sectorzona) {
        this.sectorzonas = sectorzona;
    }

    private boolean matchSectorzone(String range, String sz) throws Exception {
        String[] sectorzona = range.split(":");
        if (sectorzona.length == 1) {
            return sz == range;
        }
        int lowend = Integer.parseInt(sectorzona[0].replaceFirst("-", ""));
        int highend = Integer.parseInt(sectorzona[1].replaceFirst("-", ""));
        int number = Integer.parseInt(sz.replaceFirst("-", ""));
        return number >= lowend && number <= highend;
    }

    private boolean validateSectorzonaRange(String szrange) throws Exception {
        String[] arr = szrange.split(":");
        if (arr.length > 2) {
            return false;
        }
        int i = 0;
        while (i < arr.length) {
            if (!this.validateSectorzona(arr[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean validateSectorzona(String sz) throws Exception {
        String[] arr = sz.split("-");
        if (arr.length != 2) {
            return false;
        }
        int sector = Integer.parseInt(arr[0]);
        int zona = Integer.parseInt(arr[1]);
        return sector >= 0 && sector <= 99 && zona >= 0 && zona <= 99;
    }
}

