/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class UpdateDateEndOLineHeader
extends SvrProcess {
    private int id_Order;
    private Timestamp p_DatePromised;

    @Override
    protected void prepare() {
        this.id_Order = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (para[i].getParameterName().equals("DatePromised")) {
                    this.p_DatePromised = para[i].getParameterAsTimestamp();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MOrder order = new MOrder(this.getCtx(), this.id_Order, this.get_TrxName());
        String msg = "";
        if (order.getDocStatus().compareTo("DR") == 0 || order.getDocStatus().compareTo("IP") == 0 || order.getDocStatus().compareTo("IN") == 0) {
            MOrderLine[] lines = order.getLines(true, null);
            int i = 0;
            while (i < lines.length) {
                Timestamp dateStart;
                MOrderLine oLine = lines[i];
                if (!oLine.get_ValueAsBoolean("IsFree") && oLine.getM_Product_ID() > 0 && oLine.getPriceEntered().compareTo(Env.ONE) > 0 && (dateStart = (Timestamp)oLine.get_Value("DatePromised2")) != null && this.p_DatePromised.compareTo(dateStart) > 0) {
                    int dayInicial = dateStart.getDate();
                    int dayNew = this.p_DatePromised.getDate();
                    int CorrectDay = dayInicial - 1;
                    if (CorrectDay <= 0) {
                        if (dayNew < 28) {
                            throw new AdempiereException("Error: Dia de termino incorrecto.");
                        }
                    } else if (dayNew != dayInicial - 1) {
                        throw new AdempiereException("Error: Dia debe ser " + CorrectDay);
                    }
                    BigDecimal newAmt = null;
                    Timestamp dateEnd = (Timestamp)oLine.get_Value("DatePromised3");
                    BigDecimal dif1 = new BigDecimal(dateEnd.getTime() - dateStart.getTime() + 86400000L);
                    BigDecimal dif2 = new BigDecimal(this.p_DatePromised.getTime() - dateStart.getTime() + 86400000L);
                    BigDecimal factor = dif2.divide(dif1, 8, 4);
                    newAmt = oLine.getPriceEntered().multiply(factor);
                    newAmt = newAmt.setScale(2, 4);
                    oLine.setPrice(newAmt);
                    oLine.setLineNetAmt();
                    oLine.setTax();
                    oLine.set_CustomColumn("DatePromised3", this.p_DatePromised);
                    oLine.save();
                    msg = "Precio Actualizado";
                }
                ++i;
            }
        }
        return msg;
    }
}

