/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ShipGenerateCopesa
extends SvrProcess {
    private Timestamp p_DateShip = null;
    private Timestamp p_DateShip_To = null;
    private Timestamp p_DateTrx_To = null;
    private int p_C_BPartner_ID = 0;
    private int p_C_Order_ID = 0;
    private int m_created = 0;
    private int m_line = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("MovementDate")) {
                    this.p_DateShip = para[i].getParameterAsTimestamp();
                    this.p_DateShip_To = para[i].getParameterToAsTimestamp();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Order_ID")) {
                    this.p_C_Order_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateTrx")) {
                    this.p_DateTrx_To = para[i].getParameterAsTimestamp();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.m_created = 0;
        this.m_line = 0;
        String sqlGancho = "SELECT C_OrderLine_ID  FROM C_OrderLine ol INNER JOIN C_Order co ON (ol.C_Order_ID = co.C_Order_ID)  LEFT JOIN M_Product mp ON (ol.M_Product_ID = mp.M_Product_ID) LEFT JOIN M_Product_Category pc ON (mp.M_Product_Category_ID = pc.M_Product_Category_ID) WHERE co.DocStatus IN ('CO','CL') AND ol.IsActive = 'Y' AND upper(pc.value) like '%NOEDITO%' AND ol.C_OrderLine_ID NOT IN  (SELECT mio.C_OrderLine_ID FROM M_InOutLine mio WHERE mio.C_OrderLine_ID IS NOT NULL AND mio.IsActive = 'Y')";
        if (this.p_C_Order_ID > 0) {
            sqlGancho = String.valueOf(sqlGancho) + " AND ol.C_Order_ID = " + this.p_C_Order_ID;
        }
        if (this.p_C_BPartner_ID > 0) {
            sqlGancho = String.valueOf(sqlGancho) + " AND co.C_BPartner_ID = " + this.p_C_BPartner_ID;
        }
        if (this.p_DateShip != null && this.p_DateShip_To != null) {
            sqlGancho = String.valueOf(sqlGancho) + " AND ol.MovementDate BETWEEN ? AND ? ";
        }
        sqlGancho = String.valueOf(sqlGancho) + " ORDER BY co.C_Order_ID, ol.M_Shipper_ID, ol.C_BpartnerRef_ID, " + " ol.C_BPartner_Location_ID, ol.MovementDate ";
        CPreparedStatement pstmtGancho = DB.prepareStatement(sqlGancho, this.get_TrxName());
        if (this.p_DateShip != null && this.p_DateShip_To != null) {
            pstmtGancho.setTimestamp(1, this.p_DateShip);
            pstmtGancho.setTimestamp(2, this.p_DateShip_To);
        }
        try {
            ResultSet rsGancho = pstmtGancho.executeQuery();
            int LastOrder_ID = 0;
            int LastShipper_ID = 0;
            int LastBPartner_ID = 0;
            int LastBPartnertLoc_ID = 0;
            long LastmovDate = 0L;
            MInOut ship = null;
            boolean createShip = true;
            while (rsGancho.next()) {
                MOrderLine oLine = new MOrderLine(this.getCtx(), rsGancho.getInt("C_OrderLine_ID"), this.get_TrxName());
                MOrder order = oLine.getParent();
                if (LastShipper_ID != oLine.get_ValueAsInt("M_Shipper_ID") || LastOrder_ID != oLine.getC_Order_ID() || LastBPartner_ID != oLine.get_ValueAsInt("C_BpartnerRef_ID") || LastBPartnertLoc_ID != oLine.get_ValueAsInt("C_Bpartner_Location_ID") || LastmovDate != ((Timestamp)oLine.get_Value("MovementDate")).getTime()) {
                    LastShipper_ID = oLine.get_ValueAsInt("M_Shipper_ID");
                    LastOrder_ID = oLine.getC_Order_ID();
                    LastBPartner_ID = oLine.get_ValueAsInt("C_BpartnerRef_ID");
                    LastBPartnertLoc_ID = oLine.get_ValueAsInt("C_Bpartner_Location_ID");
                    LastmovDate = ((Timestamp)oLine.get_Value("MovementDate")).getTime();
                    createShip = true;
                }
                if (createShip) {
                    ship = this.p_DateTrx_To != null ? new MInOut(order, 0, this.p_DateTrx_To) : new MInOut(order, 0, (Timestamp)oLine.get_Value("MovementDate"));
                    ship.setDeliveryViaRule(oLine.get_ValueAsString("DeliveryViaRule"));
                    ship.setM_Shipper_ID(oLine.get_ValueAsInt("M_Shipper_ID"));
                    ship.save();
                    createShip = false;
                    ++this.m_created;
                }
                MInOutLine ioLine = new MInOutLine(ship);
                ioLine.setM_Product_ID(oLine.getM_Product_ID());
                ioLine.setQty(oLine.getQtyEntered());
                ioLine.setC_OrderLine_ID(oLine.get_ID());
                ioLine.setM_Locator_ID(oLine.get_ValueAsInt("M_Locator_ID"));
                ioLine.save();
                ++this.m_line;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sqlGancho, e);
        }
        return "Se han generado " + this.m_created + " guias y " + this.m_line + " Lineas";
    }
}

