/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import org.compiere.model.X_R_ServiceRequest;
import org.compiere.model.X_R_ServiceRequestChange;
import org.compiere.model.X_R_ServiceRequestLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.wf.MWFNode;
import org.copesa.model.COPESASROps;
import org.copesa.nodeaction.NodeAction;

public class ProcessServiceRequest
extends SvrProcess {
    private int ID_Request;

    @Override
    protected void prepare() {
        this.ID_Request = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        try {
            this.log.fine("Process Service Request");
            X_R_ServiceRequest sReq = new X_R_ServiceRequest(this.getCtx(), this.ID_Request, this.get_TrxName());
            X_R_ServiceRequestChange srChange = new X_R_ServiceRequestChange(this.getCtx(), 0, this.get_TrxName());
            srChange.setR_ServiceRequest_ID(sReq.get_ID());
            srChange.setSR_AccountType(sReq.getSR_AccountType());
            srChange.setSR_Amt(sReq.getSR_Amt());
            srChange.setSR_BPartner_Loaction_ID(sReq.getSR_BPartner_Loaction_ID());
            srChange.setSR_ChargeDate(sReq.getSR_ChargeDate());
            srChange.setSR_Comments(sReq.getSR_Comments());
            srChange.setSR_CorrectValue(sReq.getSR_CorrectValue());
            srChange.setSR_CreditCardDueDate(sReq.getSR_CreditCardDueDate());
            srChange.setSR_Date(sReq.getSR_Date());
            srChange.setSR_Description(sReq.getSR_Description());
            srChange.setSR_DueDate(sReq.getSR_DueDate());
            srChange.setSR_EditionNo(sReq.getSR_EditionNo());
            srChange.setSR_EMail(sReq.getSR_EMail());
            srChange.setSR_InvoiceNo(sReq.getSR_InvoiceNo());
            srChange.setSR_Last4Digits(sReq.getSR_Last4Digits());
            srChange.setSR_Name(sReq.getSR_Name());
            srChange.setSR_OperationNo(sReq.getSR_OperationNo());
            srChange.setSR_PartialOrTotal(sReq.getSR_PartialOrTotal());
            srChange.setSR_Phone(sReq.getSR_Phone());
            srChange.setSR_Reason(sReq.getSR_Reason());
            srChange.setSR_Reference(sReq.getSR_Reference());
            srChange.setSR_User_ID(sReq.getSR_User_ID());
            srChange.setZone(sReq.getZone());
            srChange.setSector(sReq.getSector());
            srChange.setDate1(new Timestamp(new Date().getTime()));
            srChange.setHours1(new Timestamp(new Date().getTime()));
            srChange.setAD_UserRef_ID(sReq.getAD_User_ID());
            srChange.setDocStatus(sReq.getDocStatus());
            MWFNode nodeOld = new MWFNode(this.getCtx(), sReq.get_ValueAsInt("AD_WF_Node_ID"), this.get_TrxName());
            int ID_Role = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(AD_Role_ID) FROM AD_WF_Node_AccessCOPESA  WHERE AD_WF_Node_ID = " + nodeOld.get_ID() + " AND IsActive = 'Y'");
            if (ID_Role > 0) {
                srChange.setAD_Role_ID(ID_Role);
            }
            srChange.setAD_User_ID(Env.getAD_User_ID(this.getCtx()));
            srChange.setAD_WF_Node_ID(sReq.getAD_WF_NextNode_ID());
            srChange.setAD_WF_OldNode_ID(sReq.getAD_WF_Node_ID());
            Timestamp lastDate = DB.getSQLValueTS(this.get_TrxName(), "SELECT MAX(created) FROM R_ServiceRequestChange WHERE R_ServiceRequest_ID = ? AND IsActive = 'Y'", sReq.get_ID());
            if (lastDate != null) {
                long dif = new Timestamp(new Date().getTime()).getTime() - lastDate.getTime();
                srChange.setDifferenceStatus(new BigDecimal(dif /= 60000L));
            }
            int nodeid = sReq.get_ValueAsInt("AD_WF_NextNode_ID");
            MWFNode node = new MWFNode(this.getCtx(), sReq.get_ValueAsInt("AD_WF_NextNode_ID"), this.get_TrxName());
            sReq.set_CustomColumn("AD_WF_Node_ID", nodeid);
            sReq.set_CustomColumn("AD_WF_NextNode_ID", null);
            sReq.set_CustomColumn("Help", node.getHelp());
            if (node.get_ValueAsString("RequestAcction") != null && node.get_ValueAsString("RequestAcction").trim().length() > 0) {
                this.generateAction(sReq, node.get_ValueAsString("RequestAcction"));
            }
            if (node.get_ValueAsString("Status") != null && node.get_ValueAsString("Status").trim().length() > 0) {
                sReq.setDocStatus(node.get_ValueAsString("Status"));
                sReq.setProcessed(true);
                srChange.setCloseDate(new Timestamp(new Date().getTime()));
            }
            COPESASROps.assignUser(sReq, nodeid);
            srChange.save();
            sReq.save();
            return "Procesado";
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
            throw new AdempiereUserError("No se pudo procesar SR correctamente. " + e.getMessage());
        }
    }

    public void generateAction(X_R_ServiceRequest req, String action) throws Exception {
        NodeAction nodeaction = new NodeAction();
        if (action.compareTo("G") == 0 || action.compareTo("B") == 0 || action.compareTo("Y") == 0 || action.compareTo("M") == 0) {
            nodeaction.execute(req, null, action);
        } else {
            String sql = " SELECT R_ServiceRequestLine_ID  FROM R_ServiceRequestLine WHERE IsActive = 'Y'  AND R_ServiceRequest_ID = " + req.get_ID();
            CPreparedStatement pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_R_ServiceRequestLine rLine = new X_R_ServiceRequestLine(this.getCtx(), rs.getInt("R_ServiceRequestLine_ID"), this.get_TrxName());
                nodeaction.execute(req, rLine, action);
            }
        }
    }
}

