/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.copesa.model.COPESAOrderOps;
import org.copesa.utils.DateUtils;

public class ProcessSalesOrderCOPESA
extends SvrProcess {
    private int id_SOrder;
    private String p_DocStatus;

    @Override
    protected void prepare() {
        this.id_SOrder = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (para[i].getParameterName().equals("DocStatus")) {
                    this.p_DocStatus = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String doIt() throws Exception {
        MOrder order = new MOrder(this.getCtx(), this.id_SOrder, this.get_TrxName());
        Timestamp hoy = DateUtils.today();
        Timestamp instant = DateUtils.now();
        if (order.getDocStatus().compareTo("CO") == 0 || order.getDocStatus().compareTo("VO") == 0) return "Procesado";
        this.validFields(order);
        order.set_CustomColumn("DateCompleted", instant);
        order.setDateOrdered(instant);
        MRole rol = new MRole(this.getCtx(), Env.getAD_Role_ID(this.getCtx()), this.get_TrxName());
        if (!order.isSOTrx()) return "Procesado";
        if (this.p_DocStatus.compareTo("CO") == 0) {
            int cantMounthly;
            String PaymentRule2;
            int cant;
            MPriceList pList;
            boolean ISSameBPLocator;
            MOrderLine[] oLines = order.getLines(false, null);
            int i = 0;
            while (i < oLines.length) {
                Timestamp newDate;
                MOrderLine lineAfter;
                Timestamp dateStartAfter;
                MOrderLine line = oLines[i];
                Timestamp dateStart = (Timestamp)line.get_Value("DatePromised2");
                Timestamp dateEnd = (Timestamp)line.get_Value("DatePromised3");
                if (line.get_ValueAsInt("C_OrderLineRef_ID") > 0 && line.get_ValueAsBoolean("IsFree") && (dateStartAfter = (Timestamp)(lineAfter = new MOrderLine(this.getCtx(), line.get_ValueAsInt("C_OrderLineRef_ID"), this.get_TrxName())).get_Value("DatePromised2")).compareTo(newDate = DateUtils.nextDay(dateEnd)) != 0) {
                    throw new AdempiereException("Error: Fecha de Linea " + lineAfter.getLine() + " incorrecta");
                }
                ++i;
            }
            if (order.getPaymentRule().compareToIgnoreCase("I") == 0 && order.get_ValueAsString("TypePaymentRule").compareTo("E") != 0) {
                String ref = null;
                ref = order.get_ValueAsString("POReference2");
                if (!(order.getPOReference() != null && order.getPOReference().trim() != "" || ref != null && ref.trim() != "")) {
                    throw new AdempiereException("Error: Termino de pago necesita HES/OC");
                }
            }
            if ((ISSameBPLocator = (pList = new MPriceList(this.getCtx(), order.getM_PriceList_ID(), this.get_TrxName())).get_ValueAsBoolean("IsSameBPLocator")) && (cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(DISTINCT(C_BPartner_Location_ID))  FROM C_OrderLine WHERE C_Order_ID = " + order.get_ID())) > 1) {
                throw new AdempiereException("Error: Direcciones no concordantes");
            }
            cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM C_OrderLine col INNER JOIN M_Product mp ON (col.M_Product_ID = mp.M_Product_ID)  INNER JOIN M_Product_Category mpc ON (mp.M_Product_Category_ID = mpc.M_Product_Category_ID)  WHERE C_Order_ID = " + order.get_ID() + " AND col.C_CalendarCOPESA_ID IS NULL " + " AND upper(mpc.description) like '%EDITORIAL%'");
            if (cant > 0) {
                throw new AdempiereException("Error: Calendario faltante en las lineas");
            }
            if (pList.get_ValueAsString("PaymentRule") != null && pList.get_ValueAsString("PaymentRule").length() > 0 && pList.get_ValueAsString("PaymentRule") != "" && pList.get_ValueAsString("PaymentRule") != " " && (PaymentRule2 = order.get_ValueAsString("TypePaymentRule")) != null && PaymentRule2.compareToIgnoreCase(pList.get_ValueAsString("PaymentRule")) != 0) {
                String namePRule = DB.getSQLValueString(this.get_TrxName(), "SELECT rlt.NAME  FROM AD_Ref_List rl  INNER JOIN AD_Ref_List_Trl rlt ON(rlt.AD_Ref_List_ID = rl.AD_Ref_List_ID AND AD_Language='es_MX')  WHERE AD_Reference_ID = 195 AND rl.value = '" + pList.get_ValueAsString("PaymentRule") + "'", new Object[0]);
                throw new AdempiereException("Error: Regla de pago debe ser " + namePRule);
            }
            int cantV2 = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM C_OrderLine  WHERE C_Order_ID = " + order.get_ID() + "AND C_BPartnerRef_ID IS NOT NULL " + " AND C_BPartnerRef_ID NOT IN ( " + " SELECT C_BPartnerRef_ID FROM C_BPartnerRelated " + " WHERE C_BPartner_ID = " + order.getC_BPartner_ID() + " AND IsActive = 'Y' AND C_BPartnerRef_ID IS NOT NULL)");
            if (cantV2 > 0) {
                throw new AdempiereException("Error: Socio de negocio de linea no pertenece a cliente de facturaci\u00f3n");
            }
            if (order.getPaymentRule().compareTo("D") == 0 && (cantMounthly = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM C_OrderLine ol  INNER JOIN M_Product mp ON (ol.M_Product_ID = mp.M_Product_ID)  INNER JOIN M_Product_Category pc ON (mp.M_Product_Category_ID = pc.M_Product_Category_ID)  WHERE ol.IsActive = 'Y' AND MonthlyAmount IS NULL AND upper(pc.value) LIKE 'EDITO%'  AND C_Order_ID = " + order.get_ID())) > 0) {
                throw new AdempiereException("Error: No Existen Precios PAT. Selecione otra Regla de Pago ");
            }
            int cantContactPhone = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_User WHERE C_Bpartner_ID = " + order.getC_BPartner_ID() + " AND Type = '01' " + " AND IsActive = 'Y' ");
            if (cantContactPhone < 1) {
                throw new AdempiereException("Error: Se debe crear un telefono de contacto al socio de negocio contratante");
            }
            int cantNoZoneSec = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1)  FROM C_OrderLine ol  INNER JOIN C_BPartner_Location bpl ON (ol.C_BPartner_Location_ID = bpl.C_BPartner_Location_ID)  WHERE (ZONE IS NULL OR Sector IS NULL)  AND ol.IsActive = 'Y' AND C_order_ID = " + order.get_ID());
            if (cantNoZoneSec > 0) {
                order.set_CustomColumn("RequiresApprovalList", "EZ");
                order.save();
                this.commitEx();
                throw new AdempiereException("Error: Direccion sin Zona/Sector. Favor Genere un Ticket");
            }
            int cantLPV = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(M_PriceList_ID) FROM M_PriceList WHERE M_PriceList_ID IN (  SELECT pl.M_PriceList_ID FROM M_PriceList pl INNER JOIN C_BPartnerPriceList bpl ON pl.M_PriceList_ID = bpl.M_PriceList_ID  WHERE pl.IsActive = 'Y' AND bpl.IsActive = 'Y' AND pl.IsSOPriceList = 'Y'  AND pl.IsInBPartner = 'Y' AND bpl.C_BPartner_ID = " + order.getC_BPartner_ID() + " UNION SELECT pl.M_PriceList_ID FROM M_PriceList pl " + " INNER JOIN AD_UserPriceList upl ON pl.M_PriceList_ID = upl.M_PriceList_ID" + " WHERE pl.IsActive = 'Y' AND upl.IsActive = 'Y' AND pl.IsSOPriceList = 'Y' " + " AND pl.IsInUser = 'Y' AND upl.AD_User_ID = " + Env.getAD_User_ID(this.getCtx()) + " UNION " + " SELECT pl.M_PriceList_ID FROM M_PriceList pl " + " INNER JOIN AD_RolePriceList rpl ON pl.M_PriceList_ID = rpl.M_PriceList_ID " + " WHERE pl.IsActive = 'Y' AND rpl.IsActive = 'Y' AND pl.IsSOPriceList = 'Y' " + " AND ((pl.IsInChannel = 'Y' AND rpl.C_Channel_ID = " + order.get_ValueAsInt("C_Channel_ID") + " )" + " \tOR (pl.IsInRole = 'Y' AND rpl.AD_Role_ID = " + Env.getAD_Role_ID(this.getCtx()) + " ) " + " \tOR (pl.IsInPTerm = 'Y' AND rpl.C_PaymentTerm_ID = " + order.getC_PaymentTerm_ID() + ") " + "    ) " + " UNION SELECT pl.M_PriceList_ID FROM M_PriceList pl " + " WHERE pl.IsActive = 'Y' AND pl.IsSOPriceList = 'Y' AND pl.IsInUser = 'N' " + " AND pl.IsInBPartner = 'N' AND pl.IsInRole = 'N' " + " AND pl.IsInPTerm = 'N' AND pl.IsInChannel = 'N' " + " AND pl.AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx()) + ")" + " AND (dateStart IS NULL OR dateStart < now()) AND (dateEnd IS NULL OR dateEnd > now())" + " AND M_PriceList_ID = " + order.getM_PriceList_ID());
            if (cantLPV < 1) {
                return "Error: Termino de pago no permitido para esta lista de precio";
            }
            if (ProcessSalesOrderCOPESA.validCantLinePL(order, order.get_TrxName()) > 0) {
                return "ERROR: Pedido debe incluir al menos " + ProcessSalesOrderCOPESA.validCantLinePL(order, order.get_TrxName()) + " l\u00edneas por restricci\u00f3n de la lista de precios";
            }
            this.validDates(order, hoy);
            if (!COPESAOrderOps.validStock(order, true)) {
                throw new AdempiereException("Error de validaci\u00f3n de stock.");
            }
            if (rol.get_ValueAsBoolean("OrderApprobal")) {
                order.setDocStatus("IP");
                order.set_CustomColumn("DateCompleted", hoy);
                order.set_CustomColumn("RequiresApprovalList", null);
                order.setDocAction("CO");
                String sql = "UPDATE C_Order set DateCompleted = now() WHERE C_Order_ID = " + order.getC_Order_ID();
                if (DB.executeUpdate(sql, order.get_TrxName()) < 0) {
                    throw new AdempiereException(CLogger.retrieveErrorString("ERROR: No se pudo guardar"));
                }
                if (!order.processIt("CO")) {
                    throw new AdempiereException(order.getProcessMsg());
                }
                if (order.save()) return "Procesado";
                throw new AdempiereException(CLogger.retrieveErrorString("ERROR: No se pudo guardar"));
            }
            order.set_CustomColumn("RequiresApprovalList", "WA");
            if (!COPESAOrderOps.create_osc(order)) {
                throw new AdempiereException(CLogger.retrieveErrorString("ERROR: No se pudo generar calendario de pauta"));
            }
            order.setProcessed(true);
            if (!order.save()) {
                throw new AdempiereException(CLogger.retrieveErrorString("ERROR: No se pudo guardar"));
            }
            this.commitEx();
            throw new AdempiereException("Se Necesita Aprobaci\u00f3n");
        }
        if (this.p_DocStatus.compareTo("VO") == 0) {
            order.setDocStatus("IP");
            order.save();
            order.set_CustomColumn("RequiresApprovalList", null);
            order.save();
            order.processIt("VO");
            order.save();
            return "Procesado";
        } else {
            if (this.p_DocStatus.compareTo("IN") != 0) return "Procesado";
            order.setProcessed(false);
            order.setDocStatus("IN");
            order.set_CustomColumn("RequiresApprovalList", "RE");
            order.save();
        }
        return "Procesado";
    }

    public boolean reqApproval(MOrder order) {
        if (order.get_ValueAsString("TypePaymentRule").compareTo("C") == 0) {
            return true;
        }
        if (order.getPaymentRule().compareTo("D") == 0) {
            BigDecimal amt = DB.getSQLValueBD(null, "SELECT SUM(LineNetAmt)   FROM C_OrderLine col INNER JOIN M_Product mp ON (col.M_Product_ID = mp.M_Product_ID) INNER JOIN M_Product_Category mpc ON (mp.M_Product_Category_ID = mpc.M_Product_Category_ID) WHERE col.IsActive = 'Y' AND upper(mpc.description) NOT LIKE 'EDITORIAL'  AND C_Order_ID = ? ", order.get_ID());
            if (amt == null) {
                amt = Env.ZERO;
            }
            if (amt.compareTo(Env.ONEHUNDRED) < 0) {
                return false;
            }
        }
        return true;
    }

    public boolean validFields(MOrder order) {
        if (order.getPaymentRule().compareTo("S") == 0 && order.get_ValueAsInt("C_CalendarCOPESALine_ID") <= 0) {
            throw new AdempiereException("Llenar campos obligatorios");
        }
        if (order.get_ValueAsInt("C_Channel_ID") <= 0) {
            throw new AdempiereException("Llenar campos obligatorios");
        }
        if (order.get_ValueAsString("Type") == null || order.get_ValueAsString("Type") == "" || order.get_ValueAsString("Type") == " ") {
            throw new AdempiereException("Llenar campos obligatorios");
        }
        if (order.get_ValueAsString("OrderType2") == null || order.get_ValueAsString("Type").trim() == "OrderType2" || order.get_ValueAsString("OrderType2").trim() == " ") {
            throw new AdempiereException("Llenar campos obligatorios");
        }
        return true;
    }

    public static int validCantLinePL(MOrder order, String Trx2) {
        MPriceList pList;
        int cantLinePL;
        int cant = DB.getSQLValue(Trx2, "select count(1) from c_orderline col join c_order co on (co.c_order_id = col.c_order_id)  join m_product mp on (mp.m_product_id = col.m_product_id)  where mp.description not in ('FULLSD')  and col.isactive = 'Y' and c_orderlineref_id is null  and co.c_order_id = " + order.get_ID());
        if (cant < (cantLinePL = (pList = new MPriceList(Env.getCtx(), order.getM_PriceList_ID(), Trx2)).get_ValueAsInt("minLevel"))) {
            return cantLinePL;
        }
        return 0;
    }

    public boolean validDates(MOrder _order, Timestamp _instant) {
        int cantVLine = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM C_OrderLine  WHERE IsActive = 'Y' AND C_Order_ID = " + _order.get_ID() + " AND M_Product_ID != null AND DatePromised2 <= ?", _instant);
        if (cantVLine > 0) {
            throw new AdempiereException("Error: Fecha de Linea debe ser mayor a fecha de hoy");
        }
        if (_order.getDatePromised().compareTo(_instant) <= 0) {
            throw new AdempiereException("Error: Fecha cabecera anterior a fecha de facturaci\u00f3n");
        }
        if (_order.getDateOrdered().compareTo(_instant) < 0) {
            throw new AdempiereException("Error: Fecha cabecera anterior a fecha de facturaci\u00f3n");
        }
        int value = _order.getDateOrdered().compareTo(_order.getDatePromised());
        this.log.config("value " + value);
        if (_order.getDateOrdered().compareTo(_order.getDatePromised()) >= 0) {
            throw new AdempiereException("Error: Fecha de facturaci\u00f3n debe ser menor a fecha de inicio");
        }
        return true;
    }
}

