/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MUser;
import org.compiere.model.X_I_OrderMasive;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportOrder
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private boolean m_deleteOldImported = false;
    private String m_docAction = "PR";
    private Timestamp m_DateValue = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("AD_Org_ID")) {
                this.m_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("DocAction")) {
                this.m_docAction = (String)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    @Override
    protected String doIt() throws Exception {
        MBPartnerLocation bpl;
        MBPartner bp;
        X_I_OrderMasive imp;
        ResultSet rs;
        CPreparedStatement pstmt;
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_OrderMasive WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_OrderMasive SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.m_AD_Org_ID).append("), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o SET I_IsImported='N', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        sql = new StringBuffer("UPDATE I_OrderMasive o SET M_PriceList_ID =  (SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE name LIKE 'Lista Precio Base' AND p.IsSOPriceList='Y' AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Default Currency PriceList=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y' AND p.IsSOPriceList='Y' AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Currency PriceList=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive SET I_IsImported='N', I_ErrorMsg=I_ErrorMsg||'ERR=No PriceList, ' WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("No PriceList=" + no);
        }
        sql = new StringBuffer("UPDATE I_OrderMasive o SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm p WHERE o.C_PaymentTermName =p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_PaymentTerm_ID IS NULL AND C_PaymentTermName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set PaymentTerm=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o SET C_PaymentTerm_ID=(SELECT MAX(C_PaymentTerm_ID) FROM C_PaymentTerm p WHERE p.IsDefault='Y' AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_PaymentTerm_ID IS NULL AND o.C_PaymentTermName IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Default PaymentTerm=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive SET I_IsImported='N', I_ErrorMsg=I_ErrorMsg||'ERR=No PaymentTerm, ' WHERE C_PaymentTerm_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("No PaymentTerm=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_OrderMasive o SET M_Warehouse_ID=(SELECT MAX(M_Warehouse_ID) FROM M_Warehouse w WHERE o.AD_Client_ID=w.AD_Client_ID AND  w.name = o.M_WareHouseName) WHERE M_Warehouse_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.fine("Set Warehouse=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_OrderMasive o SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Warehouse w WHERE o.AD_Client_ID=w.AD_Client_ID) WHERE M_Warehouse_ID IS NULL AND EXISTS (SELECT AD_Client_ID FROM M_Warehouse w WHERE w.AD_Client_ID=o.AD_Client_ID GROUP BY AD_Client_ID HAVING COUNT(*)=1) AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.fine("Set Only Client Warehouse=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_OrderMasive SET I_IsImported='N', I_ErrorMsg=I_ErrorMsg||'ERR=No Warehouse, ' WHERE M_Warehouse_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No Warehouse=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_OrderMasive o SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator w WHERE o.AD_Client_ID=w.AD_Client_ID AND  w.Value = o.M_LocatorName) WHERE M_Locator_ID IS NULL AND M_LocatorName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.fine("Set Warehouse=" + no);
        }
        sql = new StringBuffer("UPDATE I_OrderMasive o SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp WHERE o.Value=bp.Value AND o.AD_Client_ID=bp.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND Value IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set BP from Value=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.M_product_Name=p.Name AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND M_product_Name IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Product from Value=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive SET I_IsImported='N', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Product, ' WHERE M_Product_ID IS NULL AND (M_product_Name IS NOT NULL) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Product=" + no);
        }
        sql = new StringBuffer("UPDATE I_OrderMasive o SET C_Channel_ID=(SELECT MAX(C_Channel_ID) FROM C_Channel t WHERE o.C_ChannelName = t.name AND o.AD_Client_ID=t.AD_Client_ID) WHERE C_Channel_ID IS NULL AND C_ChannelName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set channel=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o  SET C_City_ID=(SELECT MAX(C_City_ID) FROM C_City t  WHERE o.C_CityName = t.name) WHERE C_City_ID IS NULL AND C_CityName IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set City=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o  SET C_Province_ID=(SELECT MAX(C_Province_ID) FROM C_Province t  WHERE o.C_ProvinceName = t.name ) WHERE C_Province_ID IS NULL AND C_ProvinceName IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set province=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o  SET C_Region_ID=(SELECT MAX(C_Region_ID) FROM C_Region t  WHERE o.C_RegionName = t.name ) WHERE C_Region_ID IS NULL AND C_RegionName IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set region=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o  SET C_Street_ID=(SELECT MAX(C_Street_ID) FROM C_Street t  WHERE o.C_StreetName = t.name) WHERE C_Street_ID IS NULL AND C_StreetName IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set region=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o SET C_BPartnerLine_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp WHERE o.ValueL=bp.Value AND o.AD_Client_ID=bp.AD_Client_ID) WHERE C_BPartnerLine_ID IS NULL AND ValueL IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set BP from Value=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o  SET C_CityL_ID=(SELECT MAX(C_City_ID) FROM C_City t  WHERE o.C_CityNameL = t.name ) WHERE C_CityL_ID IS NULL AND C_CityNameL IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set CityL=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o  SET C_ProvinceL_ID=(SELECT MAX(C_Province_ID) FROM C_Province t  WHERE o.C_ProvinceNameL = t.name) WHERE C_ProvinceL_ID IS NULL AND C_ProvinceNameL IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set provinceL=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o  SET C_RegionL_ID=(SELECT MAX(C_Region_ID) FROM C_Region t  WHERE o.C_RegionNameL = t.name) WHERE C_RegionL_ID IS NULL AND C_RegionNameL IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set regionL=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o  SET C_StreetL_ID=(SELECT MAX(C_Street_ID) FROM C_Street t  WHERE o.C_StreetNameL = t.name) WHERE C_StreetL_ID IS NULL AND C_StreetNameL IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set streetL=" + no);
        sql = new StringBuffer("UPDATE I_OrderMasive o  SET C_CalendarCOPESA_ID=(SELECT MAX(C_CalendarCOPESA_ID) FROM C_CalendarCOPESA t  WHERE o.C_CalendarCOPESAName = t.name AND o.AD_Client_ID=t.AD_Client_ID) WHERE C_CalendarCOPESA_ID IS NULL AND C_CalendarCOPESAName IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set copesa calendar=" + no);
        this.commitEx();
        sql = new StringBuffer("SELECT * FROM I_OrderMasive WHERE I_IsImported='N' AND (C_BPartner_ID IS NULL OR C_BPartner_Location_ID IS NULL)").append(clientCheck);
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                imp = new X_I_OrderMasive(this.getCtx(), rs, this.get_TrxName());
                if (imp.getValue() == null) continue;
                bp = MBPartner.get(this.getCtx(), imp.getValue());
                if (bp == null) {
                    bp = new MBPartner(this.getCtx(), -1, this.get_TrxName());
                    bp.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                    bp.setValue(imp.getValue());
                    bp.setName((String.valueOf(imp.getName1()) + " " + imp.getName5() + " " + imp.getName2() + " " + imp.getName3() + " " + imp.getName4()).trim());
                    if (imp.getName1() != null) {
                        bp.set_CustomColumn("Name1", imp.getName1());
                    }
                    if (imp.getName2() != null) {
                        bp.set_CustomColumn("Name2", imp.getName2());
                    }
                    if (imp.getName3() != null) {
                        bp.set_CustomColumn("Name3", imp.getName3());
                    }
                    if (imp.getName4() != null) {
                        bp.set_CustomColumn("Name4", imp.getName4());
                    }
                    if (imp.getName5() != null) {
                        bp.set_CustomColumn("Name5", imp.getName5());
                    }
                    if (imp.getDigito() != null) {
                        bp.set_CustomColumn("Digito", imp.getDigito());
                    }
                    if (imp.getPartnerType() != null && this.getValueRef(2000001, imp.getPartnerType()) != null) {
                        bp.set_CustomColumn("PartnerType", this.getValueRef(2000001, imp.getPartnerType()));
                    }
                    if (imp.getVIPClient() != null && this.getValueRef(2000002, imp.getVIPClient()) != null) {
                        bp.set_CustomColumn("VIPClient", this.getValueRef(2000002, imp.getVIPClient()));
                    }
                    if (imp.getBirthday() != null) {
                        bp.set_CustomColumn("Birthday", imp.getBirthday());
                    }
                    if (imp.getMaritalStatus() != null && this.getValueRef(53614, imp.getMaritalStatus()) != null) {
                        bp.set_CustomColumn("MaritalStatus", this.getValueRef(53614, imp.getMaritalStatus()));
                    }
                    if (imp.getChildren() > 0) {
                        bp.set_CustomColumn("Children", imp.getChildren());
                    }
                    if (imp.getTwitter() != null) {
                        bp.set_CustomColumn("Twitter", imp.getTwitter());
                    }
                    if (imp.getFacebook() != null) {
                        bp.set_CustomColumn("Facebook", imp.getFacebook());
                    }
                    if (imp.getGender() != null && this.getValueRef(53612, imp.getGender()) != null) {
                        bp.set_CustomColumn("Gender", this.getValueRef(53612, imp.getGender()));
                    }
                    if (!bp.save()) continue;
                }
                imp.setC_BPartner_ID(bp.getC_BPartner_ID());
                imp.save();
                bpl = null;
                if (!this.existLocator(imp, imp.getC_BPartner_ID()).booleanValue()) {
                    bpl = new MBPartnerLocation(bp);
                    bpl.setAD_Org_ID(bp.getAD_Org_ID());
                    bpl.setC_Location_ID(2000011);
                    if (imp.getHomeType() != null && this.getValueRef(2000003, imp.getHomeType()) != null) {
                        bpl.set_CustomColumn("HomeType", this.getValueRef(2000003, imp.getHomeType()));
                    }
                    if (imp.getAddressType() != null && this.getValueRef(2000004, imp.getAddressType()) != null) {
                        bpl.set_CustomColumn("AddressType", this.getValueRef(2000004, imp.getAddressType()));
                    }
                    if (imp.getC_City_ID() > 0) {
                        bpl.set_CustomColumn("C_City_ID", imp.getC_City_ID());
                    }
                    if (imp.getC_Province_ID() > 0) {
                        bpl.set_CustomColumn("C_Province_ID", imp.getC_Province_ID());
                    }
                    if (imp.getC_Region_ID() > 0) {
                        bpl.set_CustomColumn("C_Region_ID", imp.getC_Region_ID());
                    }
                    if (imp.getC_Street_ID() > 0) {
                        bpl.set_CustomColumn("C_Street_ID", imp.getC_Street_ID());
                    }
                    if (imp.getAddressNumber().compareTo(Env.ZERO) > 0) {
                        bpl.set_CustomColumn("AddressNumber", imp.getAddressNumber().toString());
                    }
                    if (imp.getHomeNumber().compareTo(Env.ZERO) > 0) {
                        bpl.set_CustomColumn("HomeNumber", Integer.toString(imp.getHomeNumber().intValue()));
                    }
                    if (imp.getBlock() != null) {
                        bpl.set_CustomColumn("Block", imp.getBlock());
                    }
                    if (imp.getVilla() != null) {
                        bpl.set_CustomColumn("Villa", imp.getVilla());
                    }
                    if (imp.getStreetName() != null) {
                        bpl.set_CustomColumn("StreetName", imp.getStreetName());
                    }
                    if (imp.getZipCode() != null) {
                        bpl.set_CustomColumn("ZipCode", imp.getZipCode().toString());
                    }
                    if (imp.getZone() != null) {
                        bpl.set_CustomColumn("Zone", imp.getZone().toString());
                    }
                    if (imp.getSector() != null) {
                        bpl.set_CustomColumn("Sector", imp.getSector().toString());
                    }
                    if (imp.getLocator_Description() != null) {
                        bpl.set_CustomColumn("Description", imp.getLocator_Description());
                    }
                    if (!bpl.save()) {
                        continue;
                    }
                } else {
                    bpl = new MBPartnerLocation(this.getCtx(), this.getLocator(imp, imp.getC_BPartner_ID()), this.get_TrxName());
                }
                if (bpl.get_ID() > 0) {
                    imp.set_CustomColumn("C_BPartner_Location_ID", bpl.get_ID());
                    imp.save();
                }
                if (this.existContact(imp.getDescription(), imp.getC_BPartner_ID()).booleanValue()) continue;
                MUser user = new MUser(this.getCtx(), 0, this.get_TrxName());
                user.setC_BPartner_ID(imp.getC_BPartner_ID());
                if (imp.getType() != null && this.getValueRef(2000021, imp.getType()) != null) {
                    user.set_CustomColumn("Type", this.getValueRef(2000021, imp.getType()));
                }
                if (imp.getIsDefaultCOPESA() != null && this.getValueRef(2000024, imp.getIsDefaultCOPESA()) != null) {
                    user.set_CustomColumn("IsDefaultCOPESA", this.getValueRef(2000024, imp.getIsDefaultCOPESA()));
                }
                if (imp.getDescription() != null) {
                    user.setDescription(imp.getDescription());
                }
                if (imp.getEMail() != null) {
                    user.setEMail(imp.getEMail());
                }
                if (imp.getPhone() != null) {
                    user.setPhone(imp.getPhone());
                }
                if (imp.getIsWhatsapp() != null) {
                    if (imp.getIsWhatsapp().compareToIgnoreCase("SI") == 0) {
                        user.set_CustomColumn("IsWhatsapp", true);
                    } else {
                        user.set_CustomColumn("IsWhatsapp", false);
                    }
                }
                if (imp.getIsSMS() != null) {
                    if (imp.getIsSMS().compareToIgnoreCase("SI") == 0) {
                        user.set_CustomColumn("IsSMS", true);
                    } else {
                        user.set_CustomColumn("IsSMS", false);
                    }
                }
                if (imp.getPhoneType() != null && this.getValueRef(2000033, imp.getPhoneType()) != null) {
                    user.set_CustomColumn("PhoneType", this.getValueRef(2000033, imp.getPhoneType()));
                }
                if (imp.getPhoneUse() != null && this.getValueRef(2000034, imp.getPhoneUse()) != null) {
                    user.set_CustomColumn("PhoneUse", this.getValueRef(2000034, imp.getPhoneUse()));
                }
                user.saveEx(this.get_TrxName());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "BP - " + sql.toString(), e);
        }
        sql = new StringBuffer("SELECT * FROM I_OrderMasive WHERE I_IsImported='N' AND (C_BPartnerLine_ID IS NULL OR C_Bpartner_LocationLine_ID IS NULL)").append(clientCheck);
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                imp = new X_I_OrderMasive(this.getCtx(), rs, this.get_TrxName());
                if (imp.getValueL() == null) continue;
                bp = MBPartner.get(this.getCtx(), imp.getValueL());
                if (bp == null) {
                    bp = new MBPartner(this.getCtx(), -1, this.get_TrxName());
                    bp.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                    bp.setValue(imp.getValueL());
                    bp.setName((String.valueOf(imp.getName1L()) + " " + imp.getName5L() + " " + imp.getName2L() + " " + imp.getName3L() + " " + imp.getName4L()).trim());
                    if (imp.getName1L() != null) {
                        bp.set_CustomColumn("Name1", imp.getName1L());
                    }
                    if (imp.getName2L() != null) {
                        bp.set_CustomColumn("Name2", imp.getName2L());
                    }
                    if (imp.getName3L() != null) {
                        bp.set_CustomColumn("Name3", imp.getName3L());
                    }
                    if (imp.getName4L() != null) {
                        bp.set_CustomColumn("Name4", imp.getName4L());
                    }
                    if (imp.getName5L() != null) {
                        bp.set_CustomColumn("Name5", imp.getName5L());
                    }
                    if (imp.getDigitoL() != null) {
                        bp.set_CustomColumn("Digito", imp.getDigitoL());
                    }
                    if (imp.getPartnerTypeL() != null && this.getValueRef(2000001, imp.getPartnerTypeL()) != null) {
                        bp.set_CustomColumn("PartnerType", this.getValueRef(2000001, imp.getPartnerTypeL()));
                    }
                    if (imp.getVipClientL() != null && this.getValueRef(2000002, imp.getVIPClient()) != null) {
                        bp.set_CustomColumn("VIPClient", this.getValueRef(2000002, imp.getVipClientL()));
                    }
                    if (imp.getBirthdayL() != null) {
                        bp.set_CustomColumn("Birthday", imp.getBirthdayL());
                    }
                    if (imp.getMaritalStatusL() != null && this.getValueRef(53614, imp.getMaritalStatusL()) != null) {
                        bp.set_CustomColumn("MaritalStatus", this.getValueRef(53614, imp.getMaritalStatusL()));
                    }
                    if (imp.getChildrenL() > 0) {
                        bp.set_CustomColumn("Children", imp.getChildrenL());
                    }
                    if (imp.getTwitterL() != null) {
                        bp.set_CustomColumn("Twitter", imp.getTwitterL());
                    }
                    if (imp.getFacebookL() != null) {
                        bp.set_CustomColumn("Facebook", imp.getFacebookL());
                    }
                    if (imp.getGenderL() != null && this.getValueRef(53612, imp.getGenderL()) != null) {
                        bp.set_CustomColumn("Gender", this.getValueRef(53612, imp.getGenderL()));
                    }
                    if (!bp.save()) continue;
                }
                imp.setC_BPartnerLine_ID(bp.getC_BPartner_ID());
                bpl = null;
                if (!this.existLocator(imp, imp.getC_BPartnerLine_ID()).booleanValue()) {
                    bpl = new MBPartnerLocation(bp);
                    bpl.setC_Location_ID(2000011);
                    if (imp.getHomeTypeL() != null && this.getValueRef(2000003, imp.getHomeTypeL()) != null) {
                        bpl.set_CustomColumn("HomeType", this.getValueRef(2000003, imp.getHomeTypeL()));
                    }
                    if (imp.getAddressTypeL() != null && this.getValueRef(2000004, imp.getAddressTypeL()) != null) {
                        bpl.set_CustomColumn("AddressType", this.getValueRef(2000004, imp.getAddressTypeL()));
                    }
                    if (imp.getC_CityL_ID() > 0) {
                        bpl.set_CustomColumn("C_City_ID", imp.getC_CityL_ID());
                    }
                    if (imp.getC_ProvinceL_ID() > 0) {
                        bpl.set_CustomColumn("C_Province_ID", imp.getC_ProvinceL_ID());
                    }
                    if (imp.getC_RegionL_ID() > 0) {
                        bpl.set_CustomColumn("C_Region_ID", imp.getC_RegionL_ID());
                    }
                    if (imp.getC_StreetL_ID() > 0) {
                        bpl.set_CustomColumn("C_Street_ID", imp.getC_StreetL_ID());
                    }
                    if (imp.getAddressNumberL().compareTo(Env.ZERO) > 0) {
                        bpl.set_CustomColumn("AddressNumber", imp.getAddressNumberL());
                    }
                    if (imp.getHomeNumberL().compareTo(Env.ZERO) > 0) {
                        bpl.set_CustomColumn("HomeNumber", Integer.toString(imp.getHomeNumberL().intValue()));
                    }
                    if (imp.getBlockL() != null) {
                        bpl.set_CustomColumn("Block", imp.getBlockL());
                    }
                    if (imp.getVillaL() != null) {
                        bpl.set_CustomColumn("Villa", imp.getVillaL());
                    }
                    if (imp.getStreetNameL() != null) {
                        bpl.set_CustomColumn("StreetName", imp.getStreetNameL());
                    }
                    if (imp.getZipCodeL() != null) {
                        bpl.set_CustomColumn("ZipCode", imp.getZipCodeL().toString());
                    }
                    if (imp.getZoneL() != null) {
                        bpl.set_CustomColumn("Zone", imp.getZoneL().toString());
                    }
                    if (imp.getSectorL() != null) {
                        bpl.set_CustomColumn("Sector", imp.getSectorL().toString());
                    }
                    if (imp.getLocatorDescriptionL() != null) {
                        bpl.set_CustomColumn("Description", imp.getLocatorDescriptionL());
                    }
                    if (!bpl.save()) continue;
                }
                imp.set_CustomColumn("C_BPartner_LocationLine_ID", bpl.getC_BPartner_Location_ID());
                imp.save();
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "BP - " + sql.toString(), e);
        }
        sql = new StringBuffer("UPDATE I_OrderMasive SET I_IsImported='N', I_ErrorMsg=I_ErrorMsg||'ERR=No BPartner, ',IsError = 'Y'  WHERE C_BPartner_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("No BPartner=" + no);
        }
        sql = new StringBuffer("SELECT ColumnName FROM validationMandatory");
        String condicion = " WHERE I_OrderMasive_ID > 0 ";
        try {
            CPreparedStatement pstmt2 = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs2 = pstmt2.executeQuery();
            while (rs2.next()) {
                condicion = String.valueOf(condicion) + ", AND " + rs2.getString("ColumnName") + " IS NULL";
            }
            DB.executeUpdate("UPDATE I_OrderMasive SET IsError = 'Y', ERROR ", this.get_TrxName());
            this.commitEx();
            rs2.close();
            pstmt2.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "BP - " + sql.toString(), e);
        }
        int noInsert = 0;
        int noInsertLine = 0;
        sql = new StringBuffer("SELECT * FROM I_OrderMasive WHERE I_IsImported='N' AND IsError = 'N'").append(clientCheck).append(" ORDER BY C_BPartner_ID, C_BPartner_Location_ID, I_OrderMasive_ID");
        try {
            CPreparedStatement pstmt3 = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs3 = pstmt3.executeQuery();
            int oldC_BPartner_ID = 0;
            int oldC_BPartner_Location_ID = 0;
            String oldDocumentNo = "";
            MOrder order = null;
            int lineNo = 0;
            while (rs3.next()) {
                X_I_OrderMasive imp2 = new X_I_OrderMasive(this.getCtx(), rs3.getInt("I_OrderMasive_ID"), this.get_TrxName());
                String cmpDocumentNo = imp2.getDocumentNo();
                if (cmpDocumentNo == null) {
                    cmpDocumentNo = "";
                }
                if (oldC_BPartner_ID != imp2.getC_BPartner_ID() || oldC_BPartner_Location_ID != imp2.getC_BPartner_Location_ID() || !oldDocumentNo.equals(cmpDocumentNo)) {
                    if (order != null) {
                        if (this.m_docAction != null && this.m_docAction.length() > 0) {
                            order.setDocAction(this.m_docAction);
                            order.processIt(this.m_docAction);
                        }
                        order.saveEx();
                    }
                    oldC_BPartner_ID = imp2.getC_BPartner_ID();
                    oldC_BPartner_Location_ID = imp2.getC_BPartner_Location_ID();
                    oldDocumentNo = imp2.getDocumentNo();
                    if (oldDocumentNo == null) {
                        oldDocumentNo = "";
                    }
                    order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                    order.setClientOrg(imp2.getAD_Client_ID(), this.m_AD_Org_ID);
                    order.setC_DocTypeTarget_ID(MDocType.getDocType("SOO", imp2.getAD_Org_ID()));
                    order.setIsSOTrx(true);
                    order.setDeliveryRule("A");
                    if (imp2.getDocumentNo() != null) {
                        order.setDocumentNo(imp2.getDocumentNo());
                    }
                    order.setC_BPartner_ID(imp2.getC_BPartner_ID());
                    order.setC_BPartner_Location_ID(imp2.getC_BPartner_Location_ID());
                    order.setAD_User_ID(Env.getAD_User_ID(this.getCtx()));
                    order.setBill_BPartner_ID(imp2.getC_BPartner_ID());
                    order.setBill_Location_ID(imp2.getC_BPartner_Location_ID());
                    if (imp2.getDescription() != null) {
                        order.setDescription(imp2.getDescription());
                    }
                    if (imp2.getC_PaymentTerm_ID() > 0) {
                        order.setC_PaymentTerm_ID(imp2.getC_PaymentTerm_ID());
                    } else {
                        order.setC_PaymentTerm_ID(imp2.getC_PaymentTerm_ID());
                    }
                    order.setM_PriceList_ID(imp2.getM_PriceList_ID());
                    order.setM_Warehouse_ID(imp2.getM_Warehouse_ID());
                    order.setSalesRep_ID(this.getAD_User_ID());
                    order.setAD_OrgTrx_ID(imp2.getAD_Org_ID());
                    order.setDateOrdered(imp2.getDateCompleted());
                    order.setDatePromised(imp2.getDateCompleted());
                    order.setDateAcct(imp2.getDateCompleted());
                    if (this.getValueRef(195, imp2.getPaymentRule()) != null) {
                        // empty if block
                    }
                    order.setPaymentRule(this.getValueRef(195, imp2.getPaymentRule()));
                    if (this.getValueRef(2000036, imp2.getTypePaymentRule()) != null) {
                        // empty if block
                    }
                    order.set_CustomColumn("TypePaymentRule", this.getValueRef(2000036, imp2.getTypePaymentRule()));
                    if (imp2.getPOReference() != null) {
                        order.set_CustomColumn("POReference2", imp2.getPOReference());
                    }
                    order.saveEx();
                    ++noInsert;
                    lineNo = 10;
                }
                imp2.setC_Order_ID(order.getC_Order_ID());
                MOrderLine line = new MOrderLine(order);
                line.setLine(lineNo);
                lineNo += 10;
                if (imp2.getM_Product_ID() != 0) {
                    line.setM_Product_ID(imp2.getM_Product_ID(), true);
                } else if (imp2.get_ValueAsInt("C_Charge_ID") > 0) {
                    line.setC_Charge_ID(imp2.get_ValueAsInt("C_Charge_ID"));
                }
                line.setQty(imp2.getQtyEntered());
                line.setPrice(imp2.getPriceActual());
                if (imp2.getC_BPartnerLine_ID() > 0) {
                    line.set_CustomColumn("C_BpartnerRef_ID", imp2.getC_BPartnerLine_ID());
                }
                if (imp2.getC_Bpartner_LocationLine_ID() > 0) {
                    line.set_CustomColumn("C_Bpartner_Location_ID", imp2.getC_Bpartner_LocationLine_ID());
                }
                if (imp2.getDatePromised2() != null) {
                    line.set_CustomColumn("DatePromised2", imp2.getDatePromised2());
                }
                if (imp2.getDatePromised3() != null) {
                    line.set_CustomColumn("DatePromised3", imp2.getDatePromised3());
                }
                if (imp2.getM_Locator_ID() > 0) {
                    line.set_CustomColumn("M_Locator_ID", imp2.getM_Locator_ID());
                }
                if (imp2.getLineNetAmt().compareTo(Env.ZERO) > 0) {
                    line.setLineNetAmt(imp2.getLineNetAmt());
                }
                if (imp2.getC_CalendarCOPESA_ID() > 0) {
                    line.set_CustomColumn("C_CalendarCOPESA_ID", imp2.getC_CalendarCOPESA_ID());
                }
                if (imp2.getMonthlyAmount() != null && imp2.getMonthlyAmount().compareTo(Env.ZERO) >= 0) {
                    line.set_CustomColumn("MonthlyAmount", imp2.getMonthlyAmount());
                }
                if (imp2.getLevelNo() > 0) {
                    line.set_CustomColumn("LevelNo", imp2.getLevelNo());
                }
                line.setC_Tax_ID(2000002);
                line.saveEx();
                imp2.setC_OrderLine_ID(line.getC_OrderLine_ID());
                imp2.setI_IsImported(true);
                imp2.setProcessed(true);
                if (!imp2.save()) continue;
                ++noInsertLine;
            }
            if (order != null && this.m_docAction != null && this.m_docAction.length() > 0) {
                order.setDocAction(this.m_docAction);
                order.processIt(this.m_docAction);
                order.saveEx();
            }
            rs3.close();
            pstmt3.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Order - " + sql.toString(), e);
        }
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(noInsert), "@C_Order_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@C_OrderLine_ID@: @Inserted@");
        return "#" + noInsert + "/" + noInsertLine;
    }

    private Boolean existContact(String desc, int ID_Bpartner) {
        int cant = 0;
        if (ID_Bpartner > 0 && desc != null) {
            cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_User WHERE C_Bpartner_ID =" + ID_Bpartner + " AND lower(Description) = '" + desc.toLowerCase() + "'");
        }
        if (cant > 0) {
            return true;
        }
        return false;
    }

    private Boolean existLocator(X_I_OrderMasive iOrder, int ID_Bpartner) {
        int cant = 0;
        if (iOrder.getC_StreetL_ID() > 0 || iOrder.getStreetNameL() != null) {
            cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM C_BPartner_Location  WHERE C_Bpartner_ID = " + ID_Bpartner + " AND AddressNumber = '" + iOrder.getAddressNumberL() + "' AND HomeNumber = '" + iOrder.getHomeNumberL() + "' " + " AND (C_Street_ID = " + iOrder.getC_StreetL_ID() + " OR StreetName = '" + iOrder.getStreetNameL() + "')");
        }
        if (cant > 0) {
            return true;
        }
        return false;
    }

    private int getLocator(X_I_OrderMasive iOrder, int ID_Bpartner) {
        int cant = 0;
        if (iOrder.getC_StreetL_ID() > 0 || iOrder.getStreetNameL() != null) {
            cant = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location  WHERE C_Bpartner_ID = " + ID_Bpartner + " AND AddressNumber = '" + iOrder.getAddressNumberL() + "' AND HomeNumber = '" + iOrder.getHomeNumberL() + "' " + " AND (C_Street_ID = " + iOrder.getC_StreetL_ID() + " OR StreetName = '" + iOrder.getStreetNameL() + "')");
        }
        return cant;
    }

    private String getValueRef(int ID_Reference, String name) {
        String valueRef = DB.getSQLValueString(this.get_TrxName(), "SELECT VALUE FROM AD_Ref_List  WHERE AD_Reference_ID=" + ID_Reference + " AND Name = '" + name + "'", new Object[0]);
        return valueRef;
    }
}

