/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.X_C_OrderPayCalendar;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class GenerateOrderPay
extends SvrProcess {
    int ID_Order;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Order_ID")) {
                    this.ID_Order = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String sql = "SELECT C_Order_ID FROM C_Order co  WHERE (SELECT COUNT(1) FROM C_OrderPayCalendar WHERE C_Order_ID = co.C_Order_ID AND IsActive = 'Y' AND IsInvoiced <> 'Y') < 24 AND PaymentRule IN ('C','D') AND DocStatus IN ('CO') ";
        if (this.ID_Order > 0) {
            sql = String.valueOf(sql) + " AND C_Order_ID = " + this.ID_Order;
        }
        sql = String.valueOf(sql) + " ORDER BY C_Order_ID DESC";
        CPreparedStatement pstmt = DB.prepareStatement(sql, this.get_TrxName());
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String sqlOrder = "SELECT *,(SELECT AD_Org_ID FROM C_Order WHERE C_Order_ID = " + rs.getInt("C_Order_ID") + ") as AD_Org_ID " + " FROM fact_calendar(" + rs.getInt("C_Order_ID") + ") WHERE periodo > (SELECT COALESCE(MAX(periodNo),0) FROM C_OrderPayCalendar " + " \tWHERE C_Order_ID = " + rs.getInt("C_Order_ID") + " AND IsInvoiced <> 'Y') " + " AND periodo <= (SELECT COALESCE(MAX(periodNo),0) FROM C_OrderPayCalendar " + " \tWHERE C_Order_ID = " + rs.getInt("C_Order_ID") + " AND IsInvoiced <> 'Y') + " + " \t(SELECT 24 - COUNT(1) FROM C_OrderPayCalendar WHERE C_Order_ID = " + rs.getInt("C_Order_ID") + " AND IsInvoiced <> 'Y')";
                try {
                    CPreparedStatement psOrder = DB.prepareStatement(sqlOrder, this.get_TrxName());
                    ResultSet rsOrder = psOrder.executeQuery();
                    while (rsOrder.next()) {
                        X_C_OrderPayCalendar pCal = new X_C_OrderPayCalendar(this.getCtx(), 0, this.get_TrxName());
                        pCal.setC_Order_ID(rs.getInt("C_Order_ID"));
                        pCal.setAD_Org_ID(rsOrder.getInt("AD_Org_ID"));
                        pCal.setIsActive(true);
                        pCal.setPeriodNo(rsOrder.getInt("periodo"));
                        pCal.setDateStart(rsOrder.getTimestamp("ini"));
                        pCal.setDateEnd(rsOrder.getTimestamp("fin"));
                        pCal.setLineNetAmt(rsOrder.getBigDecimal("neto"));
                        pCal.setLineTotalAmt(rsOrder.getBigDecimal("total"));
                        pCal.set_CustomColumn("C_DocType_ID", rs.getInt("doctype"));
                        pCal.save();
                    }
                }
                catch (Exception e) {
                    this.log.config(e.toString());
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return "@Created@=0";
    }
}

