/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.copesa.model.COPESAOrderOps;

public class CloseOrderCopesa
extends SvrProcess {
    private String p_docAction = "CL";
    private Timestamp p_FechaTermino = null;
    private String p_RazonTermino = null;
    private Object[] params;
    private Integer p_C_Order_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("FechaTermino")) {
                    this.p_FechaTermino = (Timestamp)para[i].getParameter();
                } else if (name.equals("RazonTermino")) {
                    this.p_RazonTermino = (String)para[i].getParameter();
                } else if (name.equals("C_Order_ID")) {
                    this.p_C_Order_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.p_FechaTermino == null) {
            this.p_FechaTermino = new Timestamp(System.currentTimeMillis());
        }
        this.params = new Object[3];
        this.params[0] = this.p_FechaTermino;
        this.params[1] = this.p_RazonTermino;
        this.params[2] = this.p_C_Order_ID;
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("FechaTermino=" + this.p_FechaTermino + ", C_Order_ID=" + this.p_C_Order_ID + ", DocAction=" + this.p_docAction);
        String sql = "UPDATE C_Order set FechaTermino = ?, RazonTermino = ? WHERE C_Order_ID = ?";
        DB.executeUpdateEx(sql, this.params, this.get_TrxName());
        if (this.p_FechaTermino.compareTo(new Timestamp(System.currentTimeMillis())) <= 0) {
            return COPESAOrderOps.closeOrder(this.p_C_Order_ID, this.get_TrxName(), this.getCtx());
        }
        return "Cierre de documento agendado";
    }
}

