/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MPriceList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModCOPESAValidPaymentRule
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAValidPaymentRule.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MPriceList pList;
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).isSOTrx() && (pList = new MPriceList(po.getCtx(), order.getM_PriceList_ID(), po.get_TrxName())).get_ValueAsString("PaymentRule") != null && pList.get_ValueAsString("PaymentRule").length() > 0 && pList.get_ValueAsString("PaymentRule") != "" && pList.get_ValueAsString("PaymentRule") != " " && order.getPaymentRule() != null && order.getPaymentRule().compareToIgnoreCase(pList.get_ValueAsString("PaymentRule")) != 0) {
            String namePRule = DB.getSQLValueString(po.get_TrxName(), "SELECT rlt.NAME  FROM AD_Ref_List rl  INNER JOIN AD_Ref_List_Trl rlt ON(rlt.AD_Ref_List_ID = rl.AD_Ref_List_ID AND AD_Language='es_MX')  WHERE AD_Reference_ID = 195 AND rl.value = '" + pList.get_ValueAsString("PaymentRule") + "'", new Object[0]);
            return "Error: Regla de pago debe ser " + namePRule;
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

