/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MSequence;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModCOPESAValidDocShipment
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAValidDocShipment.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInOut shipp;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MInOut.Table_ID && (shipp = (MInOut)po).isSOTrx()) {
            MDocType docType = new MDocType(po.getCtx(), shipp.getC_DocType_ID(), po.get_TrxName());
            MDocType docTypeParent = new MDocType(po.getCtx(), docType.get_ValueAsInt("C_DocTypeParent_ID"), po.get_TrxName());
            MSequence seq = new MSequence(po.getCtx(), docTypeParent.getDocNoSequence_ID(), po.get_TrxName());
            int endSeq = seq.get_ValueAsInt("EndNo");
            if (seq.getCurrentNext() > endSeq) {
                return "Error de Folio";
            }
            shipp.setDocumentNo(Integer.toString(seq.getCurrentNext()));
            shipp.save();
            seq.setCurrentNext(seq.getCurrentNext() + 1);
            seq.save();
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

