/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModCOPESAUpdateCalendarOrder
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAUpdateCalendarOrder.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).get_ValueAsInt("C_BPartner_Location2_ID") > 0 && order.getPaymentRule().compareTo("I") == 0 && order.get_ValueAsInt("C_Geozone_ID") > 0) {
            int ID_Calendar = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Calendarcopesa_ID)  FROM C_CalendarCopesa WHERE CalendarType = 'R' AND C_Geozone_ID = " + order.get_ValueAsInt("C_Geozone_ID"));
            int oldCalendarID = order.get_ValueAsInt("C_CalendarCOPESA_ID");
            if (ID_Calendar > 0) {
                order.set_CustomColumn("C_CalendarCOPESA_ID", ID_Calendar);
            }
            if (oldCalendarID != ID_Calendar) {
                order.set_CustomColumn("C_CalendarCOPESALine_ID", null);
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

