/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModCOPESAUpHoldDocs
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAUpHoldDocs.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MOrder order;
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).getC_Order_ID() > 0 && (order = new MOrder(po.getCtx(), inv.getC_Order_ID(), po.get_TrxName())).get_ValueAsBoolean("IsHold")) {
            inv.set_CustomColumn("IsHold", true);
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

