/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.copesa.utils.DateUtils;

public class ModCOPESASetDateEndOLine
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESASetDateEndOLine.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MOrderLine.Table_ID) {
            MOrderLine oLine = (MOrderLine)po;
            MOrder order = oLine.getParent();
            if (order.isSOTrx() && order.getDocStatus().compareToIgnoreCase("CO") != 0 && !oLine.get_ValueAsBoolean("IsFree") && oLine.getM_Product_ID() > 0) {
                int cant;
                Timestamp dateStart = (Timestamp)oLine.get_Value("DatePromised2");
                Timestamp dateEnd = (Timestamp)oLine.get_Value("DatePromised3");
                if (dateStart == null) {
                    dateStart = order.getDatePromised();
                    oLine.set_CustomColumn("DatePromised2", dateStart);
                }
                if (dateStart != null && dateEnd == null && (cant = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(DurationDays) as DurationDays  FROM M_ProductPrice pp  INNER JOIN M_PriceList_Version plv ON pp.M_PriceList_Version_ID = plv.M_PriceList_Version_ID  INNER JOIN M_PriceList pl ON plv.M_PriceList_ID = pl.M_PriceList_ID  WHERE pp.IsActive = 'Y' AND M_product_ID = " + oLine.getM_Product_ID() + " AND pl.M_priceList_ID = " + order.getM_PriceList_ID())) > 0) {
                    Calendar calCalendario = Calendar.getInstance();
                    calCalendario.setTimeInMillis(dateStart.getTime());
                    calCalendario.add(5, cant - 1);
                    Timestamp newDate = new Timestamp(calCalendario.getTimeInMillis());
                    oLine.set_CustomColumn("DatePromised3", newDate);
                }
            } else if (order.isSOTrx() && order.getDocStatus().compareToIgnoreCase("CO") != 0 && oLine.get_ValueAsBoolean("IsFree") && oLine.getM_Product_ID() > 0) {
                Timestamp dateStart = (Timestamp)oLine.get_Value("DatePromised2");
                Timestamp dateEnd = (Timestamp)oLine.get_Value("DatePromised3");
                if (dateStart == null) {
                    dateStart = order.getDatePromised();
                    oLine.set_CustomColumn("DatePromised2", dateStart);
                }
                if (dateStart != null && dateEnd == null) {
                    String sql = "SELECT FreeDays, durationdays  FROM M_ProductPrice pp  INNER JOIN M_PriceList_Version plv ON pp.M_PriceList_Version_ID = plv.M_PriceList_Version_ID  INNER JOIN M_PriceList pl ON plv.M_PriceList_ID = pl.M_PriceList_ID  WHERE pp.IsActive = 'Y' AND M_product_ID = " + oLine.getM_Product_ID() + " AND pl.M_priceList_ID = " + order.getM_PriceList_ID();
                    CPreparedStatement pstmt = DB.prepareStatement(sql, order.get_TrxName());
                    ResultSet rs = pstmt.executeQuery();
                    int duration = -1;
                    int freedays = -1;
                    if (rs.next()) {
                        freedays = rs.getInt(1);
                        duration = rs.getInt(2);
                        if (freedays <= 0) {
                            freedays = 1;
                        }
                        Calendar calCalendario = Calendar.getInstance();
                        calCalendario.setTimeInMillis(dateStart.getTime());
                        calCalendario.add(5, freedays - 1);
                        Timestamp newDate = new Timestamp(calCalendario.getTimeInMillis());
                        oLine.set_CustomColumn("DatePromised3", newDate);
                        int ID_LineRef = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_OrderLine_ID) FROM C_OrderLine WHERE C_OrderLineRef_ID = " + oLine.get_ID());
                        if (ID_LineRef > 0) {
                            MOrderLine oLineRef = new MOrderLine(po.getCtx(), ID_LineRef, po.get_TrxName());
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTimeInMillis(dateStart.getTime());
                            calendar.add(5, freedays);
                            oLineRef.set_CustomColumn("DatePromised2", new Timestamp(calendar.getTimeInMillis()));
                            dateEnd = null;
                            if (order.getPaymentRule().compareTo("D") == 0) {
                                dateEnd = DateUtils.veryDistantDate();
                            } else {
                                if (duration == 0) {
                                    duration = 1;
                                }
                                if (duration > 0) {
                                    calendar.add(5, duration - 1);
                                    dateEnd = new Timestamp(calendar.getTimeInMillis());
                                }
                            }
                            oLineRef.set_CustomColumn("DatePromised3", dateEnd);
                            oLineRef.save();
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

