/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModCOPESAGenOrderPayCal
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAGenOrderPayCal.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).isSOTrx()) {
            String sql = "select copesa_fillopc(?, ?, ?)";
            try {
                int NPERIODS = 24;
                CPreparedStatement pstmt = DB.prepareStatement(sql, order.get_TrxName());
                pstmt.setInt(1, order.getC_Order_ID());
                pstmt.setInt(2, Env.getAD_User_ID(order.getCtx()));
                pstmt.setInt(3, NPERIODS);
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                log.severe(e.getMessage());
                return "No se pudo crear calendario de facturaci\u00f3n";
            }
        }
        if ((timing == 10 || timing == 12) && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).isSOTrx()) {
            DB.executeUpdate("DELETE FROM C_OrderPayCalendar WHERE IsInvoiced <> 'Y' AND C_Order_ID = " + order.get_ID(), po.get_TrxName());
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    public boolean reqApproval(MOrder order) {
        BigDecimal amt;
        return order.getPaymentRule().compareTo("D") != 0 || (amt = DB.getSQLValueBD(null, "SELECT SUM(LineNetAmt)  FROM C_OrderLine WHERE C_Charge_ID > 0 AND C_Order_ID = ? ", order.get_ID())).compareTo(Env.ONEHUNDRED) >= 0;
    }
}

