/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModCOPESADateOrder
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESADateOrder.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).isSOTrx()) {
            MOrderLine[] oLines = order.getLines(false, null);
            int i = 0;
            while (i < oLines.length) {
                MOrderLine line = oLines[i];
                Timestamp dateStart = (Timestamp)line.get_Value("DatePromised2");
                Timestamp dateEnd = (Timestamp)line.get_Value("DatePromised3");
                if (line.get_ValueAsInt("C_OrderLineRef_ID") > 0 && line.get_ValueAsBoolean("IsFree")) {
                    MOrderLine lineAfter = new MOrderLine(po.getCtx(), line.get_ValueAsInt("C_OrderLineRef_ID"), po.get_TrxName());
                    Timestamp dateStartAfter = (Timestamp)lineAfter.get_Value("DatePromised2");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(dateEnd.getTime());
                    calendar.add(5, 1);
                    Timestamp newDate = new Timestamp(calendar.getTimeInMillis());
                    dateEnd.setHours(0);
                    dateEnd.setMinutes(0);
                    dateEnd.setSeconds(0);
                    newDate.setHours(0);
                    newDate.setMinutes(0);
                    newDate.setSeconds(0);
                    if (dateStartAfter.compareTo(newDate) != 0) {
                        return "Error: Fecha de Linea " + lineAfter.getLine() + " incorrecta";
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

