/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModCOPESACompleteInOut
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESACompleteInOut.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("M_InOut", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MInOut io;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 2 && po.get_Table_ID() == MInOut.Table_ID && po.is_ValueChanged("DocStatus") && (io = (MInOut)po).getDocStatus().compareToIgnoreCase("CO") == 0) {
            Timestamp dt = DB.getSQLValueTS(io.get_TrxName(), "select now()", null);
            io.setMovementDate(dt);
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    public boolean reqApproval(MOrder order) {
        BigDecimal amt;
        return order.getPaymentRule().compareTo("D") != 0 || (amt = DB.getSQLValueBD(null, "SELECT SUM(LineNetAmt)  FROM C_OrderLine WHERE C_Charge_ID > 0 AND C_Order_ID = ? ", order.get_ID())).compareTo(Env.ONEHUNDRED) >= 0;
    }
}

