/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_City;
import org.compiere.model.X_C_Province;
import org.compiere.model.X_C_Region;
import org.compiere.model.X_C_Street;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModCOPESABPUpdateLocationName
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESABPUpdateLocationName.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_BPartner_Location", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MBPartnerLocation.Table_ID) {
            X_C_Province prov;
            X_C_City city;
            MBPartnerLocation bpLoc = (MBPartnerLocation)po;
            String street = "";
            String typeStreet = "";
            typeStreet = DB.getSQLValueString(po.get_TrxName(), "SELECT NAME FROM AD_Ref_List WHERE AD_Reference_ID = 2000027 AND value = '" + bpLoc.get_ValueAsString("StreetType") + "'", new Object[0]);
            if (bpLoc.get_ValueAsInt("C_Street_ID") > 0) {
                X_C_Street calle = new X_C_Street(po.getCtx(), bpLoc.get_ValueAsInt("C_Street_ID"), po.get_TrxName());
                street = calle.getName();
                bpLoc.set_CustomColumn("StreetName", "");
            } else {
                street = bpLoc.get_ValueAsString("StreetName");
            }
            if (street == null || street == "" || street.trim().length() < 2) {
                return "Debe Ingresar Calle";
            }
            if (bpLoc.get_ValueAsInt("C_City_ID") > 0 && (city = new X_C_City(po.getCtx(), bpLoc.get_ValueAsInt("C_City_ID"), po.get_TrxName())).get_ValueAsInt("C_Province_ID") > 0) {
                bpLoc.set_CustomColumn("C_Province_ID", city.get_ValueAsInt("C_Province_ID"));
                prov = new X_C_Province(po.getCtx(), city.get_ValueAsInt("C_Province_ID"), po.get_TrxName());
                if (prov.getC_Region_ID() > 0) {
                    bpLoc.set_CustomColumn("C_Region_ID", prov.getC_Region_ID());
                }
            }
            String newName = String.valueOf(typeStreet) + " " + street + " " + bpLoc.get_ValueAsString("AddressNumber") + " " + bpLoc.get_ValueAsString("HomeNumber") + " " + bpLoc.get_ValueAsString("Block") + " " + bpLoc.get_ValueAsString("Villa");
            if (bpLoc.get_ValueAsInt("C_City_ID") > 0) {
                X_C_City city2 = new X_C_City(po.getCtx(), bpLoc.get_ValueAsInt("C_City_ID"), po.get_TrxName());
                newName = String.valueOf(newName) + " " + city2.getName();
            }
            if (bpLoc.get_ValueAsInt("C_Province_ID") > 0) {
                prov = new X_C_Province(po.getCtx(), bpLoc.get_ValueAsInt("C_Province_ID"), po.get_TrxName());
                newName = String.valueOf(newName) + " " + prov.getName();
            }
            if (bpLoc.get_ValueAsInt("C_Region_ID") > 0) {
                X_C_Region region = new X_C_Region(po.getCtx(), bpLoc.get_ValueAsInt("C_Region_ID"), po.get_TrxName());
                newName = String.valueOf(newName) + " " + region.getName();
            }
            bpLoc.setName(newName);
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

