/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;

public class CalloutCOPESASalesOrder
extends CalloutEngine {
    public String validCreditCard(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null || value == "") {
            return "";
        }
        if (value != null && value.toString().length() < 1) {
            return "";
        }
        if (CalloutCOPESASalesOrder.validateCC2(value.toString())) {
            String nameCC = "";
            nameCC = this.getNameCreditCard(value.toString());
            if (nameCC != null && nameCC.trim() != "") {
                if (nameCC.compareToIgnoreCase("mastercard") == 0) {
                    mTab.setValue("CreditCardType", (Object)"M");
                }
                if (nameCC.compareToIgnoreCase("visa") == 0) {
                    mTab.setValue("CreditCardType", (Object)"V");
                }
                if (nameCC.compareToIgnoreCase("american express") == 0) {
                    mTab.setValue("CreditCardType", (Object)"A");
                }
                if (nameCC.compareToIgnoreCase("diners club") == 0) {
                    mTab.setValue("CreditCardType", (Object)"D");
                }
                if (nameCC.compareToIgnoreCase("discover") == 0) {
                    mTab.setValue("CreditCardType", (Object)"N");
                }
            }
            return "Tarjeta V\u00e1lida - " + this.getNameCreditCard(value.toString());
        }
        mTab.setValue(mField.getColumnName(), (Object)"");
        return "Tarjeta NO V\u00e1lida";
    }

    public String validMail(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null || value == "") {
            return "";
        }
        if (value != null && value.toString().length() < 1) {
            return "";
        }
        if (this.isEmail(value.toString())) {
            return "Correo V\u00e1lido";
        }
        mTab.setValue(mField.getColumnName(), (Object)"");
        return "Correo NO V\u00e1lido ";
    }

    public String calculateNewPrice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null || value == "") {
            return "";
        }
        if (value != null && value.toString().length() < 1) {
            return "";
        }
        return "";
    }

    public String getNameCreditCard(String sTarjeta) {
        double tarjeta = Integer.parseInt(sTarjeta.substring(0, 3));
        String nameTarjeta = "";
        if (tarjeta >= 510.0 && tarjeta <= 559.0) {
            nameTarjeta = "Mastercard";
        } else if (tarjeta >= 400.0 && tarjeta <= 499.0) {
            nameTarjeta = "Visa";
        } else if (tarjeta >= 340.0 && tarjeta <= 379.0) {
            nameTarjeta = "American Express";
        } else if (tarjeta >= 300.0 && tarjeta <= 305.0) {
            nameTarjeta = "Diners Club";
        } else if (tarjeta >= 400.0 && tarjeta <= 499.0) {
            nameTarjeta = "Visa";
        } else if (tarjeta == 6011.0) {
            nameTarjeta = "Discover";
        } else if (tarjeta == 6520.0) {
            nameTarjeta = "Palacio del Hierro";
        }
        return nameTarjeta;
    }

    public static boolean validateCC2(String numero) {
        int s1 = 0;
        int s2 = 0;
        String reversa = new StringBuffer(numero).reverse().toString();
        int i = 0;
        while (i < reversa.length()) {
            int digito = Character.digit(reversa.charAt(i), 10);
            if (i % 2 == 0) {
                s1 += digito;
            } else {
                s2 += 2 * digito;
                if (digito >= 5) {
                    s2 -= 9;
                }
            }
            ++i;
        }
        System.out.println("La tarjeta es:");
        return (s1 + s2) % 10 == 0;
    }

    public boolean isEmail(String correo) {
        Pattern pat = null;
        Matcher mat = null;
        pat = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
        mat = pat.matcher(correo);
        if (mat.find()) {
            System.out.println("[" + mat.group() + "]");
            return true;
        }
        return false;
    }
}

