/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_WF_Process;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.process.StateEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFResponsible;
import org.compiere.wf.MWorkflow;

public class MWFProcess
extends X_AD_WF_Process {
    private static final long serialVersionUID = -8992222567597358696L;
    private StateEngine m_state = null;
    private MWFActivity[] m_activities = null;
    private MWorkflow m_wf = null;
    private PO m_po = null;
    private String m_processMsg = null;

    public MWFProcess(Properties ctx, int AD_WF_Process_ID, String trxName) {
        super(ctx, AD_WF_Process_ID, trxName);
        if (AD_WF_Process_ID == 0) {
            throw new IllegalArgumentException("Cannot create new WF Process directly");
        }
        this.m_state = new StateEngine(this.getWFState());
    }

    public MWFProcess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_state = new StateEngine(this.getWFState());
    }

    public MWFProcess(MWorkflow wf, ProcessInfo pi) throws Exception {
        this(wf, pi, wf.get_TrxName());
    }

    public MWFProcess(MWorkflow wf, ProcessInfo pi, String trxName) throws Exception {
        super(wf.getCtx(), 0, trxName);
        if (!TimeUtil.isValid(wf.getValidFrom(), wf.getValidTo())) {
            throw new IllegalStateException("Workflow not valid");
        }
        this.m_wf = wf;
        this.setAD_Workflow_ID(wf.getAD_Workflow_ID());
        this.setPriority(wf.getPriority());
        super.setWFState("ON");
        this.setAD_Table_ID(wf.getAD_Table_ID());
        this.setRecord_ID(pi.getRecord_ID());
        if (this.getPO() == null) {
            this.setTextMsg("No PO with ID=" + pi.getRecord_ID());
            this.addTextMsg(new Exception(""));
            super.setWFState("CT");
        } else {
            this.setTextMsg(this.getPO());
        }
        if (wf.getAD_WF_Responsible_ID() == 0) {
            this.setAD_WF_Responsible_ID();
        } else {
            this.setAD_WF_Responsible_ID(wf.getAD_WF_Responsible_ID());
        }
        this.setUser_ID(pi.getAD_User_ID());
        this.m_state = new StateEngine(this.getWFState());
        this.setProcessed(false);
        this.getPO();
    }

    public MWFActivity[] getActivities(boolean requery, boolean onlyActive) {
        return this.getActivities(requery, onlyActive, this.get_TrxName());
    }

    public MWFActivity[] getActivities(boolean requery, boolean onlyActive, String trxName) {
        if (!requery && this.m_activities != null) {
            return this.m_activities;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("AD_WF_Process_ID=?");
        params.add(this.getAD_WF_Process_ID());
        if (onlyActive) {
            whereClause.append(" AND Processed=?");
            params.add(false);
        }
        List<MWFActivity> list = new Query(this.getCtx(), "AD_WF_Activity", whereClause.toString(), trxName).setParameters(params).list();
        this.m_activities = new MWFActivity[list.size()];
        list.toArray(this.m_activities);
        return this.m_activities;
    }

    public StateEngine getState() {
        return this.m_state;
    }

    public String[] getActionOptions() {
        return this.m_state.getActionOptions();
    }

    @Override
    public void setWFState(String WFState) {
        if (this.m_state == null) {
            this.m_state = new StateEngine(this.getWFState());
        }
        if (this.m_state.isClosed()) {
            return;
        }
        if (this.getWFState().equals(WFState)) {
            return;
        }
        if (this.m_state.isValidNewState(WFState)) {
            this.log.fine(WFState);
            super.setWFState(WFState);
            this.m_state = new StateEngine(this.getWFState());
            if (this.m_state.isClosed()) {
                this.setProcessed(true);
            }
            this.save();
            if (this.m_state.isClosed()) {
                MWFActivity[] activities = this.getActivities(true, true);
                for (int i2 = 0; i2 < activities.length; ++i2) {
                    if (!activities[i2].isClosed()) {
                        activities[i2].setTextMsg("Process:" + WFState);
                        activities[i2].setWFState(WFState);
                    }
                    if (!activities[i2].isProcessed()) {
                        activities[i2].setProcessed(true);
                    }
                    activities[i2].saveEx();
                }
            }
        } else {
            this.log.log(Level.SEVERE, "Ignored Invalid Transformation - New=" + WFState + ", Current=" + this.getWFState());
        }
    }

    public void checkActivities(String trxName, PO lastPO) {
        this.log.info("(" + this.getAD_Workflow_ID() + ") - " + this.getWFState() + (trxName == null ? "" : "[" + trxName + "]"));
        if (this.m_state.isClosed()) {
            return;
        }
        if (lastPO != null && lastPO.get_ID() == this.getRecord_ID()) {
            this.m_po = lastPO;
        }
        MWFActivity[] activities = this.getActivities(true, true, trxName);
        String closedState = null;
        boolean suspended = false;
        boolean running = false;
        for (int i2 = 0; i2 < activities.length; ++i2) {
            MWFActivity activity = activities[i2];
            StateEngine activityState = activity.getState();
            if (activityState.isCompleted() && this.startNext(activity, activities, lastPO, trxName)) continue;
            String activityWFState = activity.getWFState();
            if (activityState.isClosed()) {
                activity.setProcessed(true);
                activity.saveEx();
                if (closedState == null) {
                    closedState = activityWFState;
                    continue;
                }
                if (closedState.equals(activityState)) continue;
                if ("CT".equals(activityState)) {
                    closedState = activityWFState;
                    continue;
                }
                if (!"CA".equals(activityState) || "CT".equals(closedState)) continue;
                closedState = activityWFState;
                continue;
            }
            closedState = null;
            if (activityState.isSuspended()) {
                suspended = true;
            }
            if (!activityState.isRunning()) continue;
            running = true;
        }
        if (activities.length == 0) {
            this.setTextMsg("No Active Processed found");
            this.addTextMsg(new Exception(""));
            closedState = "CT";
        }
        if (closedState != null) {
            this.setWFState(closedState);
            this.getPO();
        } else if (suspended) {
            this.setWFState("OS");
        } else if (running) {
            this.setWFState("OR");
        }
    }

    private boolean startNext(MWFActivity last, MWFActivity[] activities, PO lastPO, String trxName) {
        this.log.fine("Last=" + last);
        MWFNodeNext[] transitions = this.getWorkflow().getNodeNexts(last.getAD_WF_Node_ID(), last.getPO_AD_Client_ID());
        if (transitions == null || transitions.length == 0) {
            return false;
        }
        if ("A".equals(last.getNode().getJoinElement())) {
            // empty if block
        }
        last.setProcessed(true);
        last.saveEx();
        String split = last.getNode().getSplitElement();
        for (int i2 = 0; i2 < transitions.length; ++i2) {
            if (!transitions[i2].isValidFor(last)) continue;
            MWFActivity activity = new MWFActivity(this, transitions[i2].getAD_WF_Next_ID(), lastPO);
            activity.set_TrxName(trxName);
            activity.run();
            if (!"X".equals(split)) continue;
            return true;
        }
        return true;
    }

    public void setAD_WF_Responsible_ID() {
        int AD_WF_Responsible_ID = DB.getSQLValueEx(null, MRole.getDefault(this.getCtx(), false).addAccessSQL("SELECT AD_WF_Responsible_ID FROM AD_WF_Responsible WHERE ResponsibleType='H' AND COALESCE(AD_User_ID,0)=0 ORDER BY AD_Client_ID DESC", "AD_WF_Responsible", false, false), new Object[0]);
        this.setAD_WF_Responsible_ID(AD_WF_Responsible_ID);
    }

    private void setUser_ID(Integer User_ID) {
        MWFResponsible resp = MWFResponsible.get(this.getCtx(), this.getAD_WF_Responsible_ID());
        int AD_User_ID = resp.getAD_User_ID();
        if (AD_User_ID == 0 && resp.isInvoker()) {
            Object sr;
            this.getPO();
            if (this.m_po != null && this.m_po instanceof DocAction) {
                DocAction da = (DocAction)((Object)this.m_po);
                AD_User_ID = da.getDoc_User_ID();
            }
            if (AD_User_ID == 0 && this.m_po != null && this.m_po.get_ColumnIndex("SalesRep_ID") != -1 && (sr = this.m_po.get_Value("SalesRep_ID")) != null && sr instanceof Integer) {
                AD_User_ID = (Integer)sr;
            }
            if (AD_User_ID == 0 && this.m_po != null) {
                AD_User_ID = this.m_po.getUpdatedBy();
            }
        }
        if (AD_User_ID == 0 && User_ID != null) {
            AD_User_ID = User_ID;
        }
        if (AD_User_ID == 0) {
            AD_User_ID = Env.getAD_User_ID(this.getCtx());
        }
        this.setAD_User_ID(AD_User_ID);
    }

    private MWorkflow getWorkflow() {
        if (this.m_wf == null) {
            this.m_wf = MWorkflow.get(this.getCtx(), this.getAD_Workflow_ID());
        }
        if (this.m_wf.get_ID() == 0) {
            throw new IllegalStateException("Not found - AD_Workflow_ID=" + this.getAD_Workflow_ID());
        }
        return this.m_wf;
    }

    public boolean perform(String action) {
        if (!this.m_state.isValidAction(action)) {
            this.log.log(Level.SEVERE, "Ignored Invalid Transformation - Action=" + action + ", CurrentState=" + this.getWFState());
            return false;
        }
        this.log.fine(action);
        if ("Start".equals(action)) {
            return this.startWork();
        }
        this.setWFState(this.m_state.getNewStateIfAction(action));
        return true;
    }

    public boolean startWork() {
        if (!this.m_state.isValidAction("Start")) {
            this.log.warning("State=" + this.getWFState() + " - cannot start");
            return false;
        }
        int AD_WF_Node_ID = this.getWorkflow().getAD_WF_Node_ID();
        this.log.fine("AD_WF_Node_ID=" + AD_WF_Node_ID);
        this.setWFState("OR");
        try {
            MWFActivity activity = new MWFActivity(this, AD_WF_Node_ID);
            activity.run();
        }
        catch (Throwable e) {
            this.log.log(Level.SEVERE, "AD_WF_Node_ID=" + AD_WF_Node_ID, e);
            this.setTextMsg(e.toString());
            this.addTextMsg(e);
            this.setWFState("CT");
            return false;
        }
        return true;
    }

    public PO getPO() {
        if (this.m_po != null) {
            return this.m_po;
        }
        if (this.getRecord_ID() == 0) {
            return null;
        }
        MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID());
        this.m_po = table2.getPO(this.getRecord_ID(), this.get_TrxName());
        return this.m_po;
    }

    public void setTextMsg(PO po) {
        if (po != null && po instanceof DocAction) {
            this.setTextMsg(((DocAction)((Object)po)).getSummary());
        }
    }

    @Override
    public void setTextMsg(String TextMsg) {
        String oldText = this.getTextMsg();
        if (oldText == null || oldText.length() == 0) {
            super.setTextMsg(TextMsg);
        } else if (TextMsg != null && TextMsg.length() > 0) {
            super.setTextMsg(oldText + "\n - " + TextMsg);
        }
    }

    public void addTextMsg(Object obj) {
        if (obj == null) {
            return;
        }
        StringBuffer TextMsg = new StringBuffer();
        if (obj instanceof Exception) {
            Exception ex = (Exception)obj;
            if (ex.getMessage() != null && ex.getMessage().trim().length() > 0) {
                TextMsg.append(ex.toString());
            } else if (ex instanceof NullPointerException) {
                TextMsg.append(ex.getClass().getName());
            }
            while (ex != null) {
                StackTraceElement[] st = ex.getStackTrace();
                for (int i2 = 0; i2 < st.length; ++i2) {
                    StackTraceElement ste = st[i2];
                    if (i2 != 0 && !ste.getClassName().startsWith("org.compiere") && !ste.getClassName().startsWith("org.adempiere")) continue;
                    TextMsg.append(" (").append(i2).append("): ").append(ste.toString()).append("\n");
                }
                if (ex.getCause() instanceof Exception) {
                    ex = (Exception)ex.getCause();
                    continue;
                }
                ex = null;
            }
        } else {
            TextMsg.append(obj.toString());
        }
        String oldText = this.getTextMsg();
        if (oldText == null || oldText.length() == 0) {
            super.setTextMsg(Util.trimSize(TextMsg.toString(), 1000));
        } else if (TextMsg != null && TextMsg.length() > 0) {
            super.setTextMsg(Util.trimSize(oldText + "\n - " + TextMsg.toString(), 1000));
        }
    }

    public void setProcessMsg(String msg) {
        this.m_processMsg = msg;
        if (msg != null && msg.length() > 0) {
            this.setTextMsg(msg);
        }
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }
}

