/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.h1;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.html;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.meta;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.title;
import org.apache.ecs.xhtml.tr;
import org.compiere.util.StoredHtmlSrc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;

public class WebDoc {
    public static final String NBSP = "&nbsp;";
    private html m_html = new html();
    private head m_head = new head();
    private body m_body = new body();
    private table m_table = null;
    private tr m_topRow = null;
    private td m_topRight = null;
    private td m_topLeft = null;

    public static WebDoc create(boolean plain, String title, boolean javaClient) {
        WebDoc doc = new WebDoc();
        doc.setUp(plain, javaClient, title);
        return doc;
    }

    public static WebDoc create(boolean plain) {
        return WebDoc.create(plain, null, false);
    }

    public static WebDoc createPopup(String title) {
        WebDoc doc = WebDoc.create(title);
        doc.getHead().addElement((Element)new script((Element)null, "/adempiere/js/window.js"));
        doc.getHead().addElement((Element)new script((Element)null, "/adempiere/js/calendar.js"));
        doc.getHead().addElement((Element)new script((Element)null, "/adempiere/js/table.js"));
        doc.getHead().addElement((Element)new script((Element)null, "/adempiere/lang/calendar-en.js"));
        doc.getHead().addElement((Element)new link("/adempiere/css/window.css", "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new link("/adempiere/css/popup.css", "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new link("/adempiere/css/table.css", "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new link("/adempiere/css/calendar-blue.css", "stylesheet", "text/css"));
        doc.setClasses("popupTable", "popupHeader");
        doc.getTable().setCellSpacing(0);
        return doc;
    }

    public static WebDoc createWindow(String title) {
        WebDoc doc = WebDoc.create(title);
        doc.getHead().addElement((Element)new script((Element)null, "/adempiere/js/window.js"));
        doc.getHead().addElement((Element)new script((Element)null, "/adempiere/js/calendar.js"));
        doc.getHead().addElement((Element)new script((Element)null, "/adempiere/js/table.js"));
        doc.getHead().addElement((Element)new script((Element)null, "/adempiere/lang/calendar-en.js"));
        doc.getHead().addElement((Element)new link("/adempiere/css/window.css", "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new link("/adempiere/css/calendar-blue.css", "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new link("/adempiere/css/table.css", "stylesheet", "text/css"));
        doc.setClasses("windowTable", "windowHeader");
        doc.getTable().setCellSpacing(0);
        return doc;
    }

    public static WebDoc create(String title) {
        return WebDoc.create(false, title, false);
    }

    private WebDoc() {
    }

    private void setUp(boolean plain, boolean javaClient, String title2) {
        this.m_html.addElement((Element)this.m_head);
        this.m_html.addElement((Element)this.m_body);
        this.m_body.addElement((Element)new a().setName("top"));
        if (title2 != null) {
            this.m_head.addElement((Element)new title(title2));
        }
        if (plain) {
            return;
        }
        if (javaClient) {
            this.m_head.addElement((Element)new StoredHtmlSrc("STYLE", "org/compiere/images/standard.css"));
        } else {
            this.m_head.addElement((Element)new link(WebEnv.getStylesheetURL(), "stylesheet", "text/css"));
            this.m_head.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory("/js/standard.js")));
        }
        this.m_head.addElement((Element)new meta().setHttpEquiv("Content-Type", "text/html; charset=UTF-8"));
        this.m_head.addElement((Element)new meta().setName("description", "ADempiere HTML UI"));
        this.m_table = new table("0", "0", "0", "100%", null);
        this.m_topRow = new tr();
        this.m_topLeft = new td();
        if (title2 == null) {
            this.m_topLeft.addElement(NBSP);
        } else {
            this.m_topLeft.addElement((Element)new h1(title2));
        }
        this.m_topRow.addElement((Element)this.m_topLeft);
        this.m_topRight = new td().setAlign("right");
        if (javaClient) {
            this.m_topRight.addElement((Element)new img("res:org/compiere/images/AD10030.png").setAlign("right").setAlt("ADempiere"));
        } else if (title2.equals("")) {
            this.m_topRight.addElement((Element)WebEnv.getLogo());
        } else {
            this.m_topRight.addElement((Element)new h1(title2));
        }
        this.m_topRow.addElement((Element)this.m_topRight);
        this.m_table.addElement((Element)this.m_topRow);
        this.m_body.addElement((Element)this.m_table);
    }

    public void setClasses(String tableClass, String tdClass) {
        if (this.m_table != null && tableClass != null) {
            this.m_table.setClass(tableClass);
        }
        if (this.m_topLeft != null && tdClass != null) {
            this.m_topLeft.setClass(tdClass);
        }
        if (this.m_topRight != null && tdClass != null) {
            this.m_topRight.setClass(tdClass);
        }
    }

    public body getBody() {
        return this.m_body;
    }

    public head getHead() {
        return this.m_head;
    }

    public table getTable() {
        return this.m_table;
    }

    public tr getTopRow() {
        return this.m_topRow;
    }

    public td getTopLeft() {
        return this.m_topLeft;
    }

    public td getTopRight() {
        return this.m_topRight;
    }

    public String toString() {
        return this.m_html.toString();
    }

    public void output(OutputStream out) {
        this.m_html.output(out);
    }

    public void output(PrintWriter out) {
        this.m_html.output(out);
    }

    public td addPopupCenter(boolean nowrap) {
        if (this.m_table == null) {
            return null;
        }
        td center = new td("popupCenter", "center", "middle", nowrap);
        center.setColSpan(2);
        this.m_table.addElement((Element)new tr().addElement((Element)center));
        return center;
    }

    public td[] addPopupClose(Properties ctx) {
        input button = WebUtil.createClosePopupButton(ctx);
        if (this.m_table == null) {
            this.m_body.addElement((Element)button);
            return null;
        }
        td left = new td("popupFooter", "left", "middle", false, null);
        td right = new td("popupFooter", "right", "middle", false, (Element)button);
        this.m_table.addElement((Element)new tr().addElement((Element)left).addElement((Element)right));
        return new td[]{left, right};
    }

    public td addWindowCenter(boolean nowrap) {
        if (this.m_table == null) {
            return null;
        }
        td center = new td("windowCenter", "center", "middle", nowrap);
        center.setColSpan(2);
        this.m_table.addElement((Element)new tr().addElement((Element)center));
        return center;
    }

    public td[] addWindowFooters() {
        if (this.m_table == null) {
            return null;
        }
        td left = new td("windowFooter", "left", "middle", false);
        td right = new td("windowFooter", "right", "middle", false);
        this.m_table.addElement((Element)new tr().addElement((Element)left).addElement((Element)right));
        return new td[]{left, right};
    }

    public td addWindowFooter() {
        if (this.m_table == null) {
            return null;
        }
        td center = new td("windowFooter", "center", "middle", false);
        this.m_table.addElement((Element)new tr().addElement((Element)center));
        return center;
    }

    public static void main(String[] args) {
        WebDoc doc = WebDoc.create("Test");
        doc.getBody().addElement((Element)new b("111 <<< >>> &&& \\\\ \u0100 \ufffd"));
        form f = new form("myaction");
        f.addElement((Element)new input());
        doc.getBody().addElement((Element)f);
        System.out.println(doc.toString());
        System.out.println("---------");
        doc.output(System.out);
        System.out.println("---------");
    }
}

