/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.compiere.util.CLogMgt;

public class EnvLoader {
    private static final boolean DEBUG = false;

    public static boolean load(String prefix) {
        Properties prop = EnvLoader.getEnv(prefix);
        if (prop == null) {
            return false;
        }
        Object[] pp = prop.keySet().toArray();
        for (int i2 = 0; i2 < pp.length; ++i2) {
            String key = pp[i2].toString();
            String value = prop.getProperty(key);
            System.setProperty(key, value);
        }
        CLogMgt.printProperties(System.getProperties(), "System with Environment", false);
        return true;
    }

    public static Properties getEnv(String prefix) {
        String result;
        String cmd = "cmd /c set";
        if (!System.getProperty("os.name", "").startsWith("Win")) {
            cmd = "set";
        }
        if ((result = EnvLoader.execCommand(cmd)) == null || result.length() == 0) {
            return null;
        }
        if (prefix == null) {
            prefix = "";
        }
        return EnvLoader.parseEnv(result, prefix);
    }

    private static String execCommand(String command) {
        Process cmd;
        try {
            cmd = Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            System.err.println("-- Error executing command: " + command + " - " + e.toString());
            return null;
        }
        StringBuffer bufOut = new StringBuffer();
        StringBuffer bufErr = new StringBuffer();
        try {
            int c;
            InputStream in = cmd.getInputStream();
            InputStream err = cmd.getErrorStream();
            while ((c = in.read()) != -1) {
                bufOut.append((char)c);
            }
            in.close();
            while ((c = err.read()) != -1) {
                bufErr.append((char)c);
            }
            err.close();
        }
        catch (Exception e) {
            System.err.println("-- Error reading output: " + e.toString());
            return null;
        }
        return bufOut.toString();
    }

    private static Properties parseEnv(String input2, String prefix) {
        Properties prop = new Properties();
        String separator = System.getProperty("line.separator", "\n");
        StringTokenizer st = new StringTokenizer(input2, separator);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int pos = s.indexOf(61);
            if (pos <= 0) continue;
            prop.setProperty(prefix + s.substring(0, pos), s.substring(pos + 1));
        }
        return prop;
    }
}

