/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import org.compiere.report.JasperReportViewer;
import org.compiere.util.CLogger;

class ReportView
implements ActionListener {
    private JasperReportViewer viewer;
    private JComboBox<Object> comboBox;
    private static final CLogger s_log = CLogger.getCLogger(ReportView.class);

    public ReportView(JasperReportViewer viewer, JComboBox<Object> comboBox) {
        this.viewer = viewer;
        this.comboBox = comboBox;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(this.viewer.getJasperPrint().getName() + "." + this.viewer.getFormat().toLowerCase()));
        if (fileChooser.showSaveDialog((Component)((Object)this.viewer)) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                if (this.viewer.getFormat().equals("PDF")) {
                    JasperExportManager.exportReportToPdfFile((JasperPrint)this.viewer.getJasperPrint(), (String)file.getAbsolutePath());
                } else if (this.comboBox.getSelectedItem().equals("HTML")) {
                    JasperExportManager.exportReportToHtmlFile((JasperPrint)this.viewer.getJasperPrint(), (String)file.getAbsolutePath());
                } else if (this.comboBox.getSelectedItem().equals("XLS")) {
                    FileOutputStream fos = new FileOutputStream(file);
                    JRXlsExporter exporterXLS = new JRXlsExporter();
                    exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, (Object)this.viewer.getJasperPrint());
                    exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, (Object)fos);
                    exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_FILE, (Object)file.getAbsolutePath());
                    exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
                    exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
                    exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
                    exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
                    exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)Boolean.TRUE);
                    exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)Boolean.FALSE);
                    exporterXLS.exportReport();
                }
            }
            catch (JRException e) {
                s_log.severe("Failed to generate Excel report : " + e.getMessage());
            }
            catch (IOException e) {
                s_log.severe("Failed to generate Excel report : " + e.getMessage());
            }
        }
    }
}

