/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.X_PA_ReportLine;
import org.compiere.report.MReportSource;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MReportLine
extends X_PA_ReportLine {
    private static final long serialVersionUID = -3957315092529097396L;
    private MReportSource[] m_sources = null;
    private String m_whereClause = null;

    public MReportLine(Properties ctx, int PA_ReportLine_ID, String trxName) {
        super(ctx, PA_ReportLine_ID, trxName);
        if (PA_ReportLine_ID == 0) {
            this.setSeqNo(0);
            this.setIsPrinted(false);
        } else {
            this.loadSources();
        }
    }

    public MReportLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.loadSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSources() {
        ArrayList<MReportSource> list = new ArrayList<MReportSource>();
        String sql = "SELECT * FROM PA_ReportSource WHERE PA_ReportLine_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getPA_ReportLine_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MReportSource(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, null, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_sources = new MReportSource[list.size()];
        list.toArray(this.m_sources);
        this.log.finest("ID=" + this.getPA_ReportLine_ID() + " - Size=" + list.size());
    }

    public MReportSource[] getSources() {
        return this.m_sources;
    }

    public void list() {
        System.out.println("- " + this.toString());
        if (this.m_sources == null) {
            return;
        }
        for (int i2 = 0; i2 < this.m_sources.length; ++i2) {
            System.out.println("  - " + this.m_sources[i2].toString());
        }
    }

    public String getSourceColumnName() {
        String ColumnName = null;
        for (int i2 = 0; i2 < this.m_sources.length; ++i2) {
            String col = MAcctSchemaElement.getColumnName(this.m_sources[i2].getElementType());
            if (ColumnName == null || ColumnName.length() == 0) {
                ColumnName = col;
                continue;
            }
            if (ColumnName.equals(col)) continue;
            this.log.config("More than one: " + ColumnName + " - " + col);
            return null;
        }
        return ColumnName;
    }

    public String getSourceValueQuery() {
        if (this.m_sources != null && this.m_sources.length > 0) {
            return MAcctSchemaElement.getValueQuery(this.m_sources[0].getElementType());
        }
        return null;
    }

    public String getSelectClause(boolean withSum) {
        String at = this.getPAAmountType().substring(0, 1);
        StringBuffer sb = new StringBuffer();
        if (withSum) {
            sb.append("SUM(");
        }
        if ("B".equals(at)) {
            sb.append("acctBalance(Account_ID,AmtAcctDr,AmtAcctCr)");
        } else if ("S".equals(at)) {
            sb.append("AmtAcctDr-AmtAcctCr");
        } else if ("C".equals(at)) {
            sb.append("AmtAcctCr");
        } else if ("D".equals(at)) {
            sb.append("AmtAcctDr");
        } else if ("R".equals(at)) {
            sb.append("Qty");
        } else if ("Q".equals(at)) {
            sb.append("acctBalance(Account_ID,Qty,0)");
        } else {
            this.log.log(Level.SEVERE, "AmountType=" + this.getPAAmountType() + ", at=" + at);
            return "NULL";
        }
        if (withSum) {
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isPeriod() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "P".equals(pt);
    }

    public boolean isYear() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "Y".equals(pt);
    }

    public boolean isTotal() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "T".equals(pt);
    }

    public boolean isNatural() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "N".equals(pt);
    }

    public String getWhereClause(int PA_Hierarchy_ID) {
        if (this.m_sources == null) {
            return "";
        }
        if (this.m_whereClause == null) {
            if (this.m_sources.length == 0) {
                this.m_whereClause = "";
            } else if (this.m_sources.length == 1) {
                this.m_whereClause = this.m_sources[0].getWhereClause(PA_Hierarchy_ID);
            } else {
                StringBuffer sb = new StringBuffer("(");
                for (int i2 = 0; i2 < this.m_sources.length; ++i2) {
                    if (i2 > 0) {
                        sb.append(" OR ");
                    }
                    sb.append(this.m_sources[i2].getWhereClause(PA_Hierarchy_ID));
                }
                sb.append(")");
                this.m_whereClause = sb.toString();
            }
            String PostingType = this.getPostingType();
            if (PostingType != null && PostingType.length() > 0) {
                if (this.m_whereClause.length() > 0) {
                    this.m_whereClause = this.m_whereClause + " AND ";
                }
                this.m_whereClause = this.m_whereClause + "PostingType='" + PostingType + "'";
                if (PostingType.equals("B") && this.getGL_Budget_ID() > 0) {
                    this.m_whereClause = this.m_whereClause + " AND GL_Budget_ID=" + this.getGL_Budget_ID();
                }
            }
            this.log.fine(this.m_whereClause);
        }
        return this.m_whereClause;
    }

    public boolean isPostingType() {
        String PostingType = this.getPostingType();
        return PostingType != null && PostingType.length() > 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MReportLine[").append(this.get_ID()).append(" - ").append(this.getName()).append(" - ").append(this.getDescription()).append(", SeqNo=").append(this.getSeqNo()).append(", AmountType=").append(this.getPAAmountType()).append(", PeriodType=").append(this.getPAPeriodType()).append(" - LineType=").append(this.getLineType());
        if (this.isLineTypeCalculation()) {
            sb.append(" - Calculation=").append(this.getCalculationType()).append(" - ").append(this.getOper_1_ID()).append(" - ").append(this.getOper_2_ID());
        } else {
            sb.append(" - SegmentValue - PostingType=").append(this.getPostingType()).append(", AmountType=").append(this.getPAAmountType()).append(", PeriodType=").append(this.getPAPeriodType());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isLineTypeCalculation() {
        return "C".equals(this.getLineType());
    }

    public boolean isLineTypeSegmentValue() {
        return "S".equals(this.getLineType());
    }

    public boolean isCalculationTypeRange() {
        return "R".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeAdd() {
        return "A".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeSubtract() {
        return "S".equals(this.getCalculationType());
    }

    public boolean isCalculationTypePercent() {
        return "P".equals(this.getCalculationType());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if ("S".equals(this.getLineType())) {
            if (this.getCalculationType() != null) {
                this.setCalculationType(null);
            }
            if (this.getOper_1_ID() != 0) {
                this.setOper_1_ID(0);
            }
            if (this.getOper_2_ID() != 0) {
                this.setOper_2_ID(0);
            }
        }
        return true;
    }

    public static MReportLine copy(Properties ctx, int AD_Client_ID, int AD_Org_ID, int PA_ReportLineSet_ID, MReportLine source, String trxName) {
        MReportLine retValue = new MReportLine(ctx, 0, trxName);
        MReportLine.copyValues(source, retValue, AD_Client_ID, AD_Org_ID);
        retValue.setPA_ReportLineSet_ID(PA_ReportLineSet_ID);
        retValue.setOper_1_ID(0);
        retValue.setOper_2_ID(0);
        return retValue;
    }
}

