/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ProjectGenOrder;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class ProjectPhaseGenOrder
extends SvrProcess {
    private int m_C_ProjectPhase_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.m_C_ProjectPhase_ID = this.getRecord_ID();
        this.log.info("doIt - C_ProjectPhase_ID=" + this.m_C_ProjectPhase_ID);
        if (this.m_C_ProjectPhase_ID == 0) {
            throw new IllegalArgumentException("C_ProjectPhase_ID == 0");
        }
        MProjectPhase fromPhase = new MProjectPhase(this.getCtx(), this.m_C_ProjectPhase_ID, this.get_TrxName());
        MProject fromProject = ProjectGenOrder.getProject(this.getCtx(), fromPhase.getC_Project_ID(), this.get_TrxName());
        MOrder order = new MOrder(fromProject, true, "WI");
        order.setDescription(order.getDescription() + " - " + fromPhase.getName());
        if (!order.save()) {
            throw new Exception("Could not create Order");
        }
        if (fromPhase.getM_Product_ID() != 0) {
            MOrderLine ol = new MOrderLine(order);
            ol.setLine(fromPhase.getSeqNo());
            StringBuffer sb = new StringBuffer(fromPhase.getName());
            if (fromPhase.getDescription() != null && fromPhase.getDescription().length() > 0) {
                sb.append(" - ").append(fromPhase.getDescription());
            }
            ol.setDescription(sb.toString());
            ol.setM_Product_ID(fromPhase.getM_Product_ID(), true);
            ol.setQty(fromPhase.getQty());
            ol.setPrice();
            if (fromPhase.getPriceActual() != null && fromPhase.getPriceActual().compareTo(Env.ZERO) != 0) {
                ol.setPrice(fromPhase.getPriceActual());
            }
            ol.setTax();
            if (!ol.save()) {
                this.log.log(Level.SEVERE, "doIt - Lines not generated");
            }
            return "@C_Order_ID@ " + order.getDocumentNo() + " (1)";
        }
        int count = 0;
        MProjectLine[] lines = fromPhase.getLines();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MOrderLine ol = new MOrderLine(order);
            ol.setLine(lines[i2].getLine());
            ol.setDescription(lines[i2].getDescription());
            ol.setM_Product_ID(lines[i2].getM_Product_ID(), true);
            ol.setQty(lines[i2].getPlannedQty().subtract(lines[i2].getInvoicedQty()));
            ol.setPrice();
            if (lines[i2].getPlannedPrice() != null && lines[i2].getPlannedPrice().compareTo(Env.ZERO) != 0) {
                ol.setPrice(lines[i2].getPlannedPrice());
            }
            ol.setDiscount();
            ol.setTax();
            if (!ol.save()) continue;
            ++count;
        }
        if (lines.length != count) {
            this.log.log(Level.SEVERE, "Lines difference - ProjectLines=" + lines.length + " <> Saved=" + count);
        }
        MProjectTask[] tasks = fromPhase.getTasks();
        for (int i3 = 0; i3 < tasks.length; ++i3) {
            MOrderLine ol = new MOrderLine(order);
            ol.setLine(tasks[i3].getSeqNo());
            StringBuffer sb = new StringBuffer(tasks[i3].getName());
            if (tasks[i3].getDescription() != null && tasks[i3].getDescription().length() > 0) {
                sb.append(" - ").append(tasks[i3].getDescription());
            }
            ol.setDescription(sb.toString());
            ol.setM_Product_ID(tasks[i3].getM_Product_ID(), true);
            ol.setQty(tasks[i3].getQty());
            ol.setPrice();
            ol.setTax();
            if (!ol.save()) continue;
            ++count;
        }
        if (tasks.length != count - lines.length) {
            this.log.log(Level.SEVERE, "doIt - Lines difference - ProjectTasks=" + tasks.length + " <> Saved=" + count);
        }
        return "@C_Order_ID@ " + order.getDocumentNo() + " (" + count + ")";
    }
}

