/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProductPO;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class ProjectGenPO
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private int m_C_ProjectLine_ID = 0;
    private boolean m_ConsolidateDocument = true;
    private ArrayList<MOrder> m_pos = new ArrayList();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_Project_ID")) {
                this.m_C_Project_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_ProjectLine_ID")) {
                this.m_C_ProjectLine_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("ConsolidateDocument")) {
                this.m_ConsolidateDocument = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - C_Project_ID=" + this.m_C_Project_ID + " - C_ProjectLine_ID=" + this.m_C_ProjectLine_ID + " - Consolidate=" + this.m_ConsolidateDocument);
        if (this.m_C_ProjectLine_ID != 0) {
            MProjectLine projectLine = new MProjectLine(this.getCtx(), this.m_C_ProjectLine_ID, this.get_TrxName());
            MProject project = new MProject(this.getCtx(), projectLine.getC_Project_ID(), this.get_TrxName());
            this.createPO(project, projectLine);
        } else {
            MProject project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
            MProjectLine[] lines = project.getLines();
            for (int i2 = 0; i2 < lines.length; ++i2) {
                this.createPO(project, lines[i2]);
            }
        }
        return "";
    }

    private void createPO(MProject project, MProjectLine projectLine) {
        if (projectLine.getM_Product_ID() == 0) {
            this.addLog(projectLine.getLine(), null, null, "Line has no Product");
            return;
        }
        if (projectLine.getC_OrderPO_ID() != 0) {
            this.addLog(projectLine.getLine(), null, null, "Line was ordered previously");
            return;
        }
        MProductPO[] pos = MProductPO.getOfProduct(this.getCtx(), projectLine.getM_Product_ID(), this.get_TrxName());
        if (pos == null || pos.length == 0) {
            this.addLog(projectLine.getLine(), null, null, "Product has no PO record");
            return;
        }
        MOrder order = null;
        for (int i2 = 0; i2 < this.m_pos.size(); ++i2) {
            MOrder test = this.m_pos.get(i2);
            if (test.getC_BPartner_ID() != pos[0].getC_BPartner_ID()) continue;
            order = test;
            break;
        }
        if (order == null) {
            MBPartner bp = new MBPartner(this.getCtx(), pos[0].getC_BPartner_ID(), this.get_TrxName());
            order = new MOrder(project, false, null);
            int AD_Org_ID = projectLine.getAD_Org_ID();
            if (AD_Org_ID == 0) {
                this.log.warning("createPOfromProjectLine - AD_Org_ID=0");
                AD_Org_ID = Env.getAD_Org_ID(this.getCtx());
                if (AD_Org_ID != 0) {
                    projectLine.setAD_Org_ID(AD_Org_ID);
                }
            }
            order.setClientOrg(projectLine.getAD_Client_ID(), AD_Org_ID);
            order.setBPartner(bp);
            order.save();
            if (this.m_ConsolidateDocument) {
                this.m_pos.add(order);
            }
        }
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setM_Product_ID(projectLine.getM_Product_ID(), true);
        orderLine.setQty(projectLine.getPlannedQty());
        orderLine.setDescription(projectLine.getDescription());
        orderLine.setPrice();
        if (orderLine.getPriceActual().signum() == 0) {
            BigDecimal poPrice = pos[0].getPricePO();
            int C_Currency_ID = pos[0].getC_Currency_ID();
            if (poPrice == null || poPrice.signum() == 0) {
                poPrice = pos[0].getPriceLastPO();
            }
            if (poPrice == null || poPrice.signum() == 0) {
                poPrice = pos[0].getPriceList();
            }
            if (poPrice != null && poPrice.signum() != 0) {
                if (order.getC_Currency_ID() != C_Currency_ID) {
                    poPrice = MConversionRate.convert(this.getCtx(), poPrice, C_Currency_ID, order.getC_Currency_ID(), order.getDateAcct(), order.getC_ConversionType_ID(), order.getAD_Client_ID(), order.getAD_Org_ID());
                }
                orderLine.setPrice(poPrice);
            }
        }
        orderLine.setTax();
        orderLine.saveEx();
        projectLine.setC_OrderPO_ID(order.getC_Order_ID());
        projectLine.saveEx();
        this.addLog(projectLine.getLine(), null, projectLine.getPlannedQty(), order.getDocumentNo());
    }
}

