/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;

public class ProductionProcess
extends SvrProcess {
    private int p_M_Production_ID = 0;
    private Timestamp p_MovementDate = null;
    private MProduction m_production = null;
    private boolean mustBeStocked = false;
    private boolean recreate = false;
    private boolean issued = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("MovementDate")) {
                this.p_MovementDate = (Timestamp)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_M_Production_ID = this.getRecord_ID();
        this.m_production = new MProduction(this.getCtx(), this.p_M_Production_ID, this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_production.get_ID() == 0) {
            throw new AdempiereUserError("Could not load production header");
        }
        if (this.m_production.getIsCreated().equals("N")) {
            return "Not created";
        }
        if (this.m_production.isProcessed()) {
            return "Already processed";
        }
        return this.processLines();
    }

    protected String processLines() throws Exception {
        int processed = 0;
        this.m_production.setMovementDate(this.p_MovementDate);
        MProductionLine[] lines = this.m_production.getLines();
        StringBuffer errors = new StringBuffer();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            errors.append(lines[i2].createTransactions(this.m_production.getMovementDate(), this.mustBeStocked));
            lines[i2].setProcessed(true);
            lines[i2].save(this.get_TrxName());
            ++processed;
        }
        if (errors.toString().compareTo("") != 0) {
            this.log.log(Level.WARNING, errors.toString());
            throw new AdempiereSystemError(errors.toString());
        }
        this.m_production.setProcessed(true);
        this.m_production.save(this.get_TrxName());
        return processed + " production lines were processed";
    }
}

