/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MCostType;
import org.compiere.model.MProduction;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;

public class ProductionCreate
extends SvrProcess {
    private int p_M_Production_ID = 0;
    private MProduction m_production = null;
    private boolean mustBeStocked = false;
    private boolean recreate = false;
    private BigDecimal newQty = null;
    private int p_M_CostType_ID = 0;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) {
                // empty if block
            }
            if ("Recreate".equals(name)) {
                this.recreate = "Y".equals(para.getParameter());
                continue;
            }
            if ("ProductionQty".equals(name)) {
                this.newQty = (BigDecimal)para.getParameter();
                continue;
            }
            if ("M_CostType_ID".equals(name)) {
                this.p_M_CostType_ID = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_M_Production_ID = this.getRecord_ID();
        this.m_production = new MProduction(this.getCtx(), this.p_M_Production_ID, this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_production.get_ID() == 0) {
            throw new AdempiereUserError("Could not load production header");
        }
        if (this.m_production.isProcessed()) {
            return "Already processed";
        }
        return this.createLines();
    }

    private boolean costsOK(int M_Product_ID) throws AdempiereUserError {
        MCostType ct = new MCostType(this.getCtx(), this.p_M_CostType_ID, this.get_TrxName());
        if (!ct.getCostingMethod().equals("S")) {
            return true;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_Product_ID);
        params.add(this.p_M_CostType_ID);
        String sql = "SELECT ABS(((cc.currentcostprice-(SELECT SUM(c.currentcostprice*bom.qtybom) FROM m_cost c INNER JOIN pp_product_bomline bom ON (c.m_product_id=bom.m_product_id) JOIN pp_product_bom b ON (b.pp_product_bom_id = bom.pp_product_bom_id) WHERE b.m_product_id = pp.m_product_id) )/cc.currentcostprice)) FROM m_product pp INNER JOIN m_cost cc on (cc.m_product_id=pp.m_product_id) WHERE cc.currentcostprice > 0 AND pp.M_Product_ID = ? AND cc.m_costtype_ID=?";
        BigDecimal costPercentageDiff = DB.getSQLValueBD(this.get_TrxName(), sql, params);
        if (costPercentageDiff == null) {
            throw new AdempiereUserError("Could not retrieve costs");
        }
        return costPercentageDiff.compareTo(new BigDecimal("0.005")) < 0;
    }

    protected String createLines() throws Exception {
        int created = 0;
        this.isBom(this.m_production.getM_Product_ID());
        MCostType ct = new MCostType(this.getCtx(), this.p_M_CostType_ID, this.get_TrxName());
        if (!this.costsOK(this.m_production.getM_Product_ID()) && ct.getCostingMethod().equals("S")) {
            throw new AdempiereUserError("Excessive difference in standard costs");
        }
        if (!this.recreate && "true".equalsIgnoreCase(this.m_production.get_ValueAsString("IsCreated"))) {
            throw new AdempiereUserError("Production already created.");
        }
        if (this.newQty != null) {
            this.m_production.setProductionQty(this.newQty);
        }
        this.m_production.deleteLines(this.get_TrxName());
        created = this.m_production.createLines(this.mustBeStocked);
        if (created == 0) {
            return "Failed to create production lines";
        }
        this.m_production.setIsCreated("Y");
        this.m_production.save(this.get_TrxName());
        return created + " production lines were created";
    }

    protected void isBom(int M_Product_ID) throws Exception {
        String bom = DB.getSQLValueString(this.get_TrxName(), "SELECT isbom FROM M_Product WHERE M_Product_ID = ?", M_Product_ID);
        if ("N".compareTo(bom) == 0) {
            throw new AdempiereUserError("Attempt to create product line for Non Bill Of Materials");
        }
        int materials = DB.getSQLValue(this.get_TrxName(), "SELECT count(bl.PP_Product_BOMLine_ID) FROM PP_Product_BOMLine bl JOIN PP_Product_BOM b ON b.PP_Product_BOM_ID = bl.PP_Product_BOM_ID WHERE b.M_Product_ID = ?", M_Product_ID);
        if (materials == 0) {
            throw new AdempiereUserError("Attempt to create product line for Bill Of Materials with no BOM Products");
        }
    }
}

