/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class ProcessInfo
implements Serializable {
    static final long serialVersionUID = -1993220053515488725L;
    private String m_Title;
    private int m_AD_Process_ID;
    private int m_Table_ID;
    private int m_Record_ID;
    private Integer m_AD_User_ID;
    private Integer m_AD_Client_ID;
    private String m_ClassName = null;
    private int m_AD_PInstance_ID = 0;
    private String m_Summary = "";
    private boolean m_Error = false;
    private Serializable m_SerializableObject = null;
    private transient Object m_TransientObject = null;
    private int m_EstSeconds = 5;
    private boolean m_batch = false;
    private boolean m_timeout = false;
    private ArrayList<ProcessInfoLog> m_logs = null;
    private ArrayList<ProcessInfoParameter> m_parameter = null;
    private String m_transactionName = null;
    private boolean m_printPreview = false;
    private boolean m_reportingProcess = false;
    private File m_pdf_report = null;
    private Throwable m_throwable = null;
    private Integer m_AD_Org_ID = -1;
    private int m_windowNo = 0;
    private String m_whereClause = "";

    public ProcessInfo(String Title, int AD_Process_ID, int Table_ID, int Record_ID) {
        this.setTitle(Title);
        this.setAD_Process_ID(AD_Process_ID);
        this.setTable_ID(Table_ID);
        this.setRecord_ID(Record_ID);
        this.m_printPreview = Ini.isPropertyBool("PrintPreview");
    }

    public ProcessInfo(String Title, int AD_Process_ID) {
        this(Title, AD_Process_ID, 0, 0);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ProcessInfo[");
        sb.append(this.m_Title).append(",Process_ID=").append(this.m_AD_Process_ID);
        if (this.m_AD_PInstance_ID != 0) {
            sb.append(",AD_PInstance_ID=").append(this.m_AD_PInstance_ID);
        }
        if (this.m_Record_ID != 0) {
            sb.append(",Record_ID=").append(this.m_Record_ID);
        }
        if (this.m_ClassName != null) {
            sb.append(",ClassName=").append(this.m_ClassName);
        }
        sb.append(",Error=").append(this.isError());
        if (this.m_TransientObject != null) {
            sb.append(",Transient=").append(this.m_TransientObject);
        }
        if (this.m_SerializableObject != null) {
            sb.append(",Serializable=").append(this.m_SerializableObject);
        }
        sb.append(",Summary=").append(this.getSummary()).append(",Log=").append(this.m_logs == null ? 0 : this.m_logs.size());
        sb.append("]");
        return sb.toString();
    }

    public void setSummary(String summary) {
        this.m_Summary = summary;
    }

    public String getSummary() {
        return Util.cleanAmp(this.m_Summary);
    }

    public void setSummary(String translatedSummary, boolean error) {
        this.setSummary(translatedSummary);
        this.setError(error);
    }

    public void addSummary(String additionalSummary) {
        this.m_Summary = this.m_Summary + additionalSummary;
    }

    public void setError(boolean error) {
        this.m_Error = error;
    }

    public boolean isError() {
        return this.m_Error;
    }

    public void setIsBatch(boolean batch) {
        this.m_batch = batch;
    }

    public boolean isBatch() {
        return this.m_batch;
    }

    public void setIsTimeout(boolean timeout) {
        this.m_timeout = timeout;
    }

    public boolean isTimeout() {
        return this.m_timeout;
    }

    public String getLogInfo(boolean html) {
        if (this.m_logs == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat dateFormat = DisplayType.getDateFormat(16);
        if (html) {
            sb.append("<table width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"2\">");
        }
        for (int i2 = 0; i2 < this.m_logs.size(); ++i2) {
            if (html) {
                sb.append("<tr>");
            } else if (i2 > 0) {
                sb.append("\n");
            }
            ProcessInfoLog log = this.m_logs.get(i2);
            if (log.getP_Date() != null) {
                sb.append(html ? "<td>" : "").append(dateFormat.format(log.getP_Date())).append(html ? "</td>" : " \t");
            }
            if (log.getP_Number() != null) {
                sb.append(html ? "<td>" : "").append(log.getP_Number()).append(html ? "</td>" : " \t");
            }
            if (log.getP_Msg() != null) {
                sb.append(html ? "<td>" : "").append(Msg.parseTranslation(Env.getCtx(), log.getP_Msg())).append(html ? "</td>" : "");
            }
            if (!html) continue;
            sb.append("</tr>");
        }
        if (html) {
            sb.append("</table>");
        }
        return sb.toString();
    }

    public String getLogInfo() {
        return this.getLogInfo(false);
    }

    public int getAD_PInstance_ID() {
        return this.m_AD_PInstance_ID;
    }

    public void setAD_PInstance_ID(int AD_PInstance_ID) {
        this.m_AD_PInstance_ID = AD_PInstance_ID;
    }

    public int getAD_Process_ID() {
        return this.m_AD_Process_ID;
    }

    public void setAD_Process_ID(int AD_Process_ID) {
        this.m_AD_Process_ID = AD_Process_ID;
    }

    public String getClassName() {
        return this.m_ClassName;
    }

    public void setClassName(String ClassName) {
        this.m_ClassName = ClassName;
        if (this.m_ClassName != null && this.m_ClassName.length() == 0) {
            this.m_ClassName = null;
        }
    }

    public Object getTransientObject() {
        return this.m_TransientObject;
    }

    public void setTransientObject(Object TransientObject) {
        this.m_TransientObject = TransientObject;
    }

    public Serializable getSerializableObject() {
        return this.m_SerializableObject;
    }

    public void setSerializableObject(Serializable SerializableObject) {
        this.m_SerializableObject = SerializableObject;
    }

    public int getEstSeconds() {
        return this.m_EstSeconds;
    }

    public void setEstSeconds(int EstSeconds) {
        this.m_EstSeconds = EstSeconds;
    }

    public int getTable_ID() {
        return this.m_Table_ID;
    }

    public void setTable_ID(int AD_Table_ID) {
        this.m_Table_ID = AD_Table_ID;
    }

    public int getRecord_ID() {
        return this.m_Record_ID;
    }

    public void setRecord_ID(int Record_ID) {
        this.m_Record_ID = Record_ID;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public void setTitle(String Title) {
        this.m_Title = Title;
    }

    public void setAD_Client_ID(int AD_Client_ID) {
        this.m_AD_Client_ID = new Integer(AD_Client_ID);
    }

    public Integer getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public void setAD_User_ID(int AD_User_ID) {
        this.m_AD_User_ID = new Integer(AD_User_ID);
    }

    public Integer getAD_User_ID() {
        return this.m_AD_User_ID;
    }

    public ProcessInfoParameter[] getParameter() {
        if (this.m_parameter == null) {
            return null;
        }
        ProcessInfoParameter[] ret = new ProcessInfoParameter[this.m_parameter.size()];
        this.m_parameter.toArray(ret);
        return ret;
    }

    public void setParameter(ProcessInfoParameter[] parameter) {
        this.m_parameter = new ArrayList<ProcessInfoParameter>(Arrays.asList(parameter));
    }

    public void addLog(int Log_ID, int P_ID, Timestamp P_Date, BigDecimal P_Number, String P_Msg) {
        this.addLog(new ProcessInfoLog(Log_ID, P_ID, P_Date, P_Number, P_Msg));
    }

    public void addLog(int P_ID, Timestamp P_Date, BigDecimal P_Number, String P_Msg) {
        this.addLog(new ProcessInfoLog(P_ID, P_Date, P_Number, P_Msg));
    }

    public void addLog(ProcessInfoLog logEntry) {
        if (logEntry == null) {
            return;
        }
        if (this.m_logs == null) {
            this.m_logs = new ArrayList();
        }
        this.m_logs.add(logEntry);
    }

    public ProcessInfoLog[] getLogs() {
        if (this.m_logs == null) {
            return null;
        }
        ProcessInfoLog[] logs = new ProcessInfoLog[this.m_logs.size()];
        this.m_logs.toArray(logs);
        return logs;
    }

    public int[] getIDs() {
        if (this.m_logs == null) {
            return null;
        }
        int[] ids = new int[this.m_logs.size()];
        for (int i2 = 0; i2 < this.m_logs.size(); ++i2) {
            ids[i2] = this.m_logs.get(i2).getP_ID();
        }
        return ids;
    }

    public ArrayList<ProcessInfoLog> getLogList() {
        return this.m_logs;
    }

    public void setLogList(ArrayList<ProcessInfoLog> logs) {
        this.m_logs = logs;
    }

    public String getTransactionName() {
        return this.m_transactionName;
    }

    public void setTransactionName(String trxName) {
        this.m_transactionName = trxName;
    }

    public void setPrintPreview(boolean b2) {
        this.m_printPreview = b2;
    }

    public boolean isPrintPreview() {
        return this.m_printPreview;
    }

    public boolean isReportingProcess() {
        return this.m_reportingProcess;
    }

    public void setReportingProcess(boolean f) {
        this.m_reportingProcess = f;
    }

    public void setPDFReport(File f) {
        this.m_pdf_report = f;
    }

    public File getPDFReport() {
        return this.m_pdf_report;
    }

    public void addParameter(String name, Object value, String info) {
        if (value == null) {
            return;
        }
        if (value instanceof String && Util.isEmpty((String)value)) {
            return;
        }
        if (this.m_parameter == null) {
            this.m_parameter = new ArrayList();
        }
        ProcessInfoParameter para = new ProcessInfoParameter(name, value, null, info, null);
        this.m_parameter.add(para);
    }

    public Integer getAD_Org_ID() {
        if (this.m_AD_Org_ID == -1) {
            return Env.getAD_Org_ID(Env.getCtx());
        }
        return this.m_AD_Org_ID;
    }

    public void setAD_Org_ID(int AD_Org_ID) {
        this.m_AD_Org_ID = new Integer(AD_Org_ID);
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    public void setThrowable(Throwable t) {
        this.m_throwable = t;
    }

    public int getWindowNo() {
        return this.m_windowNo;
    }

    public void setWindowNo(int m_windowNo) {
        this.m_windowNo = m_windowNo;
    }

    public String getWhereClause() {
        return this.m_whereClause;
    }

    public void setWhereClause(String m_whereClause) {
        this.m_whereClause = m_whereClause;
    }
}

