/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PaySelectionCreateFrom
extends SvrProcess {
    private boolean p_OnlyDiscount = false;
    private boolean p_OnlyDue = false;
    private boolean p_IncludeInDispute = false;
    private String p_MatchRequirement = "N";
    private String p_PaymentRule = null;
    private int p_C_BPartner_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_PaySelection_ID = 0;
    private Timestamp p_DueDate = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("OnlyDiscount")) {
                this.p_OnlyDiscount = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("OnlyDue")) {
                this.p_OnlyDue = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("IncludeInDispute")) {
                this.p_IncludeInDispute = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("MatchRequirement")) {
                this.p_MatchRequirement = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("PaymentRule")) {
                this.p_PaymentRule = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DueDate")) {
                this.p_DueDate = (Timestamp)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_PaySelection_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_PaySelection_ID=" + this.p_C_PaySelection_ID + ", OnlyDiscount=" + this.p_OnlyDiscount + ", OnlyDue=" + this.p_OnlyDue + ", IncludeInDispute=" + this.p_IncludeInDispute + ", MatchRequirement=" + this.p_MatchRequirement + ", PaymentRule=" + this.p_PaymentRule + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID);
        MPaySelection psel = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
        if (psel.get_ID() == 0) {
            throw new IllegalArgumentException("Not found C_PaySelection_ID=" + this.p_C_PaySelection_ID);
        }
        if (psel.isProcessed()) {
            throw new IllegalArgumentException("@Processed@");
        }
        if (this.p_DueDate == null) {
            this.p_DueDate = psel.getPayDate();
        }
        String sql = "SELECT i.C_Invoice_ID, i.C_InvoicePaySchedule_ID, currencyConvert(invoiceOpen(i.C_Invoice_ID, i.C_InvoicePaySchedule_ID),i.C_Currency_ID, ?,?, i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), currencyConvert(paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?),i.C_Currency_ID, ?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), PaymentRule, IsSOTrx FROM C_Invoice_v i LEFT OUTER JOIN C_InvoicePaySchedule ips ON (i.C_InvoicePaySchedule_ID = ips.C_InvoicePaySchedule_ID) WHERE IsSOTrx='N' AND IsPaid='N' AND DocStatus IN ('CO','CL') AND i.AD_Client_ID=? AND invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID)-paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?) != 0.0 AND NOT EXISTS (SELECT * FROM C_PaySelectionLine psl INNER JOIN C_PaySelectionCheck psc ON (psl.C_PaySelectionCheck_ID=psc.C_PaySelectionCheck_ID) LEFT OUTER JOIN C_Payment pmt ON (pmt.C_Payment_ID=psc.C_Payment_ID) WHERE i.C_Invoice_ID=psl.C_Invoice_ID AND i.C_InvoicePaySchedule_ID is null AND psl.IsActive='Y' AND (pmt.DocStatus IS NULL OR pmt.DocStatus NOT IN ('VO','RE')) AND psl.differenceamt = 0.0)  AND NOT EXISTS (SELECT * FROM C_PaySelectionLine psl WHERE i.C_Invoice_ID=psl.C_Invoice_ID AND psl.IsActive='Y' AND psl.C_PaySelection_ID = ?)";
        if (!this.p_IncludeInDispute) {
            sql = sql + " AND i.IsInDispute='N'";
        }
        if (this.p_PaymentRule != null) {
            sql = sql + " AND PaymentRule=?";
        }
        if (this.p_OnlyDiscount) {
            sql = this.p_OnlyDue ? sql + " AND (" : sql + " AND ";
            sql = sql + "paymentTermDiscount(invoiceOpen(i.C_Invoice_ID, i.C_InvoicePaySchedule_ID), C_Currency_ID, C_PaymentTerm_ID, DateInvoiced, ?) > 0";
        }
        if (this.p_OnlyDue) {
            sql = this.p_OnlyDiscount ? sql + " OR " : sql + " AND ";
            sql = sql + "COALESCE(ips.duedate,paymentTermDueDate(i.C_PaymentTerm_ID, i.DateInvoiced)) <= ?";
            if (this.p_OnlyDiscount) {
                sql = sql + ")";
            }
        }
        if (this.p_C_BPartner_ID != 0) {
            sql = sql + " AND C_BPartner_ID=?";
        } else if (this.p_C_BP_Group_ID != 0) {
            sql = sql + " AND EXISTS (SELECT * FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.C_BPartner_ID AND bp.C_BP_Group_ID=?)";
        }
        if (this.p_MatchRequirement.equals("P") || this.p_MatchRequirement.equals("B")) {
            sql = sql + " AND EXISTS (SELECT * FROM C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND QtyInvoiced=(SELECT SUM(Qty) FROM M_MatchPO m WHERE il.C_InvoiceLine_ID=m.C_InvoiceLine_ID))";
        }
        if (this.p_MatchRequirement.equals("R") || this.p_MatchRequirement.equals("B")) {
            sql = sql + " AND EXISTS (SELECT * FROM C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND QtyInvoiced=(SELECT SUM(Qty) FROM M_MatchInv m WHERE il.C_InvoiceLine_ID=m.C_InvoiceLine_ID))";
        }
        int lines = 0;
        int C_CurrencyTo_ID = psel.getC_Currency_ID();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            int index = 1;
            pstmt.setInt(index++, C_CurrencyTo_ID);
            pstmt.setTimestamp(index++, psel.getPayDate());
            pstmt.setTimestamp(index++, psel.getPayDate());
            pstmt.setInt(index++, C_CurrencyTo_ID);
            pstmt.setTimestamp(index++, psel.getPayDate());
            pstmt.setInt(index++, psel.getAD_Client_ID());
            pstmt.setTimestamp(index++, psel.getPayDate());
            pstmt.setInt(index++, psel.getC_PaySelection_ID());
            if (this.p_PaymentRule != null) {
                pstmt.setString(index++, this.p_PaymentRule);
            }
            if (this.p_OnlyDiscount) {
                pstmt.setTimestamp(index++, psel.getPayDate());
            }
            if (this.p_OnlyDue) {
                pstmt.setTimestamp(index++, this.p_DueDate);
            }
            if (this.p_C_BPartner_ID != 0) {
                pstmt.setInt(index++, this.p_C_BPartner_ID);
            } else if (this.p_C_BP_Group_ID != 0) {
                pstmt.setInt(index++, this.p_C_BP_Group_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_Invoice_ID = rs.getInt(1);
                int C_InvoicePaySchedule_ID = rs.getInt(2);
                BigDecimal PayAmt = rs.getBigDecimal(3);
                if (C_Invoice_ID == 0 || Env.ZERO.compareTo(PayAmt) == 0) continue;
                BigDecimal DiscountAmt = rs.getBigDecimal(4);
                String PaymentRule = rs.getString(5);
                boolean isSOTrx = "Y".equals(rs.getString(6));
                MPaySelectionLine pselLine = new MPaySelectionLine(psel, ++lines * 10, PaymentRule);
                pselLine.setInvoice(C_Invoice_ID, C_InvoicePaySchedule_ID, isSOTrx, PayAmt, PayAmt.subtract(DiscountAmt), DiscountAmt);
                if (pselLine.save()) continue;
                pstmt.close();
                throw new IllegalStateException("Cannot save MPaySelectionLine");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "@C_PaySelectionLine_ID@  - #" + lines;
    }
}

