/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class OrderLineCreateShipment
extends SvrProcess {
    private int p_C_OrderLine_ID = 0;
    private Timestamp p_MovementDate = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) {
                // empty if block
            }
            if (name.equals("MovementDate")) {
                this.p_MovementDate = (Timestamp)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_MovementDate == null) {
            this.p_MovementDate = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_MovementDate == null) {
            this.p_MovementDate = new Timestamp(System.currentTimeMillis());
        }
        this.p_C_OrderLine_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_OrderLine_ID=" + this.p_C_OrderLine_ID);
        if (this.p_C_OrderLine_ID == 0) {
            throw new IllegalArgumentException("No OrderLine");
        }
        MOrderLine line = new MOrderLine(this.getCtx(), this.p_C_OrderLine_ID, this.get_TrxName());
        if (line.get_ID() == 0) {
            throw new IllegalArgumentException("Order line not found");
        }
        MOrder order = new MOrder(this.getCtx(), line.getC_Order_ID(), this.get_TrxName());
        if (!"CO".equals(order.getDocStatus())) {
            throw new IllegalArgumentException("Order not completed");
        }
        if (line.getQtyOrdered().subtract(line.getQtyDelivered()).compareTo(Env.ZERO) <= 0) {
            return "Ordered quantity already shipped";
        }
        int C_DocTypeShipment_ID = DB.getSQLValue(this.get_TrxName(), "SELECT C_DocTypeShipment_ID FROM C_DocType WHERE C_DocType_ID=?", order.getC_DocType_ID());
        MInOut shipment = new MInOut(order, C_DocTypeShipment_ID, this.p_MovementDate);
        shipment.setM_Warehouse_ID(line.getM_Warehouse_ID());
        shipment.setMovementDate(line.getDatePromised());
        if (!shipment.save()) {
            throw new IllegalArgumentException("Cannot save shipment header");
        }
        MInOutLine sline = new MInOutLine(shipment);
        sline.setOrderLine(line, 0, line.getQtyReserved());
        sline.setQtyEntered(line.getQtyReserved());
        sline.setC_UOM_ID(line.getC_UOM_ID());
        sline.setQty(line.getQtyReserved());
        sline.setM_Warehouse_ID(line.getM_Warehouse_ID());
        if (!sline.save()) {
            throw new IllegalArgumentException("Cannot save Shipment Line");
        }
        return shipment.getDocumentNo();
    }
}

