/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MWarehouse;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class OrderLineCreateProduction
extends SvrProcess {
    private int p_C_OrderLine_ID = 0;
    private Timestamp p_MovementDate = null;
    private boolean ignorePrevProduction = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) {
                // empty if block
            }
            if (name.equals("MovementDate")) {
                this.p_MovementDate = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("IgnorePrevProduction")) {
                this.ignorePrevProduction = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_MovementDate == null) {
            this.p_MovementDate = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_MovementDate == null) {
            this.p_MovementDate = new Timestamp(System.currentTimeMillis());
        }
        this.p_C_OrderLine_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        String docNo;
        this.log.info("C_OrderLine_ID=" + this.p_C_OrderLine_ID);
        if (this.p_C_OrderLine_ID == 0) {
            throw new IllegalArgumentException("No OrderLine");
        }
        MOrderLine line = new MOrderLine(this.getCtx(), this.p_C_OrderLine_ID, this.get_TrxName());
        if (line.get_ID() == 0) {
            throw new IllegalArgumentException("Order line not found");
        }
        MOrder order = new MOrder(this.getCtx(), line.getC_Order_ID(), this.get_TrxName());
        if (!"CO".equals(order.getDocStatus())) {
            throw new IllegalArgumentException("Order not completed");
        }
        MDocType doc = new MDocType(this.getCtx(), order.getC_DocType_ID(), this.get_TrxName());
        if (line.getQtyOrdered().subtract(line.getQtyDelivered()).compareTo(Env.ZERO) <= 0 && !doc.getDocSubTypeSO().equals("ON")) {
            return "Ordered quantity already shipped";
        }
        if (!this.ignorePrevProduction && (docNo = DB.getSQLValueString(this.get_TrxName(), "SELECT max(DocumentNo) FROM M_Production WHERE C_OrderLine_ID = ?", this.p_C_OrderLine_ID)) != null) {
            throw new IllegalArgumentException("Production has already been created: " + docNo);
        }
        MProduction production = new MProduction(line);
        MProduct product = new MProduct(this.getCtx(), line.getM_Product_ID(), this.get_TrxName());
        production.setM_Product_ID(line.getM_Product_ID());
        production.setProductionQty(line.getQtyOrdered().subtract(line.getQtyDelivered()));
        production.setDatePromised(line.getDatePromised());
        if (product.getM_Locator_ID() > 0) {
            production.setM_Locator_ID(product.getM_Locator_ID());
        }
        production.setC_OrderLine_ID(this.p_C_OrderLine_ID);
        int locator = product.getM_Locator_ID();
        if (locator == 0) {
            locator = MWarehouse.get(this.getCtx(), line.getM_Warehouse_ID()).getDefaultLocator().get_ID();
        }
        production.setM_Locator_ID(locator);
        production.saveEx();
        production.createLines(false);
        production.setIsCreated("Y");
        production.saveEx();
        return "Production created -- " + production.get_ValueAsString("DocumentNo");
    }
}

