/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.FileWriter;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MMigration;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MigrationToXML
extends SvrProcess {
    private int migrationId = 0;
    private String fileName;

    @Override
    protected String doIt() throws Exception {
        MMigration migration = new MMigration(this.getCtx(), this.migrationId, this.get_TrxName());
        if (migration == null || migration.is_new()) {
            return "No migration to export";
        }
        this.log.log(Level.FINE, "Creating xml document for migration: " + migration);
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.newDocument();
        Element root = document.createElement("Migrations");
        document.appendChild(root);
        root.appendChild(migration.toXmlNode(document));
        TransformerFactory transfac = TransformerFactory.newInstance();
        transfac.setAttribute("indent-number", 2);
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "no");
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("standalone", "yes");
        this.log.log(Level.FINE, "Writing xml to file.");
        FileWriter fw = new FileWriter(this.fileName);
        StreamResult result = new StreamResult(fw);
        DOMSource source = new DOMSource(document);
        trans.transform(source, result);
        fw.close();
        return "Exported migration to: " + this.fileName;
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] paras;
        for (ProcessInfoParameter para : paras = this.getParameter()) {
            if (para.getParameterName().equals("AD_Migration_ID")) {
                this.migrationId = para.getParameterAsInt();
                continue;
            }
            if (!para.getParameterName().equals("FileName")) continue;
            this.fileName = (String)para.getParameter();
        }
        if (this.migrationId == 0) {
            this.migrationId = this.getRecord_ID();
        }
        this.log.log(Level.FINE, "AD_Migration_ID = " + this.migrationId + ", filename = " + this.fileName);
    }
}

