/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import org.compiere.model.MMigration;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class MigrationApply
extends SvrProcess {
    private MMigration migration;
    private boolean failOnError = false;

    @Override
    protected String doIt() throws Exception {
        if (this.migration == null || this.migration.is_new()) {
            this.addLog(Msg.getMsg(this.getCtx(), "NoMigrationMessage"));
            return "@Error@" + Msg.getMsg(this.getCtx(), "NoMigration");
        }
        if (Ini.isPropertyBool("LogMigrationScript")) {
            this.addLog(Msg.getMsg(this.getCtx(), "LogMigrationScriptFlagIsSetMessage"));
            return "@Error@" + Msg.getMsg(this.getCtx(), "LogMigrationScripFlagtIsSet");
        }
        boolean apply = true;
        if ("R".equals(this.migration.getApply())) {
            apply = false;
        }
        this.migration.setFailOnError(this.failOnError);
        if (apply) {
            this.migration.apply();
            if (this.migration.getStatusCode().equals("A")) {
                this.addLog("Migration successful");
            } else if (this.migration.getStatusCode().equals("P")) {
                this.addLog("Migration partially applied. Please review migration steps for errors.");
            } else if (this.migration.getStatusCode().equals("F")) {
                this.addLog("Migration failed. Please review migration steps for errors.");
            }
        } else {
            this.migration.rollback();
            if (this.migration.getStatusCode().equals("U")) {
                this.addLog("Rollback successful.");
            } else {
                this.addLog("Rollback failed. Please review migration steps for errors.");
            }
        }
        this.migration.updateStatus(this.get_TrxName());
        return "@OK@";
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] params;
        this.migration = new MMigration(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        for (ProcessInfoParameter p2 : params = this.getParameter()) {
            String para = p2.getParameterName();
            if (!para.equals("FailOnError")) continue;
            this.failOnError = "Y".equals((String)p2.getParameter());
        }
    }
}

