/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ImportReportLine
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_PA_ReportLineSet_ID = 0;
    private boolean m_deleteOldImported = false;
    private Timestamp m_DateValue = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("PA_ReportLineSet_ID")) {
                this.m_PA_ReportLineSet_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_ReportLine WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_ReportLine SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Reset=" + no);
        if (this.m_PA_ReportLineSet_ID != 0) {
            sql = new StringBuffer("UPDATE I_ReportLine i SET ReportLineSetName=(SELECT Name FROM PA_ReportLineSet r WHERE PA_ReportLineSet_ID=").append(this.m_PA_ReportLineSet_ID).append(" AND i.AD_Client_ID=r.AD_Client_ID) WHERE ReportLineSetName IS NULL AND PA_ReportLineSet_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Set ReportLineSetName Default=" + no);
        }
        sql = new StringBuffer("UPDATE I_ReportLine i SET PA_ReportLineSet_ID=(SELECT PA_ReportLineSet_ID FROM PA_ReportLineSet r WHERE i.ReportLineSetName=r.Name AND i.AD_Client_ID=r.AD_Client_ID) WHERE PA_ReportLineSet_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set PA_ReportLineSet_ID=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid ReportLineSet, ' WHERE PA_ReportLineSet_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid ReportLineSet=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Ignored=NoLineName, ' WHERE PA_ReportLine_ID IS NULL AND Name IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid LineName=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine i SET C_ElementValue_ID=(SELECT C_ElementValue_ID FROM C_ElementValue e WHERE i.ElementValue=e.Value AND i.AD_Client_ID=e.AD_Client_ID) WHERE C_ElementValue_ID IS NULL AND ElementValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set C_ElementValue_ID=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid ElementValue, ' WHERE C_ElementValue_ID IS NULL AND LineType<>'C' AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid AccountType=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET SeqNo=I_ReportLine_ID WHERE SeqNo IS NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set SeqNo Default=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine i SET (Description, SeqNo, IsSummary, IsPrinted, LineType, CalculationType, AmountType, PAAmountType, PAPeriodType, PostingType)= (SELECT Description, SeqNo, IsSummary, IsPrinted, LineType, CalculationType, AmountType, PAAmountType, PAPeriodType, PostingType FROM I_ReportLine ii WHERE i.Name=ii.Name AND i.PA_ReportLineSet_ID=ii.PA_ReportLineSet_ID AND ii.I_ReportLine_ID=(SELECT MIN(I_ReportLine_ID) FROM I_ReportLine iii WHERE i.Name=iii.Name AND i.PA_ReportLineSet_ID=iii.PA_ReportLineSet_ID)) WHERE EXISTS (SELECT * FROM I_ReportLine ii WHERE i.Name=ii.Name AND i.PA_ReportLineSet_ID=ii.PA_ReportLineSet_ID AND ii.I_ReportLine_ID=(SELECT MIN(I_ReportLine_ID) FROM I_ReportLine iii WHERE i.Name=iii.Name AND i.PA_ReportLineSet_ID=iii.PA_ReportLineSet_ID)) AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Sync from first Row of Line=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET IsSummary='N' WHERE IsSummary IS NULL OR IsSummary NOT IN ('Y','N') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set IsSummary Default=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET IsPrinted='Y' WHERE IsPrinted IS NULL OR IsPrinted NOT IN ('Y','N') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set IsPrinted Default=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET LineType='S' WHERE LineType IS NULL OR LineType NOT IN ('S','C') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set LineType Default=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid CalculationType, ' WHERE CalculationType IS NOT NULL AND CalculationType NOT IN ('A','P','R','S') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid CalculationType=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET PAAmountType = substr(AmountType,1,1), PAPeriodType = substr(AmountType,1,2) WHERE AmountType IS NOT NULL AND (PAAmountType IS NULL OR PAPeriodType IS NULL)  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Converted AmountType=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid PAAmountType, ' WHERE PAAmountType IS NOT NULL AND UPPER(AmountType) NOT IN ('B','C','D','Q','S','R') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid AmountType=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid PAPeriodType, ' WHERE PAPeriodType IS NOT NULL AND UPPER(AmountType) NOT IN ('P','Y','T','N') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid PeriodType=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid CalculationType, ' WHERE PostingType IS NOT NULL AND PostingType NOT IN ('A','B','E','S','R') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid PostingType=" + no);
        sql = new StringBuffer("UPDATE I_ReportLine i SET PA_ReportLine_ID=(SELECT MAX(PA_ReportLine_ID) FROM PA_ReportLine r WHERE i.Name=r.Name AND i.PA_ReportLineSet_ID=r.PA_ReportLineSet_ID) WHERE PA_ReportLine_ID IS NULL AND PA_ReportLineSet_ID IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set PA_ReportLine_ID=" + no);
        this.commitEx();
        int noInsertLine = 0;
        int noUpdateLine = 0;
        sql = new StringBuffer("SELECT DISTINCT PA_ReportLineSet_ID, Name FROM I_ReportLine WHERE I_IsImported='N' AND PA_ReportLine_ID IS NULL AND I_IsImported='N'").append(clientCheck);
        try {
            CPreparedStatement pstmt_insertLine = DB.prepareStatement("INSERT INTO PA_ReportLine (PA_ReportLine_ID,PA_ReportLineSet_ID,AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,Name,SeqNo,IsPrinted,IsSummary,LineType)SELECT ?,PA_ReportLineSet_ID,AD_Client_ID,AD_Org_ID,'Y',SysDate,CreatedBy,SysDate,UpdatedBy,Name,SeqNo,IsPrinted,IsSummary,LineType FROM I_ReportLine WHERE I_ReportLine_ID=(SELECT MAX(I_ReportLine_ID) FROM I_ReportLine WHERE PA_ReportLineSet_ID=? AND Name=? " + clientCheck + ")", this.get_TrxName());
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int PA_ReportLineSet_ID = rs.getInt(1);
                String Name2 = rs.getString(2);
                try {
                    int PA_ReportLine_ID = DB.getNextID(this.m_AD_Client_ID, "PA_ReportLine", this.get_TrxName());
                    if (PA_ReportLine_ID <= 0) {
                        throw new DBException("No NextID (" + PA_ReportLine_ID + ")");
                    }
                    pstmt_insertLine.setInt(1, PA_ReportLine_ID);
                    pstmt_insertLine.setInt(2, PA_ReportLineSet_ID);
                    pstmt_insertLine.setString(3, Name2);
                    no = pstmt_insertLine.executeUpdate();
                    this.log.finest("Insert ReportLine = " + no + ", PA_ReportLine_ID=" + PA_ReportLine_ID);
                    ++noInsertLine;
                }
                catch (Exception ex) {
                    this.log.finest(ex.toString());
                }
            }
            rs.close();
            pstmt.close();
            pstmt_insertLine.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "Create ReportLine", e);
        }
        sql = new StringBuffer("UPDATE I_ReportLine i SET PA_ReportLine_ID=(SELECT MAX(PA_ReportLine_ID) FROM PA_ReportLine r WHERE i.Name=r.Name AND i.PA_ReportLineSet_ID=r.PA_ReportLineSet_ID) WHERE PA_ReportLine_ID IS NULL AND PA_ReportLineSet_ID IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set PA_ReportLine_ID=" + no);
        sql = new StringBuffer("UPDATE PA_ReportLine r SET (Description,SeqNo,IsSummary,IsPrinted,LineType,CalculationType,AmountType,PAAmountType,PAPeriodType,PostingType,Updated,UpdatedBy)= (SELECT Description,SeqNo,IsSummary,IsPrinted,LineType,CalculationType,AmountType,PAAmountType,PAPeriodType,PostingType,SysDate,UpdatedBy FROM I_ReportLine i WHERE r.Name=i.Name AND r.PA_ReportLineSet_ID=i.PA_ReportLineSet_ID AND i.I_ReportLine_ID=(SELECT MIN(I_ReportLine_ID) FROM I_ReportLine iii WHERE i.Name=iii.Name AND i.PA_ReportLineSet_ID=iii.PA_ReportLineSet_ID)) WHERE EXISTS (SELECT * FROM I_ReportLine i WHERE r.Name=i.Name AND r.PA_ReportLineSet_ID=i.PA_ReportLineSet_ID AND i.I_ReportLine_ID=(SELECT MIN(I_ReportLine_ID) FROM I_ReportLine iii WHERE i.Name=iii.Name AND i.PA_ReportLineSet_ID=iii.PA_ReportLineSet_ID AND i.I_IsImported='N'))").append(clientCheck);
        noUpdateLine = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Update PA_ReportLine=" + noUpdateLine);
        int noInsertSource = 0;
        int noUpdateSource = 0;
        sql = new StringBuffer("SELECT I_ReportLine_ID, PA_ReportSource_ID FROM I_ReportLine WHERE PA_ReportLine_ID IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        try {
            CPreparedStatement pstmt_insertSource = DB.prepareStatement("INSERT INTO PA_ReportSource (PA_ReportSource_ID,AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,PA_ReportLine_ID,ElementType,C_ElementValue_ID) SELECT ?,AD_Client_ID,AD_Org_ID,'Y',SysDate,CreatedBy,SysDate,UpdatedBy,PA_ReportLine_ID,'AC',C_ElementValue_ID FROM I_ReportLine WHERE I_ReportLine_ID=? AND I_IsImported='N'" + clientCheck, this.get_TrxName());
            CPreparedStatement pstmt_deleteSource = DB.prepareStatement("DELETE FROM PA_ReportSource WHERE C_ElementValue_ID IS NULL AND PA_ReportSource_ID=?" + clientCheck, this.get_TrxName());
            CPreparedStatement pstmt_setImported = DB.prepareStatement("UPDATE I_ReportLine SET I_IsImported='Y', PA_ReportSource_ID=?,  Updated=SysDate, Processed='Y' WHERE I_ReportLine_ID=?", this.get_TrxName());
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int PA_ReportSource_ID;
                int I_ReportLine_ID;
                block18: {
                    I_ReportLine_ID = rs.getInt(1);
                    PA_ReportSource_ID = rs.getInt(2);
                    if (PA_ReportSource_ID == 0) {
                        try {
                            PA_ReportSource_ID = DB.getNextID(this.m_AD_Client_ID, "PA_ReportSource", this.get_TrxName());
                            if (PA_ReportSource_ID <= 0) {
                                throw new DBException("No NextID (" + PA_ReportSource_ID + ")");
                            }
                            pstmt_insertSource.setInt(1, PA_ReportSource_ID);
                            pstmt_insertSource.setInt(2, I_ReportLine_ID);
                            no = pstmt_insertSource.executeUpdate();
                            this.log.finest("Insert ReportSource = " + no + ", I_ReportLine_ID=" + I_ReportLine_ID + ", PA_ReportSource_ID=" + PA_ReportSource_ID);
                            ++noInsertSource;
                            break block18;
                        }
                        catch (Exception ex) {
                            this.log.finest("Insert ReportSource - " + ex.toString());
                            sql = new StringBuffer("UPDATE I_ReportLine i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING("Insert ElementSource: " + ex.toString())).append("WHERE I_ReportLine_ID=").append(I_ReportLine_ID);
                            DB.executeUpdate(sql.toString(), this.get_TrxName());
                            continue;
                        }
                    }
                    String sqlt = "UPDATE PA_ReportSource SET (ElementType,C_ElementValue_ID,Updated,UpdatedBy)= (SELECT CAST('AC' AS CHAR(2)),C_ElementValue_ID,SysDate,UpdatedBy FROM I_ReportLine WHERE I_ReportLine_ID=" + I_ReportLine_ID + ") " + "WHERE PA_ReportSource_ID=" + PA_ReportSource_ID + " " + clientCheck;
                    CPreparedStatement pstmt_updateSource = DB.prepareStatement(sqlt, this.get_TrxName());
                    try {
                        no = pstmt_updateSource.executeUpdate();
                        this.log.finest("Update ReportSource = " + no + ", I_ReportLine_ID=" + I_ReportLine_ID + ", PA_ReportSource_ID=" + PA_ReportSource_ID);
                        ++noUpdateSource;
                    }
                    catch (SQLException ex) {
                        this.log.finest("Update ReportSource - " + ex.toString());
                        sql = new StringBuffer("UPDATE I_ReportLine i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING("Update ElementSource: " + ex.toString())).append("WHERE I_ReportLine_ID=").append(I_ReportLine_ID);
                        DB.executeUpdate(sql.toString(), this.get_TrxName());
                        continue;
                    }
                    pstmt_updateSource.close();
                }
                pstmt_setImported.setInt(1, PA_ReportSource_ID);
                pstmt_setImported.setInt(2, I_ReportLine_ID);
                no = pstmt_setImported.executeUpdate();
                if (no != 1) {
                    this.log.log(Level.SEVERE, "Set Imported=" + no);
                }
                pstmt_deleteSource.setInt(1, PA_ReportSource_ID);
                no = pstmt_deleteSource.executeUpdate();
                this.log.finest("Delete ReportSource with Null Account= " + no + ", I_ReportLine_ID=" + I_ReportLine_ID + ", PA_ReportSource_ID=" + PA_ReportSource_ID);
                this.commitEx();
            }
            rs.close();
            pstmt.close();
            pstmt_insertSource.close();
            pstmt_setImported.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        sql = new StringBuffer("UPDATE I_ReportLine SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@PA_ReportLine_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdateLine), "@PA_ReportLine_ID@: @Updated@");
        this.addLog(0, null, new BigDecimal(noInsertSource), "@PA_ReportSource_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdateSource), "@PA_ReportSource_ID@: @Updated@");
        return "";
    }
}

