/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.MChargeAcct;
import org.compiere.model.MElementValue;
import org.compiere.model.X_I_ElementValue;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ImportAccount
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_C_Element_ID = 0;
    private boolean m_updateDefaultAccounts = false;
    private boolean m_createNewCombination = true;
    private boolean m_deleteOldImported = false;
    private Timestamp m_DateValue = null;
    private static final int UPDATE_ERROR = 0;
    private static final int UPDATE_YES = 1;
    private static final int UPDATE_SAME = 2;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Element_ID")) {
                this.m_C_Element_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("UpdateDefaultAccounts")) {
                this.m_updateDefaultAccounts = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("CreateNewCombination")) {
                this.m_createNewCombination = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_ElementValue WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_ElementValue SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', Processed = 'N',  I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Reset=" + no);
        if (this.m_C_Element_ID != 0) {
            sql = new StringBuffer("UPDATE I_ElementValue SET ElementName=(SELECT Name FROM C_Element WHERE C_Element_ID=").append(this.m_C_Element_ID).append(") WHERE ElementName IS NULL AND C_Element_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Set Element Default=" + no);
        }
        sql = new StringBuffer("UPDATE I_ElementValue i SET C_Element_ID = (SELECT C_Element_ID FROM C_Element e WHERE i.ElementName=e.Name AND i.AD_Client_ID=e.AD_Client_ID)WHERE C_Element_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Element=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Element, ' WHERE C_Element_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Element=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Name, ' WHERE (Value IS NULL OR Name IS NULL) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Name=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue i SET AD_Column_ID = (SELECT AD_Column_ID FROM AD_Column c WHERE UPPER(i.Default_Account)=UPPER(c.ColumnName) AND c.AD_Table_ID IN (315,266) AND AD_Reference_ID=25) WHERE Default_Account IS NOT NULL AND AD_Column_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Column=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Column, ' WHERE AD_Column_ID IS NULL AND Default_Account IS NOT NULL AND UPPER(Default_Account)<>'DEFAULT_ACCT' AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Column=" + no);
        String[] yColumns = new String[]{"PostActual", "PostBudget", "PostStatistical", "PostEncumbrance"};
        for (int i2 = 0; i2 < yColumns.length; ++i2) {
            sql = new StringBuffer("UPDATE I_ElementValue SET ").append(yColumns[i2]).append("='Y' WHERE ").append(yColumns[i2]).append(" IS NULL OR ").append(yColumns[i2]).append(" NOT IN ('Y','N') AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Set " + yColumns[i2] + " Default=" + no);
        }
        sql = new StringBuffer("UPDATE I_ElementValue SET IsSummary='N' WHERE IsSummary IS NULL OR IsSummary NOT IN ('Y','N') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set IsSummary Default=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue SET IsDocControlled = CASE WHEN AD_Column_ID IS NOT NULL THEN 'Y' ELSE 'N' END WHERE IsDocControlled IS NULL OR IsDocControlled NOT IN ('Y','N') AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set IsDocumentControlled Default=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue SET AccountType='E' WHERE AccountType IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set AccountType Default=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid AccountType, ' WHERE AccountType NOT IN ('A','E','L','M','O','R') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid AccountType=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue SET AccountSign='N' WHERE AccountSign IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set AccountSign Default=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid AccountSign, ' WHERE AccountSign NOT IN ('N','C','D') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid AccountSign=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Key, ' WHERE (Value IS NULL OR Value='') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Invalid Key=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue i SET C_ElementValue_ID=(SELECT C_ElementValue_ID FROM C_ElementValue ev INNER JOIN C_Element e ON (ev.C_Element_ID=e.C_Element_ID) WHERE i.C_Element_ID=e.C_Element_ID AND i.AD_Client_ID=e.AD_Client_ID AND i.Value=ev.Value) WHERE C_ElementValue_ID IS NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Found ElementValue=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue i SET C_Charge_ID = (SELECT C_Charge_ID FROM C_Charge c WHERE i.ChargeName=c.Name AND i.AD_Client_ID=c.AD_Client_ID)WHERE C_Charge_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Charge=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue i SET C_TaxCategory_ID = (SELECT C_TaxCategory_ID FROM C_TaxCategory c WHERE i.TaxCategoryName=c.Name AND i.AD_Client_ID=c.AD_Client_ID)WHERE C_TaxCategory_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Tax Category=" + no);
        this.commitEx();
        int noInsert = 0;
        int noUpdate = 0;
        sql = new StringBuffer("SELECT * FROM I_ElementValue WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY I_ElementValue_ID");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MElementValue ev;
                X_I_ElementValue impEV = new X_I_ElementValue(this.getCtx(), rs, this.get_TrxName());
                int C_ElementValue_ID = impEV.getC_ElementValue_ID();
                int I_ElementValue_ID = impEV.getI_ElementValue_ID();
                if (C_ElementValue_ID == 0) {
                    ev = new MElementValue(impEV);
                    if (ev.save()) {
                        ++noInsert;
                        if (!ev.isSummary()) {
                            this.updateCharge(impEV, ev);
                        }
                        impEV.setC_ElementValue_ID(ev.getC_ElementValue_ID());
                        impEV.setI_IsImported(true);
                        impEV.saveEx();
                        continue;
                    }
                    sql = new StringBuffer("UPDATE I_ElementValue i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING("Insert ElementValue ")).append("WHERE I_ElementValue_ID=").append(I_ElementValue_ID);
                    DB.executeUpdate(sql.toString(), this.get_TrxName());
                    continue;
                }
                ev = new MElementValue(this.getCtx(), C_ElementValue_ID, this.get_TrxName());
                if (ev.get_ID() != C_ElementValue_ID) {
                    // empty if block
                }
                ev.set(impEV);
                if (ev.save()) {
                    ++noUpdate;
                    if (!ev.isSummary()) {
                        this.updateCharge(impEV, ev);
                    }
                    impEV.setI_IsImported(true);
                    impEV.saveEx();
                    continue;
                }
                sql = new StringBuffer("UPDATE I_ElementValue i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING("Update ElementValue")).append("WHERE I_ElementValue_ID=").append(I_ElementValue_ID);
                DB.executeUpdate(sql.toString(), this.get_TrxName());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            throw new Exception("create", e);
        }
        sql = new StringBuffer("UPDATE I_ElementValue SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_ElementValue_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdate), "@C_ElementValue_ID@: @Updated@");
        this.commitEx();
        sql = new StringBuffer("UPDATE I_ElementValue i SET ParentElementValue_ID=(SELECT C_ElementValue_ID FROM C_ElementValue ev WHERE i.C_Element_ID=ev.C_Element_ID AND i.ParentValue=ev.Value AND i.AD_Client_ID=ev.AD_Client_ID) WHERE ParentElementValue_ID IS NULL AND I_IsImported='Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Found Parent ElementValue=" + no);
        sql = new StringBuffer("UPDATE I_ElementValue SET I_ErrorMsg=I_ErrorMsg||'Info=ParentNotFound, ' WHERE ParentElementValue_ID IS NULL AND ParentValue IS NOT NULL AND I_IsImported='Y' AND Processed='N'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.config("Not Found Parent ElementValue=" + no);
        sql = new StringBuffer("SELECT i.ParentElementValue_ID, i.I_ElementValue_ID, e.AD_Tree_ID, i.C_ElementValue_ID, i.Value||'-'||i.Name AS Info FROM I_ElementValue i INNER JOIN C_Element e ON (i.C_Element_ID=e.C_Element_ID) WHERE i.C_ElementValue_ID IS NOT NULL AND e.AD_Tree_ID IS NOT NULL AND i.ParentElementValue_ID IS NOT NULL AND i.I_IsImported='Y' AND Processed='N' AND i.AD_Client_ID=").append(this.m_AD_Client_ID);
        int noParentUpdate = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            String updateSQL = "UPDATE AD_TreeNode SET Parent_ID=?, SeqNo=? WHERE AD_Tree_ID=? AND Node_ID=?";
            CPreparedStatement updateStmt = DB.prepareStatement(updateSQL, 1003, 1008, this.get_TrxName());
            while (rs.next()) {
                updateStmt.setInt(1, rs.getInt(1));
                updateStmt.setInt(2, rs.getInt(2));
                updateStmt.setInt(3, rs.getInt(3));
                updateStmt.setInt(4, rs.getInt(4));
                try {
                    no = updateStmt.executeUpdate();
                    noParentUpdate += no;
                }
                catch (SQLException ex) {
                    this.log.log(Level.SEVERE, "(ParentUpdate)", ex);
                    no = 0;
                }
                if (no != 0) continue;
                this.log.info("Parent not found for " + rs.getString(5));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "(ParentUpdateLoop) " + sql.toString(), e);
        }
        this.addLog(0, null, new BigDecimal(noParentUpdate), "@ParentElementValue_ID@: @Updated@");
        this.commitEx();
        sql = new StringBuffer("UPDATE I_ElementValue SET Processing='-'WHERE I_IsImported='Y' AND Processed='N' AND Processing='Y' AND C_ElementValue_ID IS NOT NULL").append(clientCheck);
        if (this.m_updateDefaultAccounts) {
            sql.append(" AND AD_Column_ID IS NULL");
        }
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Reset Processing Flag=" + no);
        if (this.m_updateDefaultAccounts) {
            this.updateDefaults(clientCheck);
        }
        sql = new StringBuffer("SELECT * FROM C_ValidCombination vc WHERE EXISTS (SELECT * FROM I_ElementValue i WHERE vc.Account_ID=i.C_ElementValue_ID)");
        sql = new StringBuffer("UPDATE I_ElementValue SET Processing='N', Processed='Y'WHERE I_IsImported='Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Processed=" + no);
        return "";
    }

    private void updateCharge(X_I_ElementValue impEV, MElementValue ev) {
        MCharge charge = (MCharge)impEV.getC_Charge();
        if (charge.get_ID() == 0 && !Util.isEmpty(impEV.getChargeName())) {
            charge.setName(impEV.getChargeName());
            charge.setAD_Org_ID(0);
            if (impEV.getC_TaxCategory_ID() == 0) {
                String sql = "SELECT C_TaxCategory_ID FROM C_TaxCategory WHERE AD_Client_ID = ? ORDER BY IsDefault DESC ";
                int taxc = DB.getSQLValue(this.get_TrxName(), sql, this.m_AD_Client_ID);
                charge.setC_TaxCategory_ID(taxc);
            } else {
                charge.setC_TaxCategory_ID(impEV.getC_TaxCategory_ID());
            }
            charge.saveEx();
            impEV.setC_Charge_ID(charge.getC_Charge_ID());
        }
        if (ev != null && !charge.is_new()) {
            for (MAcctSchema schema : MAcctSchema.getClientAcctSchema(this.getCtx(), this.m_AD_Client_ID)) {
                MAccount revenueAccount;
                MAccount expenseAccount;
                if (schema.getAcctSchemaElement("AC").getC_Element_ID() != ev.getC_Element_ID()) continue;
                MChargeAcct chargeacct = MChargeAcct.get(schema, charge.getC_Charge_ID(), this.get_TrxName());
                if (chargeacct == null) {
                    chargeacct = new MChargeAcct(this.getCtx(), 0, this.get_TrxName());
                    chargeacct.setAD_Org_ID(charge.getAD_Org_ID());
                    chargeacct.setC_AcctSchema_ID(schema.getC_AcctSchema_ID());
                    chargeacct.setC_Charge_ID(charge.getC_Charge_ID());
                }
                if ((expenseAccount = (MAccount)chargeacct.getCh_Expense_A()) == null) {
                    expenseAccount = MAccount.getDefault(schema, true);
                }
                if (expenseAccount.getAccount_ID() != ev.getC_ElementValue_ID()) {
                    MAccount account = MAccount.get(Env.getCtx(), charge.getAD_Client_ID(), charge.getAD_Org_ID(), schema.getC_AcctSchema_ID(), ev.getC_ElementValue_ID(), expenseAccount.getC_SubAcct_ID(), expenseAccount.getM_Product_ID(), expenseAccount.getC_BPartner_ID(), expenseAccount.getAD_OrgTrx_ID(), expenseAccount.getC_LocFrom_ID(), expenseAccount.getC_LocTo_ID(), expenseAccount.getC_SalesRegion_ID(), expenseAccount.getC_Project_ID(), expenseAccount.getC_Campaign_ID(), expenseAccount.getC_Activity_ID(), expenseAccount.getUser1_ID(), expenseAccount.getUser2_ID(), expenseAccount.getUserElement1_ID(), expenseAccount.getUserElement2_ID(), this.get_TrxName());
                    chargeacct.setCh_Expense_Acct(account.getC_ValidCombination_ID());
                }
                if ((revenueAccount = (MAccount)chargeacct.getCh_Revenue_A()) == null) {
                    revenueAccount = MAccount.getDefault(schema, true);
                }
                if (revenueAccount.getAccount_ID() != ev.getC_ElementValue_ID()) {
                    MAccount account = MAccount.get(Env.getCtx(), charge.getAD_Client_ID(), charge.getAD_Org_ID(), schema.getC_AcctSchema_ID(), ev.getC_ElementValue_ID(), revenueAccount.getC_SubAcct_ID(), revenueAccount.getM_Product_ID(), revenueAccount.getC_BPartner_ID(), revenueAccount.getAD_OrgTrx_ID(), revenueAccount.getC_LocFrom_ID(), revenueAccount.getC_LocTo_ID(), revenueAccount.getC_SalesRegion_ID(), revenueAccount.getC_Project_ID(), revenueAccount.getC_Campaign_ID(), revenueAccount.getC_Activity_ID(), revenueAccount.getUser1_ID(), revenueAccount.getUser2_ID(), revenueAccount.getUserElement1_ID(), revenueAccount.getUserElement2_ID(), this.get_TrxName());
                    chargeacct.setCh_Revenue_Acct(account.getC_ValidCombination_ID());
                }
                chargeacct.saveEx();
            }
        }
    }

    private void updateDefaults(String clientCheck) {
        this.log.config("CreateNewCombination=" + this.m_createNewCombination);
        StringBuffer sql = new StringBuffer("SELECT C_AcctSchema_ID FROM C_AcctSchema_Element WHERE C_Element_ID=?").append(clientCheck);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setInt(1, this.m_C_Element_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.updateDefaultAccounts(rs.getInt(1));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        sql = new StringBuffer("UPDATE C_AcctSchema_Element e SET C_ElementValue_ID=(SELECT C_ElementValue_ID FROM I_ElementValue i WHERE e.C_Element_ID=i.C_Element_ID AND i.C_ElementValue_ID IS NOT NULL AND UPPER(i.Default_Account)='DEFAULT_ACCT') WHERE EXISTS (SELECT * FROM I_ElementValue i WHERE e.C_Element_ID=i.C_Element_ID AND i.C_ElementValue_ID IS NOT NULL AND UPPER(i.Default_Account)='DEFAULT_ACCT' \tAND i.I_IsImported='Y' AND i.Processing='-')").append(clientCheck);
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@C_AcctSchema_Element_ID@: @Updated@");
    }

    private void updateDefaultAccounts(int C_AcctSchema_ID) {
        this.log.config("C_AcctSchema_ID=" + C_AcctSchema_ID);
        MAcctSchema as = new MAcctSchema(this.getCtx(), C_AcctSchema_ID, this.get_TrxName());
        if (as.getAcctSchemaElement("AC").getC_Element_ID() != this.m_C_Element_ID) {
            this.log.log(Level.SEVERE, "C_Element_ID=" + this.m_C_Element_ID + " not in AcctSchema=" + as);
            return;
        }
        int[] counts = new int[]{0, 0, 0};
        String sql = "SELECT i.C_ElementValue_ID, t.TableName, c.ColumnName, i.I_ElementValue_ID FROM I_ElementValue i INNER JOIN AD_Column c ON (i.AD_Column_ID=c.AD_Column_ID) INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE i.I_IsImported='Y' AND Processing='Y' AND i.C_ElementValue_ID IS NOT NULL AND C_Element_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.m_C_Element_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int no;
                int u;
                int C_ElementValue_ID = rs.getInt(1);
                String TableName = rs.getString(2);
                String ColumnName = rs.getString(3);
                int I_ElementValue_ID = rs.getInt(4);
                int n = u = this.updateDefaultAccount(TableName, ColumnName, C_AcctSchema_ID, C_ElementValue_ID);
                counts[n] = counts[n] + 1;
                if (u == 0 || (no = DB.executeUpdate((sql = "UPDATE I_ElementValue SET Processing='N' WHERE I_ElementValue_ID=" + I_ElementValue_ID).toString(), this.get_TrxName())) == 1) continue;
                this.log.log(Level.SEVERE, "Updated=" + no);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "", e);
        }
        this.addLog(0, null, new BigDecimal(counts[0]), as.toString() + ": @Errors@");
        this.addLog(0, null, new BigDecimal(counts[1]), as.toString() + ": @Updated@");
        this.addLog(0, null, new BigDecimal(counts[2]), as.toString() + ": OK");
    }

    private int updateDefaultAccount(String TableName, String ColumnName, int C_AcctSchema_ID, int C_ElementValue_ID) {
        this.log.fine(TableName + "." + ColumnName + " - " + C_ElementValue_ID);
        int retValue = 0;
        StringBuffer sql = new StringBuffer("SELECT x.").append(ColumnName).append(",Account_ID FROM ").append(TableName).append(" x INNER JOIN C_ValidCombination vc ON (x.").append(ColumnName).append("=vc.C_ValidCombination_ID) ").append("WHERE x.C_AcctSchema_ID=").append(C_AcctSchema_ID);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int C_ValidCombination_ID = rs.getInt(1);
                int Account_ID = rs.getInt(2);
                if (Account_ID == C_ElementValue_ID) {
                    retValue = 2;
                    this.log.fine("Account_ID same as new value");
                } else if (this.m_createNewCombination) {
                    MAccount acct = MAccount.get(this.getCtx(), C_ValidCombination_ID);
                    acct.setAccount_ID(C_ElementValue_ID);
                    if (acct.save()) {
                        retValue = 1;
                        int newC_ValidCombination_ID = acct.getC_ValidCombination_ID();
                        if (C_ValidCombination_ID != newC_ValidCombination_ID) {
                            sql = new StringBuffer("UPDATE ").append(TableName).append(" SET ").append(ColumnName).append("=").append(newC_ValidCombination_ID).append(" WHERE C_AcctSchema_ID=").append(C_AcctSchema_ID);
                            int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
                            this.log.fine("New #" + no + " - " + TableName + "." + ColumnName + " - " + C_ElementValue_ID + " -- " + C_ValidCombination_ID + " -> " + newC_ValidCombination_ID);
                            if (no == 1) {
                                retValue = 1;
                            }
                        }
                    } else {
                        this.log.log(Level.SEVERE, "Account not saved - " + acct);
                    }
                } else {
                    sql = new StringBuffer("UPDATE C_ValidCombination SET Account_ID=").append(C_ElementValue_ID).append(" WHERE C_ValidCombination_ID=").append(C_ValidCombination_ID);
                    int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
                    this.log.fine("Replace #" + no + " - " + "C_ValidCombination_ID=" + C_ValidCombination_ID + ", New Account_ID=" + C_ElementValue_ID);
                    if (no == 1) {
                        retValue = 1;
                        sql = new StringBuffer("UPDATE C_ValidCombination SET Account_ID=").append(C_ElementValue_ID).append(" WHERE Account_ID=").append(Account_ID);
                        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
                        this.log.fine("ImportAccount.updateDefaultAccount - Replace VC #" + no + " - " + "Account_ID=" + Account_ID + ", New Account_ID=" + C_ElementValue_ID);
                        sql = new StringBuffer("UPDATE Fact_Acct SET Account_ID=").append(C_ElementValue_ID).append(" WHERE Account_ID=").append(Account_ID);
                        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
                        this.log.fine("ImportAccount.updateDefaultAccount - Replace Fact #" + no + " - " + "Account_ID=" + Account_ID + ", New Account_ID=" + C_ElementValue_ID);
                    }
                }
            } else {
                this.log.log(Level.SEVERE, "Account not found " + sql);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return retValue;
    }
}

