/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MColumn;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.process.ColumnEncryption;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.SecureEngine;
import org.compiere.util.Util;

public class HashPasswords
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        String where = " Password IS NOT NULL AND Salt IS NULL ";
        int count = 0;
        boolean isEncrypted = MColumn.isEncrypted(417);
        List users = MTable.get(this.getCtx(), MUser.Table_ID).createQuery(where, this.get_TrxName()).list();
        for (MUser user : users) {
            if (user.getAD_User_ID() == 0) {
                String password = DB.getSQLValueString(this.get_TrxName(), "SELECT Password FROM AD_User WHERE AD_User_ID=?", 0);
                if (isEncrypted) {
                    password = SecureEngine.decrypt(password);
                }
                user.setPassword(password);
                String sql = "UPDATE AD_User SET Updated=SysDate, UpdatedBy=" + this.getAD_User_ID();
                if (!Util.isEmpty(password)) {
                    sql = sql + ", Password=" + DB.TO_STRING(isEncrypted ? SecureEngine.encrypt(user.getPassword()) : user.getPassword());
                    sql = sql + ", Salt=" + DB.TO_STRING(user.getSalt());
                }
                sql = sql + " WHERE AD_User_ID=0";
                DB.executeUpdateEx(sql, this.get_TrxName());
                ++count;
                continue;
            }
            user.setPassword(user.getPassword());
            ++count;
            user.saveEx();
        }
        return "@Updated@ " + count;
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(false);
        CLogMgt.setLevel(Level.CONFIG);
        ColumnEncryption columnEncryption = new ColumnEncryption();
        int processId = 328;
        int columnId = 417;
        Env.setContext(Env.getCtx(), "AD_Column_ID", columnId);
        MPInstance instance = new MPInstance(Env.getCtx(), processId, columnId);
        instance.saveEx();
        MPInstancePara instanceParameters = new MPInstancePara(instance, 10);
        instanceParameters.setParameter("IsEncrypted", true);
        instanceParameters.saveEx();
        instanceParameters = new MPInstancePara(instance, 20);
        instanceParameters.setParameter("ChangeSetting", true);
        instanceParameters.saveEx();
        ProcessInfo pi = new ProcessInfo("AD_ColumnEncryption", processId);
        pi.setRecord_ID(instance.getRecord_ID());
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        pi.setAD_Client_ID(0);
        pi.setAD_User_ID(100);
        columnEncryption.startProcess(Env.getCtx(), pi, null);
        processId = 53259;
        pi = new ProcessInfo("AD_User_HashPassword", processId);
        pi.setAD_Client_ID(0);
        pi.setAD_User_ID(100);
        HashPasswords process = new HashPasswords();
        process.startProcess(Env.getCtx(), pi, null);
    }
}

