/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.impexp.BankStatementMatchInfo;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MBankStatementMatcher;
import org.compiere.model.X_I_BankStatement;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class BankStatementMatcher
extends SvrProcess {
    MBankStatementMatcher[] m_matchers = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.m_matchers = MBankStatementMatcher.getMatchers(this.getCtx(), this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        int Table_ID = this.getTable_ID();
        int Record_ID = this.getRecord_ID();
        if (this.m_matchers == null || this.m_matchers.length == 0) {
            throw new IllegalStateException("No Matchers found");
        }
        this.log.info("doIt - Table_ID=" + Table_ID + ", Record_ID=" + Record_ID + ", Matchers=" + this.m_matchers.length);
        if (Table_ID == X_I_BankStatement.Table_ID) {
            return this.match(new X_I_BankStatement(this.getCtx(), Record_ID, this.get_TrxName()));
        }
        if (Table_ID == MBankStatement.Table_ID) {
            return this.match(new MBankStatement(this.getCtx(), Record_ID, this.get_TrxName()));
        }
        if (Table_ID == MBankStatementLine.Table_ID) {
            return this.match(new MBankStatementLine(this.getCtx(), Record_ID, this.get_TrxName()));
        }
        return "??";
    }

    private String match(X_I_BankStatement ibs) {
        if (this.m_matchers == null || ibs == null || ibs.getC_Payment_ID() != 0) {
            return "--";
        }
        this.log.fine("" + ibs);
        BankStatementMatchInfo info = null;
        for (int i2 = 0; i2 < this.m_matchers.length; ++i2) {
            if (!this.m_matchers[i2].isMatcherValid() || (info = this.m_matchers[i2].getMatcher().findMatch(ibs)) == null || !info.isMatched()) continue;
            if (info.getC_Payment_ID() > 0) {
                ibs.setC_Payment_ID(info.getC_Payment_ID());
            }
            if (info.getC_Invoice_ID() > 0) {
                ibs.setC_Invoice_ID(info.getC_Invoice_ID());
            }
            if (info.getC_BPartner_ID() > 0) {
                ibs.setC_BPartner_ID(info.getC_BPartner_ID());
            }
            ibs.saveEx();
            return "OK";
        }
        return "--";
    }

    private String match(MBankStatementLine bsl) {
        if (this.m_matchers == null || bsl == null || bsl.getC_Payment_ID() != 0) {
            return "--";
        }
        this.log.fine("match - " + bsl);
        BankStatementMatchInfo info = null;
        for (int i2 = 0; i2 < this.m_matchers.length; ++i2) {
            if (!this.m_matchers[i2].isMatcherValid() || (info = this.m_matchers[i2].getMatcher().findMatch(bsl)) == null || !info.isMatched()) continue;
            if (info.getC_Payment_ID() > 0) {
                bsl.setC_Payment_ID(info.getC_Payment_ID());
            }
            if (info.getC_Invoice_ID() > 0) {
                bsl.setC_Invoice_ID(info.getC_Invoice_ID());
            }
            if (info.getC_BPartner_ID() > 0) {
                bsl.setC_BPartner_ID(info.getC_BPartner_ID());
            }
            bsl.saveEx();
            return "OK";
        }
        return "--";
    }

    private String match(MBankStatement bs) {
        if (this.m_matchers == null || bs == null) {
            return "--";
        }
        this.log.fine("match - " + bs);
        int count = 0;
        MBankStatementLine[] lines = bs.getLines(false);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            if (lines[i2].getC_Payment_ID() != 0) continue;
            this.match(lines[i2]);
            ++count;
        }
        return String.valueOf(count);
    }
}

