/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ServerReportCtl {
    public static final String PARAM_PRINTER_NAME = "PRINTER_NAME";
    public static final String PARAM_PRINT_FORMAT = "PRINT_FORMAT";
    public static final String PARAM_PRINT_INFO = "PRINT_INFO";
    private static CLogger s_log = CLogger.getCLogger(ServerReportCtl.class);

    public static boolean startDocumentPrint(int type, MPrintFormat customPrintFormat, int Record_ID, String printerName) {
        ReportEngine re = ReportEngine.get(Env.getCtx(), type, Record_ID);
        if (re == null) {
            CLogger log = CLogger.getCLogger(ServerReportCtl.class);
            log.warning("NoDocPrintFormat");
            return false;
        }
        if (customPrintFormat != null) {
            re.setPrintFormat(customPrintFormat);
        }
        if (re.getPrintFormat() != null) {
            MPrintFormat format = re.getPrintFormat();
            if (format.getJasperProcess_ID() > 0) {
                boolean result = ServerReportCtl.runJasperProcess(Record_ID, re, true, printerName);
                return result;
            }
            ServerReportCtl.createOutput(re, printerName);
            ReportEngine.printConfirm(type, Record_ID);
        }
        return true;
    }

    public static boolean runJasperProcess(int Record_ID, ReportEngine re, boolean IsDirectPrint, String printerName) {
        ProcessInfoParameter pip;
        MPrintFormat format = re.getPrintFormat();
        ProcessInfo pi = new ProcessInfo("", format.getJasperProcess_ID());
        pi.setPrintPreview(!IsDirectPrint);
        pi.setRecord_ID(Record_ID);
        Vector<ProcessInfoParameter> jasperPrintParams = new Vector<ProcessInfoParameter>();
        if (printerName != null && printerName.trim().length() > 0) {
            pip = new ProcessInfoParameter(PARAM_PRINTER_NAME, printerName, null, null, null);
            jasperPrintParams.add(pip);
        }
        pip = new ProcessInfoParameter(PARAM_PRINT_FORMAT, format, null, null, null);
        jasperPrintParams.add(pip);
        pip = new ProcessInfoParameter(PARAM_PRINT_INFO, re.getPrintInfo(), null, null, null);
        jasperPrintParams.add(pip);
        pi.setParameter(jasperPrintParams.toArray(new ProcessInfoParameter[0]));
        ServerProcessCtl.process(null, pi, null);
        boolean result = true;
        return result;
    }

    private static void createOutput(ReportEngine re, String printerName) {
        if (printerName != null) {
            re.getPrintInfo().setPrinterName(printerName);
        }
        re.print();
    }

    public static boolean start(ASyncProcess parent, ProcessInfo pi) {
        if (pi.getAD_Process_ID() == 110) {
            return ServerReportCtl.startDocumentPrint(0, null, pi.getRecord_ID(), null);
        }
        if (pi.getAD_Process_ID() == MProcess.getProcess_ID("Rpt PP_Order", null)) {
            return ServerReportCtl.startDocumentPrint(8, null, pi.getRecord_ID(), null);
        }
        if (pi.getAD_Process_ID() == MProcess.getProcess_ID("Rpt DD_Order", null)) {
            return ServerReportCtl.startDocumentPrint(9, null, pi.getRecord_ID(), null);
        }
        if (pi.getAD_Process_ID() == 116) {
            return ServerReportCtl.startDocumentPrint(2, null, pi.getRecord_ID(), null);
        }
        if (pi.getAD_Process_ID() == 117) {
            return ServerReportCtl.startDocumentPrint(1, null, pi.getRecord_ID(), null);
        }
        if (pi.getAD_Process_ID() == 217) {
            return ServerReportCtl.startDocumentPrint(3, null, pi.getRecord_ID(), null);
        }
        if (pi.getAD_Process_ID() == 276) {
            return ServerReportCtl.startDocumentPrint(4, null, pi.getRecord_ID(), null);
        }
        if (pi.getAD_Process_ID() == 159) {
            return ServerReportCtl.startDocumentPrint(7, null, pi.getRecord_ID(), null);
        }
        if (pi.getAD_Process_ID() == 202 || pi.getAD_Process_ID() == 204) {
            return ServerReportCtl.startFinReport(pi);
        }
        return ServerReportCtl.startStandardReport(pi);
    }

    public static boolean startStandardReport(ProcessInfo pi, boolean IsDirectPrint) {
        pi.setPrintPreview(!IsDirectPrint);
        return ServerReportCtl.startStandardReport(pi);
    }

    public static boolean startStandardReport(ProcessInfo pi) {
        ReportEngine re = null;
        Object o = pi.getTransientObject();
        if (o == null) {
            o = pi.getSerializableObject();
        }
        if (o != null && o instanceof MPrintFormat) {
            Properties ctx = Env.getCtx();
            MPrintFormat format = (MPrintFormat)o;
            String TableName = MTable.getTableName(ctx, format.getAD_Table_ID());
            MQuery query = MQuery.get(ctx, pi.getAD_PInstance_ID(), TableName);
            PrintInfo info = new PrintInfo(pi);
            re = new ReportEngine(ctx, format, query, info);
            ServerReportCtl.createOutput(re, null);
            return true;
        }
        re = ReportEngine.get(Env.getCtx(), pi);
        if (re == null) {
            pi.setSummary("No ReportEngine");
            return false;
        }
        ServerReportCtl.createOutput(re, null);
        return true;
    }

    public static boolean startFinReport(ProcessInfo pi) {
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        String TableName = pi.getAD_Process_ID() == 202 ? "T_Report" : "T_ReportStatement";
        MQuery query = MQuery.get(Env.getCtx(), pi.getAD_PInstance_ID(), TableName);
        MPrintFormat format = (MPrintFormat)pi.getTransientObject();
        if (format == null) {
            format = (MPrintFormat)pi.getSerializableObject();
        }
        if (format == null) {
            s_log.log(Level.SEVERE, "startFinReport - No PrintFormat");
            return false;
        }
        PrintInfo info = new PrintInfo(pi);
        ReportEngine re = new ReportEngine(Env.getCtx(), format, query, info);
        ServerReportCtl.createOutput(re, null);
        return true;
    }
}

