/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.apps.ADialog;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.ReportViewerProvider;
import org.compiere.print.ServerReportCtl;
import org.compiere.print.SwingViewerProvider;
import org.compiere.process.ProcessInfo;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public class ReportCtl {
    public static final String PARAM_PRINTER_NAME = "PRINTER_NAME";
    public static final String PARAM_PRINT_FORMAT = "PRINT_FORMAT";
    public static final String PARAM_PRINT_INFO = "PRINT_INFO";
    private static CLogger s_log = CLogger.getCLogger(ReportCtl.class);
    private static ReportViewerProvider viewerProvider = new SwingViewerProvider();

    private ReportCtl() {
    }

    public static boolean start(ProcessInfo pi, boolean IsDirectPrint) {
        return ReportCtl.start(null, -1, pi, IsDirectPrint);
    }

    public static boolean start(ASyncProcess parent, int WindowNo, ProcessInfo pi, boolean IsDirectPrint) {
        pi.setPrintPreview(!IsDirectPrint);
        return ReportCtl.start(parent, WindowNo, pi);
    }

    public static boolean start(ASyncProcess parent, int WindowNo, ProcessInfo pi) {
        s_log.info("start - " + pi);
        if (pi.getAD_Process_ID() == 110) {
            return ReportCtl.startDocumentPrint(0, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
        }
        if (pi.getAD_Process_ID() == MProcess.getProcess_ID("Rpt PP_Order", null)) {
            return ReportCtl.startDocumentPrint(8, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
        }
        if (pi.getAD_Process_ID() == MProcess.getProcess_ID("Rpt DD_Order", null)) {
            return ReportCtl.startDocumentPrint(9, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
        }
        if (pi.getAD_Process_ID() == 116) {
            return ReportCtl.startDocumentPrint(2, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
        }
        if (pi.getAD_Process_ID() == 117) {
            return ReportCtl.startDocumentPrint(1, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
        }
        if (pi.getAD_Process_ID() == 217) {
            return ReportCtl.startDocumentPrint(3, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
        }
        if (pi.getAD_Process_ID() == 276) {
            return ReportCtl.startDocumentPrint(4, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
        }
        if (pi.getAD_Process_ID() == 313) {
            return ReportCtl.startCheckPrint(pi.getRecord_ID(), !pi.isPrintPreview());
        }
        if (pi.getAD_Process_ID() == 159) {
            return ReportCtl.startDocumentPrint(7, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
        }
        if (pi.getAD_Process_ID() == 202 || pi.getAD_Process_ID() == 204) {
            return ReportCtl.startFinReport(pi);
        }
        return ReportCtl.startStandardReport(pi);
    }

    public static boolean startStandardReport(ProcessInfo pi, boolean IsDirectPrint) {
        pi.setPrintPreview(!IsDirectPrint);
        return ReportCtl.startStandardReport(pi);
    }

    public static boolean startStandardReport(ProcessInfo pi) {
        ReportEngine re = null;
        Object o = pi.getTransientObject();
        if (o == null) {
            o = pi.getSerializableObject();
        }
        if (o != null && o instanceof MPrintFormat) {
            Properties ctx = Env.getCtx();
            MPrintFormat format = (MPrintFormat)o;
            String TableName = MTable.getTableName(ctx, format.getAD_Table_ID());
            MQuery query = MQuery.get(ctx, pi.getAD_PInstance_ID(), TableName);
            PrintInfo info = new PrintInfo(pi);
            re = new ReportEngine(ctx, format, query, info);
            ReportCtl.createOutput(re, pi.isPrintPreview(), null);
            return true;
        }
        re = ReportEngine.get(Env.getCtx(), pi);
        if (re == null) {
            pi.setSummary("No ReportEngine");
            return false;
        }
        ReportCtl.createOutput(re, pi.isPrintPreview(), null);
        return true;
    }

    public static boolean startFinReport(ProcessInfo pi) {
        String TableName = pi.getAD_Process_ID() == 202 ? "T_Report" : "T_ReportStatement";
        MQuery query = MQuery.get(Env.getCtx(), pi.getAD_PInstance_ID(), TableName);
        MPrintFormat format = (MPrintFormat)pi.getTransientObject();
        if (format == null) {
            format = (MPrintFormat)pi.getSerializableObject();
        }
        if (format == null) {
            s_log.log(Level.SEVERE, "startFinReport - No PrintFormat");
            return false;
        }
        PrintInfo info = new PrintInfo(pi);
        ReportEngine re = new ReportEngine(Env.getCtx(), format, query, pi, info);
        ReportCtl.createOutput(re, pi.isPrintPreview(), null);
        return true;
    }

    public static boolean startDocumentPrint(int type, int Record_ID, boolean IsDirectPrint) {
        return ReportCtl.startDocumentPrint(type, Record_ID, null, -1, IsDirectPrint);
    }

    public static boolean startDocumentPrint(int type, MPrintFormat customPrintFormat, int Record_ID, ASyncProcess parent, int WindowNo, String printerName) {
        return ReportCtl.startDocumentPrint(type, customPrintFormat, Record_ID, parent, WindowNo, true, printerName);
    }

    public static boolean startDocumentPrint(int type, int Record_ID, ASyncProcess parent, int WindowNo, boolean IsDirectPrint) {
        return ReportCtl.startDocumentPrint(type, null, Record_ID, parent, WindowNo, IsDirectPrint, null);
    }

    public static boolean startDocumentPrint(int type, MPrintFormat customPrintFormat, int Record_ID, ASyncProcess parent, int WindowNo, boolean IsDirectPrint, String printerName) {
        ReportEngine re = ReportEngine.get(Env.getCtx(), type, Record_ID);
        if (re == null) {
            if (Ini.isClient()) {
                ADialog.error(0, null, "NoDocPrintFormat");
            } else {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    if (loader == null) {
                        loader = ReportCtl.class.getClassLoader();
                    }
                    Class<?> clazz = loader.loadClass("org.adempiere.webui.window.FDialog");
                    Method m = clazz.getMethod("error", Integer.TYPE, String.class);
                    m.invoke(null, 0, "NoDocPrintFormat");
                }
                catch (Exception e) {
                    throw new AdempiereException(e);
                }
            }
            return false;
        }
        if (customPrintFormat != null) {
            re.setPrintFormat(customPrintFormat);
        }
        if (re.getPrintFormat() != null) {
            MPrintFormat format = re.getPrintFormat();
            if (format.getJasperProcess_ID() > 0) {
                ServerReportCtl.runJasperProcess(Record_ID, re, IsDirectPrint, printerName);
            } else {
                ReportCtl.createOutput(re, !IsDirectPrint, printerName);
                if (IsDirectPrint) {
                    ReportEngine.printConfirm(type, Record_ID);
                }
            }
        }
        return true;
    }

    public static boolean startCheckPrint(int C_Payment_ID, boolean IsDirectPrint) {
        int HR_PaySelectionCheck_ID = ReportCtl.getHRPaySelectionCheckById(Env.getCtx(), C_Payment_ID, null);
        if (HR_PaySelectionCheck_ID > 0) {
            return ReportCtl.startDocumentPrint(10, HR_PaySelectionCheck_ID, null, -1, IsDirectPrint);
        }
        boolean ok = MPaySelectionCheck.deleteGeneratedDraft(Env.getCtx(), C_Payment_ID, null);
        int C_PaySelectionCheck_ID = 0;
        MPaySelectionCheck psc = MPaySelectionCheck.getOfPayment(Env.getCtx(), C_Payment_ID, null);
        if (psc != null) {
            C_PaySelectionCheck_ID = psc.getC_PaySelectionCheck_ID();
        } else {
            psc = MPaySelectionCheck.createForPayment(Env.getCtx(), C_Payment_ID, null);
            if (psc != null) {
                C_PaySelectionCheck_ID = psc.getC_PaySelectionCheck_ID();
            }
        }
        return ReportCtl.startDocumentPrint(6, C_PaySelectionCheck_ID, null, -1, IsDirectPrint);
    }

    private static int getHRPaySelectionCheckById(Properties ctx, int C_Payment_ID, String trxName) {
        String sql = "SELECT MAX(HR_PaySelectionCheck_ID) FROM HR_PaySelectionCheck psc WHERE psc.C_Payment_ID = ? AND Processed=?";
        return DB.getSQLValue(trxName, "SELECT MAX(HR_PaySelectionCheck_ID) FROM HR_PaySelectionCheck psc WHERE psc.C_Payment_ID = ? AND Processed=?", C_Payment_ID, true);
    }

    private static void createOutput(ReportEngine re, boolean printPreview, String printerName) {
        if (printPreview) {
            ReportCtl.preview(re);
        } else {
            if (printerName != null) {
                re.getPrintInfo().setPrinterName(printerName);
            }
            re.print();
        }
    }

    public static void preview(ReportEngine re) {
        ReportViewerProvider provider = ReportCtl.getReportViewerProvider();
        provider.openViewer(re);
    }

    public static void setReportViewerProvider(ReportViewerProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set report viewer provider to null");
        }
        viewerProvider = provider;
    }

    public static ReportViewerProvider getReportViewerProvider() {
        return viewerProvider;
    }
}

