/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.PO;
import org.compiere.model.X_AD_PrintFont;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MPrintFont
extends X_AD_PrintFont {
    private static final long serialVersionUID = -4721840631004326810L;
    private Font m_cacheFont = null;
    private static CCache<Integer, MPrintFont> s_fonts = new CCache("AD_PrintFont", 20);

    public MPrintFont(Properties ctx, int AD_PrintFont_ID, String trxName) {
        super(ctx, AD_PrintFont_ID, trxName);
        if (AD_PrintFont_ID == 0) {
            this.setIsDefault(false);
        }
    }

    public Font getFont() {
        if (this.m_cacheFont != null) {
            return this.m_cacheFont;
        }
        String code = this.getCode();
        if (code == null || code.equals(".")) {
            this.m_cacheFont = new Font(null);
        }
        try {
            if (code != null && !code.equals(".")) {
                this.m_cacheFont = Font.decode(code);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "MPrintFont.getFont", e);
        }
        if (code == null) {
            this.m_cacheFont = new Font(null);
        }
        return this.m_cacheFont;
    }

    public void setFont(Font font) {
        StringBuffer sb = new StringBuffer();
        sb.append(font.getFamily()).append("-");
        int style = font.getStyle();
        if (style == 0) {
            sb.append("PLAIN");
        } else if (style == 1) {
            sb.append("BOLD");
        } else if (style == 2) {
            sb.append("ITALIC");
        } else if (style == 3) {
            sb.append("BOLDITALIC");
        }
        sb.append("-").append(font.getSize());
        this.setCode(sb.toString());
    }

    static MPrintFont create(Font font) {
        MPrintFont pf = new MPrintFont(Env.getCtx(), 0, null);
        StringBuffer name = new StringBuffer(font.getName());
        if (font.isBold()) {
            name.append(" bold");
        }
        if (font.isItalic()) {
            name.append(" italic");
        }
        name.append(" ").append(font.getSize());
        pf.setName(name.toString());
        pf.setFont(font);
        pf.saveEx();
        return pf;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPrintFont[");
        sb.append("ID=").append(this.get_ID()).append(",Name=").append(this.getName()).append("PSName=").append(this.getFont().getPSName()).append(this.getFont()).append("]");
        return sb.toString();
    }

    public String toPS() {
        StringBuffer sb = new StringBuffer("/");
        sb.append(this.getFont().getPSName());
        if (this.getFont().isBold()) {
            sb.append(" Bold");
        }
        if (this.getFont().isItalic()) {
            sb.append(" Italic");
        }
        sb.append(" ").append(this.getFont().getSize()).append(" selectfont");
        return sb.toString();
    }

    static void dump(Font font) {
        System.out.println("Family=" + font.getFamily());
        System.out.println("FontName=" + font.getFontName());
        System.out.println("Name=" + font.getName());
        System.out.println("PSName=" + font.getPSName());
        System.out.println("Style=" + font.getStyle());
        System.out.println("Size=" + font.getSize());
        System.out.println("Attributes:");
        Map<TextAttribute, ?> map = font.getAttributes();
        for (TextAttribute key : map.keySet()) {
            Object value = map.get(key);
            System.out.println(" - " + key + "=" + value);
        }
        System.out.println(font);
    }

    public static MPrintFont get(int AD_PrintFont_ID) {
        Integer key = new Integer(AD_PrintFont_ID);
        MPrintFont pf = s_fonts.get(key);
        if (pf == null) {
            pf = new MPrintFont(Env.getCtx(), AD_PrintFont_ID, null);
            s_fonts.put(key, pf);
        }
        return pf;
    }

    public static void main(String[] args) {
        System.out.println("Available Fonts:");
        String[] family = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i2 = 0; i2 < family.length; ++i2) {
            System.out.println(" - " + family[i2]);
        }
        Adempiere.startup(true);
        MPrintFont pf = new MPrintFont(Env.getCtx(), 100, null);
        MPrintFont.dump(pf.getFont());
        String[] systemLocical = new String[]{"Dialog", "DialogInput", "Monospaced", "Serif", "SansSerif"};
        for (int i3 = 0; i3 < systemLocical.length; ++i3) {
        }
        int[] IDs = PO.getAllIDs("AD_PrintFont", null, null);
        for (int i4 = 0; i4 < IDs.length; ++i4) {
            pf = new MPrintFont(Env.getCtx(), IDs[i4], null);
            System.out.println(IDs[i4] + " = " + pf.getFont());
        }
    }
}

