/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.Color;
import java.awt.SystemColor;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.PO;
import org.compiere.model.X_AD_PrintColor;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MPrintColor
extends X_AD_PrintColor {
    private static final long serialVersionUID = 8352503254165120016L;
    public static final Color darkGreen = new Color(0, 128, 0);
    public static final Color blackGreen = new Color(0, 64, 0);
    public static final Color darkBlue = new Color(0, 0, 128);
    public static final Color blackBlue = new Color(0, 0, 64);
    public static final Color whiteGray = new Color(224, 224, 224);
    public static final Color brown = new Color(153, 102, 51);
    public static final Color darkBrown = new Color(102, 51, 0);
    private static CCache<Integer, MPrintColor> s_colors = new CCache("AD_PrintColor", 20);
    private static CLogger s_log = CLogger.getCLogger(MPrintColor.class);
    private Color m_cacheColor = null;

    static MPrintColor create(Color color, String name) {
        MPrintColor pc = new MPrintColor(Env.getCtx(), 0, null);
        pc.setName(name);
        pc.setColor(color);
        pc.saveEx();
        return pc;
    }

    public static MPrintColor get(Properties ctx, int AD_PrintColor_ID) {
        Integer key = new Integer(AD_PrintColor_ID);
        MPrintColor pc = s_colors.get(key);
        if (pc == null) {
            pc = new MPrintColor(ctx, AD_PrintColor_ID, null);
            s_colors.put(key, pc);
        }
        return pc;
    }

    public static MPrintColor get(Properties ctx, String AD_PrintColor_ID) {
        if (AD_PrintColor_ID == null || AD_PrintColor_ID.length() == 0) {
            return null;
        }
        try {
            int id = Integer.parseInt(AD_PrintColor_ID);
            return MPrintColor.get(ctx, id);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "AD_PrintColor_ID=" + AD_PrintColor_ID + " - " + e.toString());
            return null;
        }
    }

    public MPrintColor(Properties ctx, int AD_PrintColor_ID, String trxName) {
        super(ctx, AD_PrintColor_ID, trxName);
        if (AD_PrintColor_ID == 0) {
            this.setIsDefault(false);
        }
    }

    public Color getColor() {
        if (this.m_cacheColor != null) {
            return this.m_cacheColor;
        }
        String code = this.getCode();
        if (code == null || code.equals(".")) {
            this.m_cacheColor = Color.black;
        }
        try {
            if (code != null && !code.equals(".")) {
                int rgba = Integer.parseInt(code);
                this.m_cacheColor = new Color(rgba, false);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "MPrintColor.getColor", e);
        }
        if (code == null) {
            this.m_cacheColor = Color.black;
        }
        return this.m_cacheColor;
    }

    public void setColor(Color color) {
        int rgba = color.getRGB();
        super.setCode(String.valueOf(rgba));
    }

    public String getRRGGBB() {
        Color color = this.getColor();
        StringBuffer sb = new StringBuffer();
        sb.append(Util.toHex((byte)color.getRed())).append(Util.toHex((byte)color.getGreen())).append(Util.toHex((byte)color.getBlue()));
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPrintColor[");
        sb.append("ID=").append(this.get_ID()).append(",Name=").append(this.getName()).append(",RGB=").append(this.getCode()).append(",").append(this.getColor()).append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        Color[] colors = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.darkGray, Color.gray, Color.lightGray, Color.white, Color.cyan, Color.magenta, Color.orange, Color.pink, Color.yellow, SystemColor.textHighlight};
        String[] names = new String[]{"Black", "Red", "Green", "Blue", "Gray dark", "Gray", "Gray light", "White", "Cyan", "Magenta", "Orange", "Pink", "Yellow", "Blue dark"};
        for (int i2 = 0; i2 < colors.length; ++i2) {
            System.out.println(names[i2] + " = " + colors[i2] + " RGB=" + colors[i2].getRGB() + " -> " + new Color(colors[i2].getRGB(), false) + " -> " + new Color(colors[i2].getRGB(), true));
        }
        int[] IDs = PO.getAllIDs("AD_PrintColor", null, null);
        for (int i3 = 0; i3 < IDs.length; ++i3) {
            MPrintColor pc = new MPrintColor(Env.getCtx(), IDs[i3], null);
            System.out.println(IDs[i3] + ": " + pc + " = " + pc.getColor() + ", RGB=" + pc.getColor().getRGB());
        }
    }
}

