/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MOrder;
import org.compiere.model.PO;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.pos.SubFunctionKeys;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SubLines
extends PosSubPanel
implements ActionListener {
    private static final long serialVersionUID = -1536223059244074580L;
    private MiniTable m_table;
    private String m_sql;
    private static CLogger log = CLogger.getCLogger(SubLines.class);
    private CButton f_up;
    private CButton f_delete;
    private CButton f_down;
    private VNumber f_net;
    private VNumber f_tax;
    private VNumber f_total;
    private VNumber f_Discount;
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "C_OrderLine_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Line"), "Line", Integer.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Qty"), "QtyOrdered", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "LineNetAmt"), "ROUND((copesa_prodprice_price(m_pricelist_version_id,LevelNo, m_product_id))*QtyOrdered)", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "IVA"), "round((copesa_prodprice_price(m_pricelist_version_id,LevelNo, m_product_id))*QtyOrdered*0.19)", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Total con IVA"), "round(((copesa_prodprice_price(m_pricelist_version_id,LevelNo, m_product_id))*QtyOrdered)*1.19)", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Precio de Lista"), "ROUND(pricelist*1.19)", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Descuento"), "ROUND((pricelist*1.19-(copesa_prodprice_price(m_pricelist_version_id,LevelNo, m_product_id))*1.19)*QtyOrdered)", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Socio de Negocio"), "bpLineName", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Direcci\u00f3n"), "locationName", String.class)};
    private static String s_sqlFrom = "RVOFB_order_linetax_v";
    private static String s_sqlWhere = "C_Order_ID=? AND LineNetAmt<>0 AND M_Product_ID > 0";

    public SubLines(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        TitledBorder border = new TitledBorder(Msg.translate(Env.getCtx(), "C_OrderLine_ID"));
        this.setBorder(border);
        this.setLayout(new BorderLayout(5, 5));
        this.m_table = new MiniTable();
        CScrollPane scroll = new CScrollPane(this.m_table);
        this.m_sql = String.valueOf(this.m_table.prepareTable(s_layout, s_sqlFrom, s_sqlWhere, false, "RVOFB_order_linetax_v")) + " ORDER BY Line";
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setMultiSelection(false);
        scroll.setPreferredSize(new Dimension(100, 120));
        this.add((Component)scroll, "Center");
        CPanel right = new CPanel();
        this.add((Component)right, "East");
        right.setLayout(new BoxLayout(right, 1));
        right.add(Box.createGlue());
        this.f_up = this.createButtonAction("Previous", KeyStroke.getKeyStroke(38, 0));
        right.add(this.f_up);
        right.add(Box.createGlue());
        this.f_delete = this.createButtonAction("Delete", KeyStroke.getKeyStroke(127, 1));
        right.add(this.f_delete);
        right.add(Box.createGlue());
        this.f_down = this.createButtonAction("Next", KeyStroke.getKeyStroke(40, 0));
        right.add(this.f_down);
        right.add(Box.createGlue());
        FlowLayout summaryLayout = new FlowLayout(3, 2, 0);
        CPanel summary = new CPanel(summaryLayout);
        this.add((Component)summary, "South");
        CLabel lNet = new CLabel(Msg.translate(Env.getCtx(), "TotalLines"));
        summary.add(lNet);
        this.f_net = new VNumber("TotalLines", false, true, false, 12, "TotalLines");
        this.f_net.setColumns(11, 22);
        lNet.setLabelFor(this.f_net);
        summary.add(this.f_net);
        this.f_net.setValue(Env.ZERO);
        CLabel lTax = new CLabel(Msg.translate(Env.getCtx(), "TaxAmt"));
        summary.add(lTax);
        this.f_tax = new VNumber("TaxAmt", false, true, false, 12, "TaxAmt");
        this.f_tax.setColumns(11, 22);
        lTax.setLabelFor(this.f_tax);
        summary.add(this.f_tax);
        this.f_tax.setValue(Env.ZERO);
        CLabel lTotal = new CLabel(Msg.translate(Env.getCtx(), "GrandTotal"));
        summary.add(lTotal);
        this.f_total = new VNumber("GrandTotal", false, true, false, 12, "GrandTotal");
        this.f_total.setColumns(11, 22);
        lTotal.setLabelFor(this.f_total);
        summary.add(this.f_total);
        this.f_total.setValue(Env.ZERO);
        CLabel lDiscount = new CLabel(Msg.translate(Env.getCtx(), "Descuento"));
        summary.add(lDiscount);
        this.f_Discount = new VNumber("Discount", false, true, false, 12, "Discount");
        this.f_Discount.setColumns(11, 22);
        lTotal.setLabelFor(this.f_Discount);
        summary.add(this.f_Discount);
        this.f_Discount.setValue(Env.ZERO);
        this.f_delete.setReadWrite(true);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.7;
        gbc.weighty = 0.7;
        return gbc;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosSubAllLines - actionPerformed: " + action);
        if ("Previous".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (--row < 0) {
                row = 0;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        if ("Next".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (++row >= rows) {
                row = rows - 1;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        if (action.equals("Delete")) {
            SubFunctionKeys.ID_Level = 1;
            MOrder order = this.p_posPanel.f_curLine.getOrder();
            DB.executeUpdate("DELETE FROM C_OrderLine WHERE C_Order_ID = " + order.get_ID() + " AND IsConfirmed = 'N' ", null);
            order.calculateTaxTotal();
            order.save();
            SubFunctionKeys.ID_Level = 1;
            SubFunctionKeys.ID_LevelPrice = 1;
            SubFunctionKeys.ID_BotonHide = "0";
            this.p_posPanel.f_functionKeys.removeAll();
            this.p_posPanel.f_functionKeys.init();
        }
        this.p_posPanel.updateInfo();
    }

    public void updateTable(MOrder order) {
        block7: {
            int C_Order_ID = 0;
            if (order != null) {
                C_Order_ID = order.getC_Order_ID();
            }
            if (C_Order_ID == 0) {
                this.m_table.loadTable(new PO[0]);
                this.setSums(null);
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(this.m_sql, null);
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    this.m_table.loadTable(rs);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, this.m_sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.setSums(order);
    }

    private void setSums(MOrder order) {
        int noLines = this.m_table.getRowCount();
        this.p_posPanel.f_status.setStatusDB(noLines);
        if (order == null || noLines == 0) {
            this.f_net.setValue(Env.ZERO);
            this.f_total.setValue(Env.ZERO);
            this.f_tax.setValue(Env.ZERO);
            this.f_Discount.setValue(Env.ZERO);
        } else {
            this.p_posPanel.f_curLine.setOrder(order.getC_Order_ID());
            MOrder retValue = this.p_posPanel.f_curLine.getOrder();
            BigDecimal amtTLine = DB.getSQLValueBD(null, "SELECT ROUND(SUM(copesa_prodprice_price(" + this.p_posPanel.f_bpartner.getM_PriceList_Version_ID() + ", " + SubFunctionKeys.ID_LevelPrice + ", m_product_id)*QtyOrdered)) FROM RVOFB_order_linetax_v WHERE C_Order_ID = ? ", retValue.get_ID());
            this.f_net.setValue(amtTLine);
            BigDecimal amtGTotal = DB.getSQLValueBD(null, "SELECT ROUND(SUM((copesa_prodprice_price(" + this.p_posPanel.f_bpartner.getM_PriceList_Version_ID() + ", " + SubFunctionKeys.ID_LevelPrice + ", m_product_id)*1.19)*QtyOrdered)) FROM RVOFB_order_linetax_v WHERE C_Order_ID = ? ", retValue.get_ID());
            this.f_total.setValue(amtGTotal);
            this.f_tax.setValue(amtGTotal.subtract(amtTLine));
            BigDecimal amtDiscount = DB.getSQLValueBD(null, "SELECT ROUND(SUM(((pricelist*1.19)-(copesa_prodprice_price(" + this.p_posPanel.f_bpartner.getM_PriceList_Version_ID() + ", " + SubFunctionKeys.ID_LevelPrice + ", m_product_id)*1.19))*QtyOrdered)) FROM RVOFB_order_linetax_v WHERE C_Order_ID = ? ", retValue.get_ID());
            if (amtDiscount != null) {
                this.f_Discount.setValue(amtDiscount);
            } else {
                this.f_Discount.setValue(Env.ZERO);
            }
        }
    }
}

