/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MBPartner;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MProduct;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.pos.SubFunctionKeys;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.copesa.model.COPESAOrderOps;

public class SubCurrentLine
extends PosSubPanel
implements ActionListener {
    private static final long serialVersionUID = -4023538043556457231L;
    private CButton f_new;
    private CButton f_reset;
    private CButton f_plus;
    private CButton f_minus;
    private CLabel f_currency;
    private VNumber f_price;
    private CLabel f_uom;
    private VNumber f_quantity;
    private MOrder m_order = null;
    private CComboBox f_Locator;
    private CLabel f_lLocator = null;
    private int level = 0;
    private static CLogger log = CLogger.getCLogger(SubCurrentLine.class);

    public SubCurrentLine(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        TitledBorder border = new TitledBorder(Msg.getMsg(Env.getCtx(), "CurrentLine"));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS2;
        gbc.gridy = 0;
        this.f_uom = new CLabel("--");
        gbc.gridx = 0;
        this.add((Component)this.f_uom, gbc);
        this.f_reset = this.createButtonAction("Reset", null);
        gbc.gridx = -1;
        this.add((Component)this.f_reset, gbc);
        this.f_reset.setVisible(false);
        this.f_currency = new CLabel("---");
        gbc.anchor = 13;
        gbc.weightx = 0.1;
        gbc.fill = 2;
        this.add((Component)this.f_currency, gbc);
        this.f_currency.setVisible(false);
        this.f_price = new VNumber("PriceActual", false, false, true, 12, Msg.translate(Env.getCtx(), "PriceActual"));
        this.f_price.addActionListener(this);
        this.f_price.setColumns(10, 25);
        this.f_price.setVisible(false);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)this.f_price, gbc);
        this.setPrice(Env.ZERO);
        this.f_lLocator = new CLabel("Ubicaci\u00f3n");
        gbc.anchor = 13;
        gbc.weightx = 0.1;
        gbc.fill = 13;
        this.add((Component)this.f_lLocator, gbc);
        this.f_Locator = new CComboBox();
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        this.add((Component)this.f_Locator, gbc);
        this.fillLocator();
        MRole rol = new MRole(Env.getCtx(), Env.getAD_Role_ID(Env.getCtx()), null);
        if (rol.get_ValueAsInt("M_Locator_ID") > 0) {
            MLocator loc = new MLocator(Env.getCtx(), rol.get_ValueAsInt("M_Locator_ID"), null);
            KeyNamePair wareHouseDefault = new KeyNamePair(loc.get_ID(), loc.getValue());
            this.f_Locator.setValue(wareHouseDefault);
            if (this.m_order != null) {
                this.m_order.setM_Warehouse_ID(loc.getM_Warehouse_ID());
                this.m_order.saveEx();
            }
        }
        this.f_uom = new CLabel("--");
        gbc.anchor = 13;
        gbc.weightx = 0.1;
        gbc.fill = 2;
        this.add((Component)this.f_uom, gbc);
        this.f_uom.setVisible(false);
        this.f_minus = this.createButtonAction("Minus", null);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)this.f_minus, gbc);
        this.f_minus.setVisible(false);
        this.f_quantity = new VNumber("QtyOrdered", false, false, true, 29, Msg.translate(Env.getCtx(), "QtyOrdered"));
        this.f_quantity.addActionListener(this);
        this.f_quantity.setColumns(5, 25);
        this.add((Component)this.f_quantity, gbc);
        this.setQty(Env.ONE);
        this.f_quantity.setVisible(false);
        this.f_plus = this.createButtonAction("Plus", null);
        this.add((Component)this.f_plus, gbc);
        this.f_plus.setVisible(false);
        this.f_new = this.createButtonAction("Save", KeyStroke.getKeyStroke(155, 1));
        this.add((Component)this.f_new, gbc);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        return gbc;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("SubCurrentLine - actionPerformed: " + action);
        if (action.equals("Save")) {
            if (this.saveLine()) {
                this.p_posPanel.f_functionKeys.removeAll();
                this.p_posPanel.f_functionKeys.init();
            }
        } else if (action.equals("Reset")) {
            this.newLine();
        } else if (action.equals("Plus")) {
            this.f_quantity.plus();
        } else if (action.equals("Minus")) {
            this.f_quantity.minus(1);
        } else if (e.getSource() == this.f_price) {
            this.f_price.setValue(this.f_price.getValue());
        } else if (e.getSource() == this.f_quantity) {
            this.f_quantity.setValue(this.f_quantity.getValue());
        }
        this.p_posPanel.updateInfo();
    }

    public void setCurrency(String currency) {
        if (currency == null) {
            this.f_currency.setText("---");
        } else {
            this.f_currency.setText(currency);
        }
    }

    public void setUOM(String UOM) {
        if (UOM == null) {
            this.f_uom.setText("--");
        } else {
            this.f_uom.setText(UOM);
        }
    }

    public void setPrice(BigDecimal price) {
        if (price == null) {
            price = Env.ZERO;
        }
        this.f_price.setValue(price);
        boolean rw = Env.ZERO.compareTo(price) == 0 || this.p_pos.isModifyPrice();
        this.f_price.setReadWrite(rw);
    }

    public BigDecimal getPrice() {
        return (BigDecimal)this.f_price.getValue();
    }

    public void setQty(BigDecimal qty) {
        this.f_quantity.setValue(qty);
    }

    public BigDecimal getQty() {
        return (BigDecimal)this.f_quantity.getValue();
    }

    public void newLine() {
        this.p_posPanel.f_product.setM_Product_ID(0);
        this.setQty(Env.ONE);
        this.setPrice(Env.ZERO);
    }

    public boolean saveLine() {
        MProduct product = this.p_posPanel.f_product.getProduct();
        if (product == null) {
            return false;
        }
        if (this.p_posPanel.f_bpartner.getC_BPartner_ID() <= 0 || this.p_posPanel.f_bpartner.getC_BPartner_Location_ID() <= 0 || this.p_posPanel.f_bpartner.getC_BpartnertRef_ID() <= 0 || this.p_posPanel.f_bpartner.getC_BPartner_LocationShip_ID() <= 0) {
            JOptionPane.showMessageDialog(null, "ERROR: LLenar todos los campos");
            this.p_posPanel.f_checkout.displayReturn();
            return true;
        }
        BigDecimal QtyOrdered = (BigDecimal)this.f_quantity.getValue();
        BigDecimal amt = null;
        BigDecimal amtMonthly = null;
        if (!COPESAOrderOps.isThereStock(this.m_order.get_TrxName(), this.m_order.getM_Warehouse_ID(), this.getM_Locator_ID(), product.get_ID())) {
            JOptionPane.showMessageDialog(null, "ERROR: Sin Stock de Producto");
            return false;
        }
        if (!COPESAOrderOps.validLocation(this.m_order.get_TrxName(), this.p_posPanel.f_bpartner.getC_BPartner_LocationShip_ID())) {
            log.severe("Direcci\u00f3n sin cobertura de despacho");
            JOptionPane.showMessageDialog(null, "Direcci\u00f3n sin cobertura de despacho");
            return false;
        }
        if (!COPESAOrderOps.allLocationsTheSame(this.m_order, this.p_posPanel.f_bpartner.getC_BPartner_LocationShip_ID()) && COPESAOrderOps.isOnlyOneLocationRequired(this.m_order.get_TrxName(), this.m_order.getM_PriceList_ID())) {
            JOptionPane.showMessageDialog(null, "ERROR: Lista de precios exige una sola direcci\u00f3n de despacho para el pedido");
            return false;
        }
        String PPriceFlag = "Y";
        String sql = "SELECT AddLevel, PriceStd, PricePat FROM M_ProductPrice WHERE IsActive = 'Y' AND M_Product_ID = ? AND Levels = 1  AND M_PriceList_Version_ID = ?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, this.m_order.get_TrxName());
            pstmt.setInt(1, product.get_ID());
            pstmt.setInt(2, this.p_posPanel.f_bpartner.getM_PriceList_Version_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                PPriceFlag = rs.getString(1);
                amt = rs.getBigDecimal(2);
                amtMonthly = rs.getBigDecimal(3);
            }
            rs.close();
            pstmt.close();
            if (PPriceFlag.equals("Y")) {
                SubFunctionKeys.ID_LevelPrice = Math.min(SubFunctionKeys.ID_LevelPrice + 1, SubFunctionKeys.ID_Level);
            }
            if (SubFunctionKeys.ID_LevelPrice > 1) {
                sql = "SELECT Price, PricePAT FROM M_ProductPriceRef WHERE IsActive = 'Y' AND M_Product_ID = ? AND Levels = ?  AND M_PriceList_Version_ID = ?";
                pstmt = DB.prepareStatement(sql, this.m_order.get_TrxName());
                pstmt.setInt(1, product.get_ID());
                pstmt.setInt(2, SubFunctionKeys.ID_LevelPrice);
                pstmt.setInt(3, this.p_posPanel.f_bpartner.getM_PriceList_Version_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    amt = rs.getBigDecimal(1);
                    amtMonthly = rs.getBigDecimal(2);
                }
                rs.close();
                pstmt.close();
            }
        }
        catch (Exception e) {
            log.config("Error " + e + " SQL: " + sql);
            JOptionPane.showMessageDialog(null, "Error inesperado obteniendo informaci\u00f3n de lista de precios (" + e.getMessage() + ")");
            return false;
        }
        BigDecimal PriceActual = amt;
        MOrderLine line = this.createLine(product, QtyOrdered, PriceActual);
        if (line == null) {
            return false;
        }
        line.setC_BPartner_Location_ID(this.p_posPanel.f_bpartner.getC_BPartner_LocationShip_ID());
        line.set_CustomColumn("C_BPartnerRef_ID", this.p_posPanel.f_bpartner.getC_BpartnertRef_ID());
        line.set_CustomColumn("QtyOriginal", QtyOrdered);
        line.set_CustomColumn("C_CalendarCOPESA_ID", COPESAOrderOps.altLineCalendar(this.p_posPanel.f_curLine.m_order, product));
        this.p_posPanel.f_checkout.cOrderLookup.setVisible(false);
        if (amtMonthly != null && amtMonthly.compareTo(Env.ZERO) > 0) {
            line.set_CustomColumn("MonthlyAmount", amtMonthly);
        }
        if (this.level > 0) {
            line.set_CustomColumn("LevelNo", this.level);
        }
        line.set_CustomColumn("M_Locator_ID", this.getM_Locator_ID());
        if (!line.save()) {
            return false;
        }
        int checksdlines = DB.getSQLValue(this.p_posPanel.f_curLine.m_order.get_TrxName(), "select copesa_checksdlines( " + this.m_order.get_ID() + " )");
        if (checksdlines > 0) {
            log.severe("Existen l\u00edneas sin cobertura de despacho. Verifique l\u00edneas de productos con calendario SD y sus sector/zona de despacho");
            JOptionPane.showMessageDialog(null, "Existen l\u00edneas sin cobertura de despacho. Verifique l\u00edneas de productos con calendario SD y sus sector/zona de despacho");
            line.delete(true, this.m_order.get_TrxName());
            return false;
        }
        this.newLine();
        this.updateOrderLines(this.m_order);
        this.p_posPanel.f_product.setPrice(PriceActual);
        this.p_posPanel.f_bpartner.f_name.setReadWrite(false);
        this.p_posPanel.f_bpartner.f_name.setEditable(false);
        this.p_posPanel.f_bpartner.f_location.setReadWrite(false);
        this.p_posPanel.f_bpartner.f_location.setEditable(false);
        this.p_posPanel.f_bpartner.f_bSearch.setReadWrite(false);
        this.p_posPanel.updateInfo();
        ++SubFunctionKeys.ID_Level;
        SubFunctionKeys.ID_BotonHide = String.valueOf(SubFunctionKeys.ID_BotonHide) + "," + product.get_ID();
        return true;
    }

    public void deleteLine(int row) {
        MOrderLine[] lineas;
        int numLineas;
        if (this.m_order != null && row != -1 && (numLineas = (lineas = this.m_order.getLines(true, "line asc")).length) > row) {
            lineas[row].setQtyDelivered(Env.ZERO);
            lineas[row].setQtyReserved(Env.ZERO);
            --SubFunctionKeys.ID_Level;
            --SubFunctionKeys.ID_LevelPrice;
            lineas[row].delete(true);
            int i = row;
            while (i < numLineas - 1) {
                lineas[i] = lineas[i + 1];
                ++i;
            }
            lineas[numLineas - 1] = null;
            this.p_posPanel.f_functionKeys.removeAll();
            this.p_posPanel.f_functionKeys.init();
        }
    }

    public void deleteOrder() {
        if (this.m_order != null && this.m_order.getDocStatus().equals("DR")) {
            int numTax;
            MOrderTax[] taxs;
            int numLineas;
            MOrderLine[] lineas = this.m_order.getLines();
            if (lineas != null && (numLineas = lineas.length) > 0) {
                int i = numLineas - 1;
                while (i >= 0) {
                    if (lineas[i] != null) {
                        this.deleteLine(i);
                    }
                    --i;
                }
            }
            if ((taxs = this.m_order.getTaxes(true)) != null && (numTax = taxs.length) > 0) {
                int i = taxs.length - 1;
                while (i >= 0) {
                    if (taxs[i] != null) {
                        taxs[i].delete(true);
                    }
                    taxs[i] = null;
                    --i;
                }
            }
            this.m_order.delete(true);
            this.m_order = null;
        }
    }

    public void newOrder() {
        this.m_order = null;
        this.m_order = this.getOrder();
    }

    public MOrder getOrder() {
        if (this.m_order == null) {
            this.m_order = new MOrder(Env.getCtx(), 0, null);
            this.m_order.setAD_Org_ID(this.p_pos.getAD_Org_ID());
            this.m_order.setIsSOTrx(true);
            if (this.p_pos.getC_DocType_ID() != 0) {
                this.m_order.setC_DocTypeTarget_ID(this.p_pos.getC_DocType_ID());
            } else {
                this.m_order.setC_DocTypeTarget_ID("WR");
            }
            MBPartner partner = this.p_posPanel.f_bpartner.getBPartner();
            if (partner == null || partner.get_ID() == 0) {
                partner = this.p_pos.getBPartner();
            }
            if (partner == null || partner.get_ID() == 0) {
                log.log(Level.SEVERE, "SubCurrentLine.getOrder - no BPartner");
                return null;
            }
            log.info("SubCurrentLine.getOrder -" + partner);
            this.m_order.setBPartner(partner);
            this.p_posPanel.f_bpartner.setC_BPartner_ID(partner.getC_BPartner_ID());
            int id = this.p_posPanel.f_bpartner.getC_BPartner_Location_ID();
            if (id != 0) {
                this.m_order.setC_BPartner_Location_ID(id);
            }
            if ((id = this.p_posPanel.f_bpartner.getAD_User_ID()) != 0) {
                this.m_order.setAD_User_ID(id);
            }
            this.m_order.setM_PriceList_ID(this.p_pos.getM_PriceList_ID());
            this.m_order.setM_Warehouse_ID(this.p_pos.getM_Warehouse_ID());
            this.m_order.setSalesRep_ID(Env.getAD_User_ID(this.p_ctx));
            MUser userCtx = new MUser(this.p_ctx, Env.getAD_User_ID(this.p_ctx), null);
            if (userCtx.get_ValueAsInt("C_Channel_ID") > 0) {
                this.m_order.set_CustomColumn("C_Channel_ID", userCtx.get_ValueAsInt("C_Channel_ID"));
            }
            this.m_order.setPaymentRule("D");
            MUser user = new MUser(Env.getCtx(), Env.getAD_User_ID(Env.getCtx()), null);
            if (user.get_ValueAsInt("C_Channel_ID") > 0) {
                this.m_order.set_CustomColumn("C_Channel_ID", user.get_ValueAsInt("C_Channel_ID"));
            }
            this.m_order.setDateOrdered(Env.getContextAsDate(Env.getCtx(), "#Date"));
            this.m_order.setDateAcct(Env.getContextAsDate(Env.getCtx(), "#Date"));
            if (!this.m_order.save()) {
                this.m_order = null;
                log.severe("Unable create Order.");
            }
        }
        return this.m_order;
    }

    public MOrder getOrderWhitOutCreate() {
        if (this.m_order == null) {
            return null;
        }
        return this.m_order;
    }

    public void setBPartner() {
        if (this.m_order != null && this.m_order.getDocStatus().equals("DR")) {
            MBPartner partner = this.p_posPanel.f_bpartner.getBPartner();
            if (partner == null || partner.get_ID() == 0) {
                partner = this.p_pos.getBPartner();
            }
            if (partner == null || partner.get_ID() == 0) {
                log.warning("SubCurrentLine.getOrder - no BPartner");
            } else {
                log.info("SubCurrentLine.getOrder -" + partner);
                this.m_order.setBPartner(partner);
                MOrderLine[] lineas = this.m_order.getLines();
                int i = 0;
                while (i < lineas.length) {
                    lineas[i].setC_BPartner_ID(partner.getC_BPartner_ID());
                    lineas[i].setTax();
                    lineas[i].save();
                    ++i;
                }
                this.m_order.save();
            }
        }
    }

    public MOrderLine createLine(MProduct product, BigDecimal QtyOrdered, BigDecimal PriceActual) {
        MOrder order = this.getOrder();
        if (order == null) {
            return null;
        }
        if (!order.getDocStatus().equals("DR")) {
            return null;
        }
        MOrderLine line = new MOrderLine(order);
        line.setProduct(product);
        line.setQty(QtyOrdered);
        line.setPrice();
        line.setPrice(PriceActual);
        return line;
    }

    public void setOldOrder(int m_c_order_id) {
        this.deleteOrder();
        this.m_order = new MOrder(this.p_ctx, m_c_order_id, null);
        this.p_posPanel.updateInfo();
    }

    public void setOrder(int m_c_order_id) {
        this.m_order = new MOrder(this.p_ctx, m_c_order_id, null);
    }

    public void updateOrderLines(MOrder order) {
        if (order != null) {
            MOrderLine[] lines = order.getLines(true, null);
            int i = 0;
            while (i < lines.length) {
                MOrderLine line = lines[i];
                if (!line.get_ValueAsBoolean("IsConfirmed")) {
                    BigDecimal amt = null;
                    BigDecimal amtPP = null;
                    String sqlAmt = "";
                    String sqlAmtPP = "";
                    try {
                        if (SubFunctionKeys.ID_LevelPrice == 1) {
                            sqlAmt = "SELECT PriceStd FROM M_ProductPrice WHERE IsActive = 'Y'  AND M_Product_ID = " + line.getM_Product_ID() + " AND Levels = " + SubFunctionKeys.ID_LevelPrice + " AND M_PriceList_Version_ID = " + this.p_posPanel.f_bpartner.getM_PriceList_Version_ID();
                            amt = DB.getSQLValueBD(null, sqlAmt, new Object[0]);
                            sqlAmtPP = "SELECT PricePat FROM M_ProductPrice WHERE IsActive = 'Y'  AND M_Product_ID = " + line.getM_Product_ID() + " AND Levels = " + SubFunctionKeys.ID_LevelPrice + " AND M_PriceList_Version_ID = " + this.p_posPanel.f_bpartner.getM_PriceList_Version_ID();
                            amtPP = DB.getSQLValueBD(null, sqlAmtPP, new Object[0]);
                        } else if (SubFunctionKeys.ID_LevelPrice > 1) {
                            sqlAmt = "SELECT Price FROM M_ProductPriceRef WHERE IsActive = 'Y'  AND M_Product_ID = " + line.getM_Product_ID() + " AND Levels = " + SubFunctionKeys.ID_LevelPrice + " AND M_PriceList_Version_ID = " + this.p_posPanel.f_bpartner.getM_PriceList_Version_ID();
                            amt = DB.getSQLValueBD(null, sqlAmt, new Object[0]);
                            sqlAmtPP = "SELECT PricePat FROM M_ProductPriceRef WHERE IsActive = 'Y'  AND M_Product_ID = " + line.getM_Product_ID() + " AND Levels = " + SubFunctionKeys.ID_LevelPrice + " AND M_PriceList_Version_ID = " + this.p_posPanel.f_bpartner.getM_PriceList_Version_ID();
                            amtPP = DB.getSQLValueBD(null, sqlAmtPP, new Object[0]);
                        }
                    }
                    catch (Exception e2) {
                        log.config("error" + e2 + " SQL: " + sqlAmt);
                        amt = Env.ZERO;
                    }
                    if (amt != null) {
                        line.setPrice(amt);
                    }
                    if (amtPP != null) {
                        line.set_CustomColumn("MonthlyAmount", amtPP);
                    }
                    if (SubFunctionKeys.ID_LevelPrice > 0) {
                        line.set_CustomColumn("LevelNo", SubFunctionKeys.ID_LevelPrice);
                    }
                    line.save();
                }
                ++i;
            }
        }
    }

    public void setLevelNo(int levelNo) {
        this.level = levelNo;
    }

    public int getM_Locator_ID() {
        KeyNamePair pp;
        if (this.f_Locator.getSelectedItem() != null && (pp = (KeyNamePair)this.f_Locator.getSelectedItem()) != null) {
            return pp.getKey();
        }
        return 0;
    }

    private void fillLocator() {
        Vector<KeyNamePair> warehouseVector;
        block7: {
            warehouseVector = new Vector<KeyNamePair>();
            if (this.f_Locator != null) {
                String sqlPList = "SELECT loc.M_Locator_ID FROM M_Locator loc JOIN co_grant_locator_role gr ON gr.ad_role_id = " + Env.getAD_Role_ID(Env.getCtx()) + " AND loc.M_Locator_ID = gr.M_Locator_ID " + "WHERE loc.M_Warehouse_ID = " + this.p_pos.getM_Warehouse_ID() + "  AND loc.AD_Client_ID = " + Env.getAD_Client_ID(Env.getCtx());
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sqlPList, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            MLocator wHouse = new MLocator(Env.getCtx(), rs.getInt("M_Locator_ID"), null);
                            warehouseVector.add(wHouse.getKeyNamePair());
                        }
                        rs.close();
                        pstmt.close();
                        pstmt = null;
                    }
                    catch (SQLException e3) {
                        log.config("error" + e3 + " SQL: " + sqlPList);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                Object var3_3 = null;
            }
        }
        DefaultComboBoxModel warehousehip = new DefaultComboBoxModel(warehouseVector);
        this.f_Locator.setModel((ComboBoxModel)warehousehip);
    }
}

