/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MDocType;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.pos.SubFunctionKeys;
import org.compiere.print.ReportCtl;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.copesa.model.COPESAOrderOps;

public class SubCheckout
extends PosSubPanel
implements ActionListener {
    private static final long serialVersionUID = 6359287546081954105L;
    private CButton f_register = null;
    public CButton f_summary = null;
    private CButton f_process = null;
    public CComboBox f_PriceList;
    private CButton f_RefreshPrice = null;
    public VLookup cOrderLookup;
    public VLookup cOrderLookupToCopy;
    public int ID_lastOrder;
    public VDate dateField;
    private CLabel f_lDocumentNo = null;
    private CTextField f_DocumentNo;
    private CLabel f_lcashGiven = null;
    private VNumber f_cashGiven;
    private CLabel f_lcashReturn = null;
    private VNumber f_cashReturn;
    private CButton f_cashPayment = null;
    private CButton f_cashRegisterFunctions;
    private static CLogger log = CLogger.getCLogger(SubCheckout.class);

    public SubCheckout(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS2;
        gbc.gridx = 0;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.weightx = 0.1;
        CPanel cash = new CPanel(new GridBagLayout());
        cash.setBackground(Color.lightGray);
        cash.setBorder(new TitledBorder(Msg.getMsg(Env.getCtx(), "Checkout")));
        gbc.gridy = 0;
        this.add((Component)cash, gbc);
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = INSETS2;
        this.f_lDocumentNo = new CLabel(Msg.getMsg(Env.getCtx(), "DocumentNo"));
        cash.add((Component)this.f_lDocumentNo, gbc0);
        this.f_DocumentNo = new CTextField("");
        this.f_DocumentNo.setName("DocumentNo");
        cash.add((Component)this.f_DocumentNo, gbc0);
        this.f_lcashGiven = new CLabel(Msg.getMsg(Env.getCtx(), "CashGiven"));
        cash.add((Component)this.f_lcashGiven, gbc0);
        this.f_cashGiven = new VNumber("CashGiven", false, false, true, 12, Msg.translate(Env.getCtx(), "CashGiven"));
        this.f_cashGiven.setColumns(12, 25);
        cash.add((Component)this.f_cashGiven, gbc0);
        this.f_cashGiven.setValue(Env.ZERO);
        this.f_cashGiven.addActionListener(this);
        this.f_lcashGiven.setVisible(false);
        this.f_cashGiven.setVisible(false);
        this.f_lcashReturn = new CLabel(Msg.getMsg(Env.getCtx(), "CashReturn"));
        cash.add((Component)this.f_lcashReturn, gbc0);
        this.f_cashReturn = new VNumber("CashReturn", false, true, false, 12, "CashReturn");
        this.f_cashReturn.setColumns(8, 25);
        cash.add((Component)this.f_cashReturn, gbc0);
        this.f_cashReturn.setValue(Env.ZERO);
        this.f_lcashReturn.setVisible(false);
        this.f_cashReturn.setVisible(false);
        this.f_cashPayment = this.createButtonAction("Payment", null);
        this.f_cashPayment.setActionCommand("Cash");
        gbc0.weightx = 0.1;
        cash.add((Component)this.f_cashPayment, gbc0);
        this.f_cashPayment.setVisible(false);
        CPanel utils = new CPanel(new GridBagLayout());
        utils.setBorder(new TitledBorder(Msg.getMsg(Env.getCtx(), "Utils")));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.1;
        this.add((Component)utils, gbc);
        GridBagConstraints gbcU = new GridBagConstraints();
        gbcU.insets = INSETS2;
        gbcU.anchor = 13;
        this.f_cashRegisterFunctions = this.createButtonAction("CashRegisterFunction", null);
        this.f_cashRegisterFunctions.setText("Cash Functions");
        this.f_cashRegisterFunctions.setPreferredSize(new Dimension(130, 37));
        this.f_cashRegisterFunctions.setMaximumSize(new Dimension(130, 37));
        this.f_cashRegisterFunctions.setMinimumSize(new Dimension(130, 37));
        this.cOrderLookupToCopy = new VLookup("C_Order_ID", false, true, false, MLookupFactory.get(Env.getCtx(), 0, 0, 2161, 30));
        this.cOrderLookupToCopy.setVisible(true);
        this.cOrderLookupToCopy.setReadWrite(true);
        this.cOrderLookupToCopy.addActionListener(this);
        utils.add((Component)this.cOrderLookupToCopy, gbcU);
        this.f_register = this.createButtonAction("Register", null);
        utils.add((Component)this.f_register, gbcU);
        this.f_summary = this.createButtonAction("Summary", null);
        this.f_summary.setVisible(false);
        utils.add((Component)this.f_summary, gbcU);
        this.f_process = this.createButtonAction("Process", null);
        utils.add((Component)this.f_process, gbcU);
        this.f_PriceList = new CComboBox();
        utils.add((Component)this.f_PriceList, gbcU);
        KeyNamePair pListDefault = new KeyNamePair(this.p_pos.getM_PriceList().getM_PriceList_ID(), this.p_pos.getM_PriceList().getName());
        this.f_PriceList.addItem(pListDefault);
        this.f_RefreshPrice = this.createButtonAction("Aplicar LP", null);
        this.f_RefreshPrice.setPreferredSize(new Dimension(70, 40));
        utils.add((Component)this.f_RefreshPrice, gbcU);
        this.dateField = new VDate("Fecha", false, false, true, 15, "Fecha");
        this.dateField.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.dateField.setVisible(true);
        this.dateField.setReadWrite(true);
        utils.add((Component)this.dateField, gbcU);
        this.cOrderLookup = new VLookup("C_Order_ID", false, true, false, MLookupFactory.get(Env.getCtx(), 0, 0, 2161, 30));
        this.cOrderLookup.setValue(this.p_posPanel.f_curLine.getOrder().get_ID());
        this.cOrderLookup.setVisible(false);
        utils.add((Component)this.cOrderLookup, gbcU);
        this.fillCombos();
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        return gbc;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosSubCheckout - actionPerformed: " + action);
        if (action.equals("Register")) {
            MOrder orderTo = this.p_posPanel.f_curLine.getOrder();
            if (orderTo.getLines().length <= 0) {
                MOrder orderFrom = new MOrder(Env.getCtx(), Integer.parseInt(this.cOrderLookupToCopy.getValue().toString()), null);
                int cantLinesCopy = this.copyLinesFrom(orderTo, orderFrom, true, false);
                orderTo.set_CustomColumn("OrderType2", "REN");
                orderTo.set_CustomColumn("C_OrderRef_ID", orderFrom.get_ID());
                orderTo.setC_BPartner_ID(orderFrom.getC_BPartner_ID());
                orderTo.setC_BPartner_Location_ID(orderFrom.getC_BPartner_Location_ID());
                orderTo.save();
                this.updatePriceOLines(orderTo, this.p_posPanel.f_bpartner.getM_PriceList_Version_ID(), -1);
                this.p_posPanel.f_bpartner.f_name.setValue(orderFrom.getC_BPartner().getName());
                this.p_posPanel.f_bpartner.setC_BPartner_ID(orderFrom.getC_BPartner_ID());
                this.p_posPanel.f_bpartner.fillCombos();
                KeyNamePair pBPartnert = new KeyNamePair(orderFrom.getC_BPartner_Location_ID(), orderFrom.getC_BPartner_Location().getName());
                this.p_posPanel.f_bpartner.f_location.setValue(pBPartnert);
                this.p_posPanel.f_bpartner.f_Bpartner.setValue(null);
                this.p_posPanel.f_bpartner.f_locationShip.setValue(null);
                this.p_posPanel.f_bpartner.f_bSearch.setReadWrite(false);
                SubFunctionKeys.ID_Level = cantLinesCopy + 1;
                SubFunctionKeys.ID_LevelPrice = cantLinesCopy + 1;
                this.p_posPanel.f_functionKeys.removeAll();
                this.p_posPanel.f_functionKeys.init();
            }
        } else if (action.equals("Summary")) {
            this.displaySummary();
        } else if (action.equals("Process")) {
            MOrder order = this.p_posPanel.f_curLine.getOrder();
            if (!SubCheckout.validStock(order, order.get_TrxName())) {
                this.p_posPanel.f_status.setStatusLine("ERROR: Problemas de Stock");
                JOptionPane.showMessageDialog(null, "ERROR: Problemas de Stock");
            } else if (SubCheckout.validCantLinePL(order, order.get_TrxName()) > 0) {
                this.p_posPanel.f_status.setStatusLine("ERROR: Pedido debe incluir al menos " + SubCheckout.validCantLinePL(order, order.get_TrxName()) + " l\u00edneas por restricci\u00f3n de la lista de precios");
                JOptionPane.showMessageDialog(null, "ERROR: Pedido debe incluir al menos " + SubCheckout.validCantLinePL(order, order.get_TrxName()) + " l\u00edneas por restricci\u00f3n de la lista de precios");
            } else {
                DB.executeUpdate("UPDATE C_OrderLine SET IsConfirmed = 'Y' WHERE C_Order_ID = " + order.get_ID(), order.get_TrxName());
                this.displaySummary();
                if (this.processOrder()) {
                    this.openCashDrawer();
                    this.ID_lastOrder = this.p_posPanel.f_curLine.getOrder().get_ID();
                    this.p_posPanel.newOrder();
                    this.f_cashGiven.setValue(Env.ZERO);
                    this.p_posPanel.f_status.setStatusLine("ORDEN INGRESADA");
                    this.p_posPanel.f_bpartner.f_bSearch.setReadWrite(true);
                }
                this.p_posPanel.f_functionKeys.removeAll();
                SubFunctionKeys.ID_Level = 1;
                SubFunctionKeys.ID_LevelPrice = 1;
                SubFunctionKeys.ID_BotonHide = "0";
                this.p_posPanel.f_functionKeys.init();
                this.p_posPanel.f_salesRep.setQty(Env.ONE);
                this.f_PriceList.setEditable(true);
                this.f_PriceList.setReadWrite(true);
                this.cOrderLookup.setVisible(true);
                this.cOrderLookup.setValue(this.ID_lastOrder);
                this.dateField.setReadWrite(true);
                this.p_posPanel.f_bpartner.f_name.setReadWrite(true);
                this.p_posPanel.f_bpartner.f_name.setEditable(true);
                this.p_posPanel.f_bpartner.f_bSearch.setReadWrite(true);
                this.p_posPanel.f_bpartner.f_location.setReadWrite(true);
                this.p_posPanel.f_bpartner.f_location.setEditable(true);
            }
        } else if (action.equals("Print")) {
            if (this.isOrderFullyPay()) {
                this.displaySummary();
                this.printTicket();
                this.openCashDrawer();
            } else {
                this.p_posPanel.f_status.setStatusLine("Order not fully paid.");
            }
        } else if (action.equals("Cash")) {
            this.displayReturn();
            this.openCashDrawer();
        } else if (action.equals("CashRegisterFunction")) {
            this.p_posPanel.openQuery(this.p_posPanel.f_cashfunctions);
        } else if (e.getSource() == this.f_cashGiven) {
            this.displayReturn();
        } else if (action.equals("Aplicar LP")) {
            this.p_posPanel.f_status.setStatusLine("");
            MOrder order = this.p_posPanel.f_curLine.getOrder();
            KeyNamePair pl = (KeyNamePair)this.f_PriceList.getSelectedItem();
            MPriceList pListNew = new MPriceList(Env.getCtx(), pl.getKey(), null);
            int levePListOld = DB.getSQLValue(null, "SELECT LevelNo FROM M_PriceList WHERE M_PriceList_ID=" + order.getM_PriceList_ID());
            if (pl != null) {
                if (order.getLines().length > 0) {
                    if (pListNew.get_ValueAsInt("LevelNo") < levePListOld) {
                        this.p_posPanel.f_status.setStatusLine("ERROR: Incorrect Price List");
                        KeyNamePair plOld = new KeyNamePair(order.getM_PriceList_ID(), order.getM_PriceList().getName());
                        this.f_PriceList.setSelectedItem(plOld);
                        JOptionPane.showMessageDialog(null, "ERROR: Incorrect Price List");
                    } else {
                        order.setM_PriceList_ID(pl.getKey());
                        order.save();
                        this.p_pos.setM_PriceList_ID(pl.getKey());
                        this.p_posPanel.f_bpartner.setM_PriceList_Version_ID(pl.getKey());
                        this.updatePriceOLines(order, this.p_posPanel.f_bpartner.getM_PriceList_Version_ID(), -1);
                    }
                } else {
                    order.setM_PriceList_ID(pl.getKey());
                    order.save();
                    this.p_pos.setM_PriceList_ID(pl.getKey());
                    this.p_posPanel.f_bpartner.setM_PriceList_Version_ID(pl.getKey());
                    SubFunctionKeys.ID_Level = 1;
                    SubFunctionKeys.ID_LevelPrice = 1;
                    SubFunctionKeys.ID_BotonHide = "0";
                    this.p_posPanel.f_functionKeys.removeAll();
                    this.p_posPanel.f_functionKeys.init();
                }
            }
            this.displaySummary();
        } else if (action.equals("Confirmar")) {
            this.p_posPanel.f_checkout.f_PriceList.setReadWrite(false);
            this.p_posPanel.f_checkout.f_PriceList.setEditable(false);
            MOrderLine[] oLines = this.p_posPanel.f_curLine.getOrder().getLines(" AND IsConfirmed = 'N' ", "line");
            int i = 0;
            while (i < oLines.length) {
                MOrderLine line = oLines[i];
                line.setQty((BigDecimal)this.p_posPanel.f_salesRep.f_quantity.getValue());
                line.setLineNetAmt();
                line.setTax();
                line.set_CustomColumn("IsConfirmed", true);
                line.save();
                ++i;
            }
            this.p_posPanel.updateInfo();
            this.p_posPanel.f_salesRep.setQty(Env.ONE);
            SubFunctionKeys.ID_Level = 1;
            SubFunctionKeys.ID_LevelPrice = 1;
            SubFunctionKeys.ID_BotonHide = "0";
            this.p_posPanel.f_functionKeys.removeAll();
            this.p_posPanel.f_functionKeys.init();
        } else if (e.getSource() == this.cOrderLookupToCopy) {
            this.cOrderLookupToCopy.setValue(this.cOrderLookupToCopy.getValue());
        }
        this.p_posPanel.updateInfo();
    }

    public void displaySummary() {
        this.p_posPanel.f_status.setStatusLine(this.p_posPanel.f_curLine.getOrder().getSummary());
        this.displayReturn();
    }

    public boolean processOrder() {
        boolean orderCompleted = false;
        this.p_posPanel.setCursor(Cursor.getPredefinedCursor(3));
        MOrder order = this.p_posPanel.f_curLine.getOrder();
        if (order != null && order.getDocStatus().equals("DR")) {
            order.setC_BPartner_Location_ID(this.p_posPanel.f_bpartner.getC_BPartner_Location_ID());
            order.setDocAction("CO");
            order.setDocStatus("IP");
            order.save();
            order = null;
            orderCompleted = true;
            log.info("SubCheckout - processOrder OK");
            this.p_posPanel.f_status.setStatusLine("Order completed.");
        }
        this.p_posPanel.setCursor(Cursor.getDefaultCursor());
        return orderCompleted;
    }

    public void printTicket() {
        MOrder order = this.p_posPanel.f_curLine.getOrder();
        if (order != null) {
            try {
                ReportCtl.startDocumentPrint(10, order.getC_Order_ID(), null, Env.getWindowNo(this), true);
            }
            catch (Exception e) {
                log.severe("PrintTicket - Error Printing Ticket");
            }
        }
    }

    public void displayReturn() {
        BigDecimal given = new BigDecimal(this.f_cashGiven.getValue().toString());
        if (this.p_posPanel != null && this.p_posPanel.f_curLine != null) {
            MOrder order = this.p_posPanel.f_curLine.getOrder();
            BigDecimal total = new BigDecimal(0);
            if (order != null) {
                this.f_DocumentNo.setText(order.getDocumentNo());
                total = order.getGrandTotal();
            }
            double cashReturn = given.doubleValue() - total.doubleValue();
            this.f_cashReturn.setValue(new BigDecimal(cashReturn));
        }
    }

    public boolean isOrderFullyPay() {
        BigDecimal given = new BigDecimal(this.f_cashGiven.getValue().toString());
        boolean paid = false;
        if (this.p_posPanel != null && this.p_posPanel.f_curLine != null) {
            MOrder order = this.p_posPanel.f_curLine.getOrder();
            MDocType dt = MDocType.get(Env.getCtx(), order.getC_DocTypeTarget_ID());
            if (dt.getDocSubTypeSO().equals("WP") || dt.getDocSubTypeSO().equals("RM")) {
                return true;
            }
            BigDecimal total = new BigDecimal(0);
            if (order != null) {
                total = order.getGrandTotal();
            }
            paid = given.doubleValue() >= total.doubleValue();
        }
        return paid;
    }

    public void openCashDrawer() {
    }

    public void fillCombos() {
        Vector<KeyNamePair> PListVector;
        block7: {
            PListVector = new Vector<KeyNamePair>();
            if (this.f_PriceList != null) {
                String sqlPList = null;
                MUser userC = new MUser(this.p_ctx, Env.getAD_User_ID(Env.getCtx()), null);
                sqlPList = "SELECT M_PriceList_ID FROM M_PriceList WHERE M_PriceList_ID IN (  SELECT pl.M_PriceList_ID FROM M_PriceList pl  INNER JOIN C_BPartnerPriceList bpl ON pl.M_PriceList_ID = bpl.M_PriceList_ID WHERE pl.IsActive = 'Y' AND bpl.IsActive = 'Y' AND pl.IsSOPriceList = 'Y'  AND pl.IsInBPartner = 'Y' AND bpl.C_BPartner_ID = " + this.p_posPanel.f_bpartner.getC_BPartner_ID() + " UNION SELECT pl.M_PriceList_ID FROM M_PriceList pl " + " INNER JOIN AD_UserPriceList upl ON pl.M_PriceList_ID = upl.M_PriceList_ID " + " WHERE pl.IsActive = 'Y' AND upl.IsActive = 'Y' AND pl.IsSOPriceList = 'Y' " + " AND pl.IsInUser = 'Y' AND upl.AD_User_ID = " + Env.getAD_User_ID(Env.getCtx()) + " UNION SELECT pl.M_PriceList_ID FROM M_PriceList pl " + " INNER JOIN AD_RolePriceList rpl ON pl.M_PriceList_ID = rpl.M_PriceList_ID " + " WHERE pl.IsActive = 'Y' AND rpl.IsActive = 'Y' AND pl.IsSOPriceList = 'Y'  " + " AND ((pl.IsInChannel = 'Y' AND rpl.C_Channel_ID = " + userC.get_ValueAsInt("C_Channel_ID") + ") " + " \tOR (pl.IsInRole = 'Y' AND rpl.AD_Role_ID =" + Env.getAD_Role_ID(Env.getCtx()) + ") " + "\tOR (pl.IsInPTerm = 'Y' ))" + " UNION SELECT pl.M_PriceList_ID FROM M_PriceList pl " + " WHERE pl.IsActive = 'Y' AND pl.IsSOPriceList = 'Y' AND pl.IsInUser = 'N' " + " AND pl.IsInBPartner = 'N' AND pl.IsInRole = 'N' " + " AND pl.IsInPTerm = 'N' AND pl.IsInChannel = 'N' " + " AND pl.AD_Client_ID = " + Env.getAD_Client_ID(Env.getCtx()) + ")" + " AND (dateStart IS NULL OR dateStart < now()) AND (dateEnd IS NULL OR dateEnd > now())" + " ORDER BY name";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sqlPList, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            MPriceList pList = new MPriceList(Env.getCtx(), rs.getInt("M_PriceList_ID"), null);
                            PListVector.add(pList.getKeyNamePair());
                        }
                        rs.close();
                        pstmt.close();
                        pstmt = null;
                    }
                    catch (SQLException e3) {
                        log.config("error" + e3 + " SQL: " + sqlPList);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DefaultComboBoxModel pListModel = new DefaultComboBoxModel(PListVector);
        this.f_PriceList.setModel((ComboBoxModel)pListModel);
        KeyNamePair pListDefault = new KeyNamePair(this.p_pos.getM_PriceList().getM_PriceList_ID(), this.p_pos.getM_PriceList().getName());
        this.f_PriceList.setValue(pListDefault);
        MOrder order = this.p_posPanel.f_curLine.getOrder();
        order.setM_PriceList_ID(pListDefault.getKey());
        order.save();
        this.p_posPanel.f_bpartner.setM_PriceList_Version_ID(pListDefault.getKey());
    }

    public void updatePriceOLines(MOrder order, int ID_pListVersion, int id_level) {
        if (id_level < 0) {
            id_level = DB.getSQLValue(order.get_TrxName(), "SELECT COUNT(1) from m_productprice  where m_pricelist_version_id = " + this.getM_PriceList_Version_ID(order) + " and levels = 1 " + " and addlevel = 'Y' and m_product_id in " + "  ( select m_product_id from c_orderline where c_order_id = " + order.get_ID() + ")");
        }
        if (id_level < 1) {
            id_level = 1;
        }
        MOrderLine[] oLines = order.getLines(" AND IsConfirmed = 'N' ", "line");
        int i = 0;
        while (i < oLines.length) {
            MOrderLine line = oLines[i];
            BigDecimal amt = null;
            String sqlAmt = "";
            if (id_level == 1) {
                try {
                    sqlAmt = "SELECT PriceList FROM M_ProductPrice WHERE IsActive = 'Y'  AND M_Product_ID = " + line.getM_Product_ID() + " AND Levels = " + id_level + " AND M_PriceList_Version_ID = " + ID_pListVersion;
                    amt = DB.getSQLValueBD(null, sqlAmt, new Object[0]);
                }
                catch (Exception e2) {
                    log.config("error" + e2 + " SQL: " + sqlAmt);
                    amt = Env.ZERO;
                }
            } else if (id_level > 1) {
                try {
                    sqlAmt = "SELECT Price FROM M_ProductPriceRef WHERE IsActive = 'Y'  AND M_Product_ID = " + line.getM_Product_ID() + " AND Levels = " + id_level + " AND M_PriceList_Version_ID = " + ID_pListVersion;
                    amt = DB.getSQLValueBD(null, sqlAmt, new Object[0]);
                }
                catch (Exception e2) {
                    log.config("error" + e2 + " SQL: " + sqlAmt);
                    amt = Env.ZERO;
                }
            }
            if (amt != null) {
                line.setPrice(amt);
                line.setLineNetAmt();
                line.setTax();
                line.save();
            }
            ++i;
        }
    }

    public int copyLinesFrom(MOrder toOrder, MOrder otherOrder, boolean counter, boolean copyASI) {
        if (toOrder.isProcessed() || toOrder.isPosted() || toOrder == null) {
            return 0;
        }
        MOrderLine[] fromLines = otherOrder.getLines(" AND IsFree = 'N' AND M_Product_ID > 0  AND M_Product_ID NOT IN  (SELECT M_Product_ID FROM M_Product mp  INNER JOIN M_Product_Category mpc ON mpc.M_Product_Category_ID = mp.M_Product_Category_ID  WHERE mpc.description like 'NOEDITORIAL')", "line");
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            MOrderLine line = new MOrderLine(otherOrder);
            SubCheckout.copyValues(fromLines[i], line, toOrder.getAD_Org_ID());
            line.setC_Order_ID(toOrder.getC_Order_ID());
            line.setQtyDelivered(Env.ZERO);
            line.setQtyInvoiced(Env.ZERO);
            line.setQtyReserved(Env.ZERO);
            line.setDateDelivered(null);
            line.setDateInvoiced(null);
            line.setOrder(toOrder);
            int I_ZERO = new Integer(0);
            line.set_ValueNoCheck("C_OrderLine_ID", I_ZERO);
            if (!copyASI) {
                line.setM_AttributeSetInstance_ID(0);
                line.setS_ResourceAssignment_ID(0);
            }
            if (counter) {
                line.setRef_OrderLine_ID(fromLines[i].getC_OrderLine_ID());
            } else {
                line.setRef_OrderLine_ID(0);
            }
            line.setLink_OrderLine_ID(0);
            if (toOrder.getC_BPartner_ID() != otherOrder.getC_BPartner_ID()) {
                line.setTax();
            }
            line.set_CustomColumn("C_BpartnerRef_ID", fromLines[i].get_ValueAsInt("C_BpartnerRef_ID"));
            line.setC_BPartner_Location_ID(fromLines[i].getC_BPartner_Location_ID());
            line.setProcessed(false);
            line.set_CustomColumn("DatePromised2", null);
            line.set_CustomColumn("DatePromised3", null);
            line.set_CustomColumn("IsConfirmed", false);
            if (line.save(toOrder.get_TrxName())) {
                ++count;
            }
            if (counter) {
                fromLines[i].setRef_OrderLine_ID(line.getC_OrderLine_ID());
                fromLines[i].save(toOrder.get_TrxName());
            }
            SubFunctionKeys.ID_BotonHide = String.valueOf(SubFunctionKeys.ID_BotonHide) + "," + line.getM_Product_ID();
            ++i;
        }
        if (fromLines.length != count) {
            log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public static void copyValues(PO from, PO to, int AD_Org_ID) {
        PO.copyValues(from, to);
        to.setAD_Org_ID(AD_Org_ID);
    }

    public static boolean validStock(MOrder order, String Trx2) {
        return COPESAOrderOps.validStock(order, false);
    }

    public static int validCantLinePL(MOrder order, String Trx2) {
        MPriceList pList;
        int cantLinePL;
        int cant = DB.getSQLValue(Trx2, "select count(1) from c_orderline col join c_order co on (co.c_order_id = col.c_order_id)  join m_product mp on (mp.m_product_id = col.m_product_id)  where mp.description not in ('FULLSD')  and col.isactive = 'Y' and c_orderlineref_id is null  and co.c_order_id = " + order.get_ID());
        if (cant < (cantLinePL = (pList = new MPriceList(Env.getCtx(), order.getM_PriceList_ID(), Trx2)).get_ValueAsInt("minLevel"))) {
            return cantLinePL;
        }
        return 0;
    }

    public int getM_PriceList_Version_ID(MOrder order) {
        int M_PriceList_ID = order.getM_PriceList_ID();
        MPriceList pl = MPriceList.get(this.p_ctx, M_PriceList_ID, null);
        MPriceListVersion plv = pl.getPriceListVersion(this.p_posPanel.getToday());
        if (plv != null && plv.getM_PriceList_Version_ID() != 0) {
            return plv.getM_PriceList_Version_ID();
        }
        return -1;
    }
}

