/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.compiere.apps.ConfirmPanel;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.MRole;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class QueryBPartner
extends PosSubPanel
implements ActionListener,
MouseListener,
ListSelectionListener {
    private static final long serialVersionUID = -7109518709654253628L;
    private MiniTable m_table;
    private CPanel northPanel;
    private CScrollPane centerScroll;
    private ConfirmPanel confirm;
    private CTextField f_value;
    private CTextField f_name;
    private CTextField f_contact;
    private CTextField f_email;
    private CTextField f_phone;
    private CTextField f_city;
    private CButton f_up;
    private CButton f_down;
    private int m_C_BPartner_ID;
    private static CLogger log = CLogger.getCLogger(QueryBPartner.class);
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "C_BPartner_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Value"), "Value", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Email"), "Email", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Phone"), "Phone", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Postal"), "Postal", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "City"), "City", String.class)};
    private static String s_sqlFrom = "RV_BPartner";
    private static String s_sqlWhere = "IsActive='Y'";

    public QueryBPartner(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    protected void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.setVisible(false);
        this.northPanel = new CPanel(new GridBagLayout());
        this.add((Component)this.northPanel, "North");
        this.northPanel.setBorder(new TitledBorder(Msg.getMsg(this.p_ctx, "Query")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = PosSubPanel.INSETS2;
        gbc.gridy = 0;
        gbc.gridx = -1;
        CLabel lvalue = new CLabel(Msg.translate(this.p_ctx, "Value"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lvalue, gbc);
        this.f_value = new CTextField(10);
        this.f_value.setText("%");
        lvalue.setLabelFor(this.f_value);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_value, gbc);
        this.f_value.addActionListener(this);
        CLabel lcontact = new CLabel(Msg.translate(this.p_ctx, "Contact"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lcontact, gbc);
        this.f_contact = new CTextField(10);
        lcontact.setLabelFor(this.f_contact);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_contact, gbc);
        this.f_contact.addActionListener(this);
        CLabel lphone = new CLabel(Msg.translate(this.p_ctx, "Phone"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lphone, gbc);
        this.f_phone = new CTextField(10);
        lphone.setLabelFor(this.f_phone);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_phone, gbc);
        this.f_phone.addActionListener(this);
        gbc.gridy = 1;
        CLabel lname = new CLabel(Msg.translate(this.p_ctx, "Name"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lname, gbc);
        this.f_name = new CTextField(10);
        this.f_name.setText("%");
        lname.setLabelFor(this.f_name);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_name, gbc);
        this.f_name.addActionListener(this);
        CLabel lemail = new CLabel(Msg.translate(this.p_ctx, "Email"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lemail, gbc);
        this.f_email = new CTextField(10);
        lemail.setLabelFor(this.f_email);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_email, gbc);
        this.f_email.addActionListener(this);
        CLabel lcity = new CLabel(Msg.translate(this.p_ctx, "City"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lcity, gbc);
        this.f_city = new CTextField(10);
        lcity.setLabelFor(this.f_city);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_city, gbc);
        this.f_city.addActionListener(this);
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.anchor = 13;
        gbc.weightx = 0.1;
        this.f_up = this.createButtonAction("Previous", KeyStroke.getKeyStroke(38, 0));
        this.northPanel.add((Component)this.f_up, gbc);
        gbc.weightx = 0.0;
        this.f_down = this.createButtonAction("Next", KeyStroke.getKeyStroke(40, 0));
        this.northPanel.add((Component)this.f_down, gbc);
        this.confirm = new ConfirmPanel(true, true, true, false, false, false, false);
        this.add((Component)this.confirm, "South");
        this.confirm.addActionListener(this);
        this.m_table = new MiniTable();
        String sql = String.valueOf(this.m_table.prepareTable(s_layout, s_sqlFrom, s_sqlWhere, false, "RV_BPartner")) + " ORDER BY Value ";
        log.config("sql: " + sql);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setMultiSelection(false);
        this.m_table.addMouseListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.enableButtons();
        this.centerScroll = new CScrollPane(this.m_table);
        this.add((Component)this.centerScroll, "Center");
    }

    @Override
    protected GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 0.1;
        gbc.weighty = 0.5;
        return gbc;
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.northPanel = null;
        this.centerScroll = null;
        this.confirm = null;
        this.m_table = null;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.f_value.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand());
        if ("Refresh".equals(e.getActionCommand()) || e.getSource() == this.f_value || e.getSource() == this.f_name) {
            this.setResults(this.findBPWhitLimit(this.p_ctx, this.f_value.getText(), this.f_name.getText(), null, this.f_email.getText(), this.f_phone.getText(), this.f_city.getText(), 500));
            return;
        }
        if ("Reset".equals(e.getActionCommand())) {
            this.f_value.setText(null);
            this.f_name.setText(null);
            this.f_contact.setText(null);
            this.f_email.setText(null);
            this.f_phone.setText(null);
            this.f_city.setText(null);
            this.setResults(new MBPartnerInfo[0]);
            return;
        }
        if ("Previous".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (--row < 0) {
                row = 0;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        if ("Next".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (++row >= rows) {
                row = rows - 1;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        this.close();
    }

    public void setResults(MBPartnerInfo[] results) {
        this.m_table.loadTable(results);
        this.enableButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableButtons();
    }

    private void enableButtons() {
        Integer ID;
        boolean enabled;
        this.m_C_BPartner_ID = -1;
        int row = this.m_table.getSelectedRow();
        boolean bl = enabled = row != -1;
        if (enabled && (ID = this.m_table.getSelectedRowKey()) != null) {
            this.m_C_BPartner_ID = ID;
        }
        this.confirm.getOKButton().setEnabled(enabled);
        log.fine("C_BPartner_ID=" + this.m_C_BPartner_ID);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && this.m_table.getSelectedRow() != -1) {
            this.enableButtons();
            this.close();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void close() {
        log.fine("C_BPartner_ID=" + this.m_C_BPartner_ID);
        if (this.m_C_BPartner_ID > 0) {
            this.p_posPanel.f_bpartner.setC_BPartner_ID(this.m_C_BPartner_ID);
        } else {
            this.p_posPanel.f_bpartner.setC_BPartner_ID(0);
        }
        this.p_posPanel.closeQuery(this);
    }

    public MBPartnerInfo[] findBPWhitLimit(Properties ctx, String Value, String Name2, String Contact, String EMail2, String Phone, String City, int CLimit) {
        StringBuffer sql = new StringBuffer("SELECT * FROM RV_BPartner WHERE IsActive='Y'");
        StringBuffer sb = new StringBuffer();
        if (Value != null) {
            sb.append("UPPER(Value) LIKE ?");
        }
        if (Name2 != null) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("UPPER(Name) LIKE ?");
        }
        if (Contact != null) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("UPPER(ContactName) LIKE ?");
        }
        if (EMail2 != null) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("UPPER(EMail) LIKE ?");
        }
        if (Phone != null) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("UPPER(Phone) LIKE ?");
        }
        if (City != null) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("UPPER(City) LIKE ?");
        }
        if (sb.length() > 0) {
            sql.append(" AND (").append(sb).append(")");
        }
        sql.append(" ORDER BY Value");
        String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), "RV_BPartner", false, false);
        ArrayList<MBPartnerInfo> list = new ArrayList<MBPartnerInfo>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(finalSQL, null);
            int index = 1;
            if (Value != null) {
                pstmt.setString(index++, Value);
            }
            if (Name2 != null) {
                pstmt.setString(index++, Name2);
            }
            if (Contact != null) {
                pstmt.setString(index++, Contact);
            }
            if (EMail2 != null) {
                pstmt.setString(index++, EMail2);
            }
            if (Phone != null) {
                pstmt.setString(index++, Phone);
            }
            if (City != null) {
                pstmt.setString(index++, City);
            }
            pstmt.setMaxRows(CLimit);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBPartnerInfo(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "find - " + finalSQL, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MBPartnerInfo[] retValue = new MBPartnerInfo[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

