/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.AppsAction;
import org.compiere.model.MCurrency;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPOS;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPaymentValidate;
import org.compiere.pos.PosBasePanel;
import org.compiere.pos.PosKeyListener;
import org.compiere.pos.PosOrderModel;
import org.compiere.pos.PosTextField;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class PosPayment
extends CDialog
implements PosKeyListener,
VetoableChangeListener,
ActionListener {
    private static final long serialVersionUID = 1961106531807910948L;
    private PosBasePanel p_posPanel;
    private MPOS p_pos;
    private Properties p_ctx;
    private PosOrderModel p_order;
    private CTextField fTotal = new CTextField(10);
    private CTextField fBalance = new CTextField(10);
    private CComboBox tenderTypePick = new CComboBox();
    private PosTextField fPayAmt;
    private CButton f_bProcess;
    private boolean paid = false;
    private BigDecimal balance = Env.ZERO;
    private PosTextField fCheckAccountNo;
    private PosTextField fCheckNo;
    private PosTextField fCheckRouteNo;
    private PosTextField fCCardNo;
    private PosTextField fCCardName;
    private CComboBox fCCardType;
    private PosTextField fCCardMonth;
    private PosTextField fCCardVC;
    private CLabel lCheckNo;
    private CLabel lCheckAccountNo;
    private CLabel lCheckRouteNo;
    private CLabel lCCardNo;
    private CLabel lCCardName;
    private CLabel lCCardType;
    private CLabel lCCardMonth;
    private CLabel lCCardVC;
    private PosTextField fTenderAmt;
    private CLabel lTenderAmt;
    private PosTextField fReturnAmt;
    private CLabel lReturnAmt;
    private CButton f_bCancel;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.fTenderAmt) || e.getSource().equals(this.fPayAmt)) {
            BigDecimal tender = new BigDecimal(this.fTenderAmt.getText());
            BigDecimal pay = new BigDecimal(this.fPayAmt.getText());
            if (tender.compareTo(Env.ZERO) != 0) {
                this.fReturnAmt.setValue(tender.subtract(pay));
            }
            return;
        }
        if (e.getSource().equals(this.f_bProcess)) {
            this.processPayment();
        }
        if (e.getSource().equals(this.f_bCancel)) {
            this.dispose();
            return;
        }
        this.setTotals();
        super.actionPerformed(e);
    }

    private void processPayment() {
        try {
            String tenderType = ((ValueNamePair)this.tenderTypePick.getValue()).getID();
            BigDecimal amt = new BigDecimal(this.fPayAmt.getText());
            if (tenderType.equals("X")) {
                this.p_posPanel.m_order.payCash(amt);
            } else if (tenderType.equals("K")) {
                this.p_posPanel.m_order.payCheck(amt, this.fCheckAccountNo.getText(), this.fCheckRouteNo.getText(), this.fCheckNo.getText());
                this.p_posPanel.f_order.openCashDrawer();
            } else if (tenderType.equals("C")) {
                String error = null;
                error = MPaymentValidate.validateCreditCardExp(this.fCCardMonth.getText());
                if (error != null && !error.isEmpty()) {
                    ADialog.warn(0, this.p_posPanel, error);
                    return;
                }
                int month = MPaymentValidate.getCreditCardExpMM(this.fCCardMonth.getText());
                int year = MPaymentValidate.getCreditCardExpYY(this.fCCardMonth.getText());
                String type = ((ValueNamePair)this.fCCardType.getSelectedItem()).getValue();
                error = MPaymentValidate.validateCreditCardNumber(this.fCCardNo.getText(), type);
                if (error != null && !error.isEmpty()) {
                    ADialog.warn(0, this.p_posPanel, error);
                    return;
                }
                this.p_posPanel.m_order.payCreditCard(amt, this.fCCardName.getText(), month, year, this.fCCardNo.getText(), this.fCCardVC.getText(), type);
                this.p_posPanel.f_order.openCashDrawer();
            } else if (tenderType.equals("T")) {
                this.p_posPanel.m_order.payCash(amt);
                this.p_posPanel.f_order.openCashDrawer();
            } else {
                ADialog.warn(0, this, "Unsupported payment type");
            }
            this.p_posPanel.f_order.openCashDrawer();
            this.setTotals();
        }
        catch (Exception e) {
            ADialog.warn(0, this, "Payment processing failed: " + e.getMessage());
        }
    }

    public PosPayment(PosBasePanel posPanel) {
        super((Frame)Env.getFrame(posPanel), true);
        this.p_posPanel = posPanel;
        this.p_pos = posPanel.p_pos;
        this.p_ctx = this.p_pos.getCtx();
        this.p_order = this.p_posPanel.m_order;
        if (this.p_order == null) {
            this.dispose();
        }
        this.init();
        this.pack();
        this.setLocationByPlatform(true);
    }

    private void init() {
        Font font = AdempierePLAF.getFont_Field().deriveFont(18.0f);
        CPanel mainPanel = new CPanel((LayoutManager)new MigLayout("hidemode 3", "[100:100:300, trailing]20[200:200:300,grow, trailing]"));
        this.getContentPane().add(mainPanel);
        mainPanel.setBorder(new TitledBorder(Msg.translate(this.p_ctx, "Payment")));
        CLabel gtLabel = new CLabel(Msg.translate(this.p_ctx, "GrandTotal"));
        mainPanel.add((Component)gtLabel, "growx");
        mainPanel.add((Component)this.fTotal, "wrap, growx");
        this.fTotal.setEditable(false);
        this.fTotal.setFont(font);
        this.fTotal.setHorizontalAlignment(11);
        mainPanel.add((Component)new CLabel(Msg.translate(this.p_ctx, "Balance")), "growx");
        mainPanel.add((Component)this.fBalance, "wrap, growx");
        this.fBalance.setEditable(false);
        this.fBalance.setFont(font);
        this.fBalance.setHorizontalAlignment(11);
        mainPanel.add(new CLabel(Msg.translate(this.p_ctx, "TenderType"), "growx"));
        int AD_Column_ID = 8416;
        MLookup lookup = MLookupFactory.get(Env.getCtx(), 0, 0, AD_Column_ID, 17);
        ArrayList<Object> types = lookup.getData(true, false, true, true);
        DefaultComboBoxModel<Object> typeModel = new DefaultComboBoxModel<Object>(types.toArray());
        this.tenderTypePick.setModel((ComboBoxModel)typeModel);
        for (Object obj : types) {
            if (!(obj instanceof ValueNamePair)) continue;
            ValueNamePair key = (ValueNamePair)obj;
            if (key.getID().equals("X")) {
                this.tenderTypePick.setSelectedItem(key);
            }
            if ("CKX".contains(key.getID())) continue;
            this.tenderTypePick.removeItem(key);
        }
        this.tenderTypePick.setFont(font);
        this.tenderTypePick.addActionListener(this);
        this.tenderTypePick.setRenderer(new ListCellRenderer(){
            protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                renderer.setPreferredSize(new Dimension(50, 50));
                renderer.setHorizontalAlignment(0);
                return renderer;
            }
        });
        mainPanel.add((Component)this.tenderTypePick, "wrap, h 50!, growx");
        this.fPayAmt = new PosTextField(Msg.translate(this.p_ctx, "PayAmt"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), DisplayType.getNumberFormat(12));
        mainPanel.add((Component)new CLabel(Msg.translate(this.p_ctx, "PayAmt")), "growx");
        this.fPayAmt.setFont(font);
        this.fPayAmt.setHorizontalAlignment(11);
        this.fPayAmt.addActionListener(this);
        mainPanel.add((Component)this.fPayAmt, "wrap, growx");
        this.fTenderAmt = new PosTextField(Msg.translate(this.p_ctx, "AmountTendered"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), DisplayType.getNumberFormat(12));
        this.lTenderAmt = new CLabel(Msg.translate(this.p_ctx, "AmountTendered"));
        mainPanel.add((Component)this.lTenderAmt, "growx");
        this.fTenderAmt.addActionListener(this);
        this.fTenderAmt.setFont(font);
        this.fTenderAmt.setHorizontalAlignment(11);
        mainPanel.add((Component)this.fTenderAmt, "wrap, growx");
        this.fReturnAmt = new PosTextField(Msg.translate(this.p_ctx, "AmountReturned"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), DisplayType.getNumberFormat(12));
        this.lReturnAmt = new CLabel(Msg.translate(this.p_ctx, "AmountReturned"));
        mainPanel.add((Component)this.lReturnAmt, "growx");
        this.fReturnAmt.setFont(font);
        this.fReturnAmt.setHorizontalAlignment(11);
        mainPanel.add((Component)this.fReturnAmt, "wrap, growx");
        this.fReturnAmt.setEditable(false);
        this.fCheckRouteNo = new PosTextField(Msg.translate(this.p_ctx, "RoutingNo"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), new DecimalFormat("#"));
        this.lCheckRouteNo = new CLabel(Msg.translate(this.p_ctx, "RoutingNo"));
        mainPanel.add((Component)this.lCheckRouteNo, "growx");
        mainPanel.add((Component)this.fCheckRouteNo, "wrap, growx");
        this.fCheckRouteNo.setFont(font);
        this.fCheckRouteNo.setHorizontalAlignment(11);
        this.fCheckAccountNo = new PosTextField(Msg.translate(this.p_ctx, "AccountNo"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), new DecimalFormat("#"));
        this.lCheckAccountNo = new CLabel(Msg.translate(this.p_ctx, "AccountNo"));
        mainPanel.add((Component)this.lCheckAccountNo, "growx");
        mainPanel.add((Component)this.fCheckAccountNo, "wrap, growx");
        this.fCheckAccountNo.setFont(font);
        this.fCheckAccountNo.setHorizontalAlignment(11);
        this.fCheckNo = new PosTextField(Msg.translate(this.p_ctx, "CheckNo"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), new DecimalFormat("#"));
        this.lCheckNo = new CLabel(Msg.translate(this.p_ctx, "CheckNo"));
        mainPanel.add((Component)this.lCheckNo, "growx");
        mainPanel.add((Component)this.fCheckNo, "wrap, growx");
        this.fCheckNo.setFont(font);
        this.fCheckNo.setHorizontalAlignment(11);
        Object[] ccs = this.p_order.getCreditCards((BigDecimal)this.fPayAmt.getValue());
        this.fCCardType = new CComboBox(ccs);
        this.fCCardType.setRenderer(new ListCellRenderer(){
            protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                renderer.setPreferredSize(new Dimension(50, 50));
                renderer.setHorizontalAlignment(0);
                return renderer;
            }
        });
        this.lCCardType = new CLabel(Msg.translate(this.p_ctx, "CreditCardType"));
        mainPanel.add((Component)this.lCCardType, "growx");
        mainPanel.add((Component)this.fCCardType, "h 50, wrap, growx");
        this.fCCardType.setFont(font);
        this.fCCardNo = new PosTextField(Msg.translate(this.p_ctx, "CreditCardNumber"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), new DecimalFormat("#"));
        this.lCCardNo = new CLabel(Msg.translate(this.p_ctx, "CreditCardNumber"));
        mainPanel.add((Component)this.lCCardNo, "growx");
        mainPanel.add((Component)this.fCCardNo, "wrap, growx");
        this.fCCardNo.setFont(font);
        this.fCCardNo.setHorizontalAlignment(11);
        this.fCCardName = new PosTextField(Msg.translate(this.p_ctx, "Name"), this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        this.lCCardName = new CLabel(Msg.translate(this.p_ctx, "Name"));
        mainPanel.add((Component)this.lCCardName, "growx");
        mainPanel.add((Component)this.fCCardName, "wrap, growx");
        this.fCCardName.setFont(font);
        this.fCCardName.setHorizontalAlignment(11);
        this.fCCardMonth = new PosTextField(Msg.translate(this.p_ctx, "Expires"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), new DecimalFormat("#"));
        this.lCCardMonth = new CLabel(Msg.translate(this.p_ctx, "Expires"));
        mainPanel.add((Component)this.lCCardMonth, "growx");
        mainPanel.add((Component)this.fCCardMonth, "wrap, w 75!");
        this.fCCardMonth.setFont(font);
        this.fCCardMonth.setHorizontalAlignment(11);
        this.fCCardVC = new PosTextField(Msg.translate(this.p_ctx, "CVC"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), new DecimalFormat("#"));
        this.lCCardVC = new CLabel(Msg.translate(this.p_ctx, "CVC"));
        mainPanel.add((Component)this.lCCardVC, "growx");
        mainPanel.add((Component)this.fCCardVC, "wrap, w 75!");
        this.fCCardVC.setFont(font);
        this.fCCardVC.setHorizontalAlignment(11);
        AppsAction actCancel = new AppsAction("Cancel", KeyStroke.getKeyStroke(10, 0), false);
        actCancel.setDelegate(this);
        this.f_bCancel = (CButton)actCancel.getButton();
        this.f_bCancel.setFocusable(false);
        mainPanel.add((Component)this.f_bCancel, "h 50!, w 50!, skip, split 2, trailing");
        AppsAction act = new AppsAction("Ok", KeyStroke.getKeyStroke(10, 0), false);
        act.setDelegate(this);
        this.f_bProcess = (CButton)act.getButton();
        this.f_bProcess.setFocusable(false);
        mainPanel.add((Component)this.f_bProcess, "h 50!, w 50!");
        this.pack();
        this.setTotals();
    }

    private void setTotals() {
        String tenderType = ((ValueNamePair)this.tenderTypePick.getValue()).getID();
        boolean cash = "X".equals(tenderType);
        boolean check = "K".equals(tenderType);
        boolean creditcard = "C".equals(tenderType);
        boolean account = "T".equals(tenderType);
        this.fTenderAmt.setVisible(cash);
        this.fReturnAmt.setVisible(cash);
        this.lTenderAmt.setVisible(cash);
        this.lReturnAmt.setVisible(cash);
        this.fCheckAccountNo.setVisible(check);
        this.fCheckNo.setVisible(check);
        this.fCheckRouteNo.setVisible(check);
        this.lCheckAccountNo.setVisible(check);
        this.lCheckNo.setVisible(check);
        this.lCheckRouteNo.setVisible(check);
        this.fCCardMonth.setVisible(creditcard);
        this.fCCardName.setVisible(creditcard);
        this.fCCardNo.setVisible(creditcard);
        this.fCCardType.setVisible(creditcard);
        this.fCCardVC.setVisible(creditcard);
        this.lCCardMonth.setVisible(creditcard);
        this.lCCardName.setVisible(creditcard);
        this.lCCardNo.setVisible(creditcard);
        this.lCCardType.setVisible(creditcard);
        this.lCCardVC.setVisible(creditcard);
        this.fTotal.setValue(this.p_order.getGrandTotal());
        BigDecimal received = this.p_order.getPaidAmt();
        this.balance = this.p_order.getGrandTotal().subtract(received);
        this.balance = this.balance.setScale(MCurrency.getStdPrecision(this.p_ctx, this.p_order.getC_Currency_ID()));
        if (this.balance.compareTo(Env.ZERO) <= 0) {
            this.paid = true;
            if (this.balance.compareTo(Env.ZERO) < 0) {
                ADialog.warn(0, this, Msg.getMsg(this.p_ctx, "Change") + ": " + this.balance);
            }
            this.dispose();
        }
        this.fBalance.setValue(this.balance);
        this.fPayAmt.setValue(this.balance);
        if (!"X".equals(tenderType)) {
            this.fPayAmt.requestFocusInWindow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PosPayment.this.fPayAmt.selectAll();
                }
            });
        } else {
            this.fTenderAmt.requestFocusInWindow();
        }
        this.pack();
    }

    @Override
    public void keyReturned(MPOSKey key) {
        String text = key.getText();
        String payAmt = this.fPayAmt.getText();
        String selected = this.fPayAmt.getSelectedText();
        if (selected != null && !selected.isEmpty()) {
            payAmt = payAmt.replaceAll(selected, "");
        }
        if (text != null && !text.isEmpty()) {
            if (text.equals(".") && payAmt.indexOf(".") == -1) {
                this.fPayAmt.setText(payAmt + text);
                return;
            }
            try {
                Integer.parseInt(text);
                this.fPayAmt.setText(payAmt + text);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public static boolean pay(PosBasePanel posPanel) {
        PosPayment pay = new PosPayment(posPanel);
        pay.setVisible(true);
        return pay.isPaid();
    }

    private boolean isPaid() {
        return this.paid;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent arg0) throws PropertyVetoException {
    }
}

