/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.model.MPOS;
import org.compiere.pos.CashSubFunctions;
import org.compiere.pos.PosKeyboardFocusManager;
import org.compiere.pos.QueryBPartner;
import org.compiere.pos.QueryProduct;
import org.compiere.pos.QueryTicket;
import org.compiere.pos.SubBPartner;
import org.compiere.pos.SubCheckout;
import org.compiere.pos.SubCurrentLine;
import org.compiere.pos.SubFunctionKeys;
import org.compiere.pos.SubLines;
import org.compiere.pos.SubProduct;
import org.compiere.pos.SubSalesRep;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PosPanel
extends CPanel
implements FormPanel {
    private static final long serialVersionUID = -3010214392188209281L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Properties m_ctx = Env.getCtx();
    private int m_SalesRep_ID = 0;
    protected MPOS p_pos = null;
    private PosKeyboardFocusManager m_focusMgr = null;
    protected StatusBar f_status = new StatusBar();
    protected SubBPartner f_bpartner = null;
    protected SubSalesRep f_salesRep = null;
    protected SubCurrentLine f_curLine = null;
    protected SubProduct f_product = null;
    protected SubLines f_lines = null;
    protected SubFunctionKeys f_functionKeys = null;
    protected SubCheckout f_checkout = null;
    protected QueryProduct f_queryProduct = null;
    protected QueryBPartner f_queryBPartner = null;
    protected QueryTicket f_queryTicket = null;
    protected CashSubFunctions f_cashfunctions;
    private Timestamp m_today = Env.getContextAsDate(this.m_ctx, "#Date");
    private KeyboardFocusManager originalKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();

    public PosPanel() {
        super(new GridBagLayout());
        this.m_focusMgr = new PosKeyboardFocusManager();
        KeyboardFocusManager.setCurrentKeyboardFocusManager(this.m_focusMgr);
    }

    @Override
    public void init(int WindowNo, FormFrame frame) {
        frame.setMaximize(true);
        this.m_SalesRep_ID = Env.getAD_User_ID(this.m_ctx);
        this.log.info("init - SalesRep_ID=" + this.m_SalesRep_ID);
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            if (!this.dynInit()) {
                this.dispose();
                frame.dispose();
                return;
            }
            frame.getContentPane().add((Component)this, "Center");
            frame.getContentPane().add((Component)this.f_status, "South");
            this.setPreferredSize(new Dimension(830, 480));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "init", e);
        }
        this.log.config("PosPanel.init - " + this.getPreferredSize());
        this.m_focusMgr.start();
    }

    @Override
    public void dispose() {
        if (this.m_focusMgr != null) {
            this.m_focusMgr.stop();
        }
        this.m_focusMgr = null;
        KeyboardFocusManager.setCurrentKeyboardFocusManager(this.originalKeyboardFocusManager);
        if (this.f_bpartner != null) {
            this.f_bpartner.dispose();
        }
        this.f_bpartner = null;
        if (this.f_salesRep != null) {
            this.f_salesRep.dispose();
        }
        this.f_salesRep = null;
        if (this.f_curLine != null) {
            this.f_curLine.deleteOrder();
            this.f_curLine.dispose();
        }
        this.f_curLine = null;
        if (this.f_product != null) {
            this.f_product.dispose();
        }
        this.f_product = null;
        if (this.f_lines != null) {
            this.f_lines.dispose();
        }
        this.f_lines = null;
        if (this.f_functionKeys != null) {
            this.f_functionKeys.dispose();
        }
        this.f_functionKeys = null;
        if (this.f_checkout != null) {
            this.f_checkout.dispose();
        }
        this.f_checkout = null;
        if (this.f_queryProduct != null) {
            this.f_queryProduct.dispose();
        }
        this.f_queryProduct = null;
        if (this.f_queryBPartner != null) {
            this.f_queryBPartner.dispose();
        }
        this.f_queryBPartner = null;
        if (this.f_queryTicket != null) {
            this.f_queryTicket.dispose();
        }
        this.f_queryTicket = null;
        if (this.f_cashfunctions != null) {
            this.f_cashfunctions.dispose();
        }
        this.f_cashfunctions = null;
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
        this.m_ctx = null;
    }

    private boolean dynInit() {
        if (!this.setMPOS()) {
            return false;
        }
        this.f_bpartner = new SubBPartner(this);
        this.add((Component)this.f_bpartner, this.f_bpartner.getGridBagConstraints());
        this.f_salesRep = new SubSalesRep(this);
        this.add((Component)this.f_salesRep, this.f_salesRep.getGridBagConstraints());
        this.f_curLine = new SubCurrentLine(this);
        this.add((Component)this.f_curLine, this.f_curLine.getGridBagConstraints());
        this.f_product = new SubProduct(this);
        this.add((Component)this.f_product, this.f_product.getGridBagConstraints());
        this.f_lines = new SubLines(this);
        this.add((Component)this.f_lines, this.f_lines.getGridBagConstraints());
        SubFunctionKeys.ID_BotonHide = "0";
        SubFunctionKeys.ID_Level = 1;
        this.f_functionKeys = new SubFunctionKeys(this);
        this.add((Component)this.f_functionKeys, this.f_functionKeys.getGridBagConstraints());
        this.f_checkout = new SubCheckout(this);
        this.add((Component)this.f_checkout, this.f_checkout.getGridBagConstraints());
        this.f_queryProduct = new QueryProduct(this);
        this.add((Component)this.f_queryProduct, this.f_queryProduct.getGridBagConstraints());
        this.f_queryBPartner = new QueryBPartner(this);
        this.add((Component)this.f_queryBPartner, this.f_queryBPartner.getGridBagConstraints());
        this.f_queryTicket = new QueryTicket(this);
        this.add((Component)this.f_queryTicket, this.f_queryTicket.getGridBagConstraints());
        this.f_cashfunctions = new CashSubFunctions(this);
        this.add((Component)this.f_cashfunctions, this.f_cashfunctions.getGridBagConstraints());
        this.f_checkout.ID_lastOrder = this.f_curLine.getOrder().get_ID();
        if (this.f_curLine.getOrderWhitOutCreate() == null) {
            this.newOrder();
        } else {
            this.updateInfo();
        }
        return true;
    }

    private boolean setMPOS() {
        String title;
        MPOS[] poss = null;
        poss = this.getPOSs(0);
        if (poss.length == 0) {
            ADialog.error(this.m_WindowNo, this.m_frame, "NoPOSForUser");
            return false;
        }
        if (poss.length == 1) {
            this.p_pos = poss[0];
            return true;
        }
        Object[] SelectionPos = new Object[poss.length];
        int x = 0;
        while (x < poss.length) {
            SelectionPos[x] = poss[x].getDisplayName();
            ++x;
        }
        String msg = Msg.getMsg(this.m_ctx, "SelectPOS");
        Object selection = JOptionPane.showInputDialog(this.m_frame, msg, title = Env.getHeader(this.m_ctx, this.m_WindowNo), 3, null, SelectionPos, SelectionPos[0]);
        if (selection != null) {
            this.p_pos = poss[0].getPosbyDisplay((String)selection);
            return true;
        }
        return false;
    }

    private MPOS[] getPOSs(int SalesRep_ID) {
        String pass_field = "SalesRep_ID";
        int pass_ID = SalesRep_ID;
        if (SalesRep_ID == 0) {
            pass_field = "AD_Client_ID";
            pass_ID = Env.getAD_Client_ID(this.m_ctx);
        }
        return MPOS.getAll(this.m_ctx, pass_field, pass_ID);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.f_product.f_name.requestFocus();
    }

    public void openQuery(CPanel panel) {
        this.f_bpartner.setVisible(false);
        this.f_salesRep.setVisible(false);
        this.f_curLine.setVisible(false);
        this.f_product.setVisible(false);
        this.f_checkout.setVisible(false);
        this.f_lines.setVisible(false);
        this.f_functionKeys.setVisible(false);
        panel.setVisible(true);
    }

    public void closeQuery(CPanel panel) {
        panel.setVisible(false);
        this.f_bpartner.setVisible(true);
        this.f_salesRep.setVisible(true);
        this.f_curLine.setVisible(true);
        this.f_product.setVisible(true);
        this.f_lines.setVisible(true);
        this.f_functionKeys.setVisible(true);
        this.f_checkout.setVisible(true);
    }

    public Timestamp getToday() {
        return this.m_today;
    }

    public void newOrder() {
        this.log.info("PosPanel.newOrder");
        this.f_bpartner.setC_BPartner_ID(0);
        this.f_curLine.newOrder();
        this.f_curLine.newLine();
        this.f_product.f_name.requestFocus();
        this.updateInfo();
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    public Properties getPropiedades() {
        return this.m_ctx;
    }

    public void updateInfo() {
        if (this.f_lines != null) {
            this.f_lines.updateTable(this.f_curLine.getOrder());
        }
        if (this.f_checkout != null) {
            this.f_checkout.displayReturn();
        }
    }

    public void updateBtn() {
        if (this.f_functionKeys != null) {
            this.f_functionKeys.removeAll();
            this.f_functionKeys.init();
        }
    }

    public FormFrame getm_frame() {
        return this.m_frame;
    }

    public int getm_SalesRep_ID() {
        return this.m_SalesRep_ID;
    }

    public PosKeyboardFocusManager getm_focusMgr() {
        return this.m_focusMgr;
    }

    public void setm_SalesRep_ID(int sr) {
        this.m_SalesRep_ID = sr;
    }

    public void setm_frame(FormFrame fr) {
        this.m_frame = fr;
    }

    public void setm_WindowNo(int w) {
        this.m_WindowNo = w;
    }

    public String getPosPassword() {
        return this.p_pos.getPassword();
    }
}

